package DeviceReport::3310;
use System;
use strict;
use DeviceReport;
use base 'DeviceReport';
use Agent::3310;



# no $q->{summary}                    # only frus,vols, system, id
# $q->{summary} = "controller.u1ctr." # this controller
# $q->{summary} = "controller."       # all controllers
# Main sections:
# <FRU> <LOGICAL> <SYSTEM> <ID>

sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  my $product_id = "$rep->{'info.Product'} $rep->{'info.unique_id'}";
  $S{SAN} = $class->san_info($report);

  my $order;

  # do not use $rep->{'id.ipno'} field to construct the device ip
  # as it sometimes means the ip of the host which the device is attched
  # ex. a 3310 device with ip 170.20.32.100 hooked to host server 172.20.32.22
  # 172.20.32.22 is filled into $rep->{'id.ipno'}
  

  $S{HEADER} = {
          device_name            => {order => 1, value => $rep->{'id.device_name'}},
          device_type            => {order => 2, value => $rep->{'id.device_type'} },
          device_key             => {order => 3, value => $rep->{'id.device_key'} },
          product_ID             => {order => 4, value => $product_id },
      };
  $order = 5; 

  foreach my $el (sort keys %$rep) {
     if ($el =~ /^info\.(.+)/)  {
       my $n = $1;
       next if (index( Agent::3310->report_exclude(), ",$n,") >= 0);
       if ($rep->{$el}) {
           $S{HEADER}{$n} = { order => $order, value => $rep->{$el} };
           $order++;
       }
     }
  }

  my (%WWN);
  foreach my $el (sort keys %$rep) {
     if ($el =~ /port.(\d+).id/) {
       my $no = $1;
       my $id = $rep->{$el};
       $WWN{$id} = $rep->{"port.$no.wwn"};
     }
  }
  
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $count = @L;
       my $k = "$L[0].$L[1]";
       next if (index($el, "fruDiskPerf") >= 0);
       if (!$summary) {
          if ($L[1] eq "disk" && $L[3] eq "model") {
              $k = "$L[0].$L[1].$L[2]";

              $S{FRU}{$k}            = { name    => $L[1], 
                                           id    => $k,
                                         state   => "",
                                         status  => $rep->{"$k.status"},
                                         type    => $rep->{"$k.fruType"},
                                         revision=> $rep->{"$k.product_revision"},
                                           model => $rep->{"$k.model"},
                                          vendor => $rep->{"$k.manufacturer"},
                                          serial => $rep->{"$k.serial_number"},
                                         keyLabel=> "serialno",
                                         keyValue=> $rep->{"$k.serial_number"},
                                       };

          } elsif ($L[0] eq "fru") {
              my $name = $rep->{"$k.fru_location"} || $k;
              my $fru_status= undef;
              $fru_status = $rep->{"$k.fru_status"} if ($rep->{"$k.fru_status"}); 
              $S{FRU}{$k}            = { name    => $name,
                                           id    => $k,
                                         state   => "",
                                         status  => $fru_status,
                                         type    => $rep->{"$k.description"},
                                         revision=> $rep->{"$k.revision"},
                                           model => $rep->{"$k.part_number"},
                                          vendor => $rep->{"$k.manufacturer_jedec_id"},
                                          serial => $rep->{"$k.serial_number"},
                                         keyLabel=> "serialno",
                                         keyValue=> $rep->{"$k.serial_number"},
                                       };

          } elsif ($L[0] eq "channel") {

                 my $wwn;
                 if ($rep->{"$k.mode"} eq "Host") {
                     $wwn = $WWN{$rep->{"$k.sid"}} || $WWN{$rep->{"$k.pid"}};
                 } else {
                     $wwn = "N/A";
                 }
                 my ($chan, $tem) = split(/\./, $k);
                 my $name = $chan.$rep->{"$k.idx"};
                 my $id = $name;
                 my $stat = undef;
                 $stat = $rep->{"$k.curclk"} if ($rep->{"$k.curclk"}); 
                 $S{PORT}{$k} = {name => $name,
                                   id => $id,
                               state  => $stat,
                               status => "",
                               serial => $wwn,
                             keyLabel => "WWN",
                             keyValue => $wwn,
                                 type => $rep->{"$k.type"} . "/" . $rep->{"$k.curclk"},
                                       };
          } elsif ($L[0] eq "system") {
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } elsif ($L[0] eq "logical_drive" && $L[2] eq "status")  {
              $S{LOGICAL}{$k} =  { name => $k,
                                    id  => $k,
                                  type  => "logical_drive",
                                 status => $rep->{"$k.status"},
                
                                 };

          } elsif ($L[0] eq "logical_volume" && $L[2] eq "status")  {
		      $S{LOGICAL}{$k} =  { name => $k,
					    id  => $k,
					  type  => "logical_volume",
					 status => $rep->{"$k.status"},
					 };
						   
          } elsif ($L[0] eq "enclosure" && $L[1] eq "component") {
		      $k = "$L[0].$L[1].$L[2]";
		      my $name = $rep->{"$k.type"};
                      my $id   = $rep->{"$k.fru-pn"}."/".$rep->{"$k.fru-sn"}; 
                     if ( $name eq "temp") { 
		          $S{COMPONENT}{$k} = { name    => $name,
                                                  id    =>  $id,
                                                status  => $rep->{"$k.status"},
                                                 type   => $rep->{"$k.type"},
                                                 value  => $rep->{"$k.temp"}, 
                                              };
                      } else {
                          $S{COMPONENT}{$k} = { name    => $name,
                                                  id    =>  $id,
                                                status  => $rep->{"$k.status"},
                                                 type   => $rep->{"$k.type"},
                                              };

                      }


          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          if ($count > 4) {
                 my $newel = "$L[0].$L[1].$L[2].$L[3].$L[4]";
                 $out .= "   <VALUE ID=\"$newel\">$rep->{$el}</VALUE>\n";
          }elsif ($L[3]) {
                 my $newel = "$L[1].$L[2].$L[3]";
                 $out .= "   <VALUE ID=\"$newel\">$rep->{$el}</VALUE>\n";
          } else { 
                 $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
          }

       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return (\%S, $out);
}




1;
