package Client::VolVerify;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Client;
use PDM::ConfigFile;
use strict;
use Process;
use Html;
use Html::Tabs;
use PDM;

#
# Display the vol verify options.
#
sub getOptions {
  my ($q) = @_;

  my $passwd = System->getPassword('array');

  my ($renv, $dev, $host, $notifs);
  ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read();
  print Client->http_OK();
  print "<VOL_VERIFY>\n";
  print "  <MODE>$renv->{volVerify}</MODE>\n";
  print "  <FIX_OPTION>$renv->{'volVerify.fix'}</FIX_OPTION>\n";
  print "  <RATE>$renv->{'volVerify.rate'}</RATE>\n";
  print "  <FREQUENCY>$renv->{'volVerify.frequency'}</FREQUENCY>\n";
  print "  <SUNDAY>$renv->{'volVerify.time0'}</SUNDAY>\n";
  print "  <MONDAY>$renv->{'volVerify.time1'}</MONDAY>\n";
  print "  <TUESDAY>$renv->{'volVerify.time2'}</TUESDAY>\n";
  print "  <WEDNESDAY>$renv->{'volVerify.time3'}</WEDNESDAY>\n";
  print "  <THURSDAY>$renv->{'volVerify.time4'}</THURSDAY>\n";
  print "  <FRIDAY>$renv->{'volVerify.time5'}</FRIDAY>\n";
  print "  <SATURDAY>$renv->{'volVerify.time6'}</SATURDAY>\n";
  print "  <ONCE_A_MONTH>$renv->{'volVerify.once_a_month'}</ONCE_A_MONTH>\n";
  print "  <DEFAULT_ARRAY_PASSWD>$passwd</DEFAULT_ARRAY_PASSWD>\n";
  print "</VOL_VERIFY>\n";

}

#
# Set the vol verify options.
#
sub setOptions {
  my($q, $post) = @_;

  my ($renv, $dev, $host, $notifs);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  print Client->http_OK();
  print "<VOL_VERIFY_SETUP>\n";

  $renv->{volVerify}	  = $q->{volVerify} ? "Y": "N";
  $renv->{'volVerify.fix'}	  = $q->{fix}	    ? "Y": "N";
  $renv->{'volVerify.rate'}  = $q->{rate};
  $renv->{'volVerify.frequency'}  = $q->{freq};
  my $x;
  for ($x=0; $x <= 6; $x++) {
    $renv->{"volVerify.time$x"}  = $q->{"time$x"};
    $renv->{"volVerify.time$x"}  = "" if($q->{ACTION_reset});
  }
  $renv->{'volVerify.once_a_month'}  = $q->{once_a_month} ? "Y" : "N";
  if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
    print "  <ERROR>error</ERROR>\n";
  } else {
    System->set_renv($renv);
    print "  <STATUS>ok</STATUS>\n";
  }
  print "</VOL_VERIFY_SETUP>\n";

}

#
# Stop Vol Verify
#
sub kill {
  my ($renv, $dev, $host,$notifs);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  foreach my $h (@$host) {
    Util::Http->runit($h->{ipno}, "/sbin/volverify -k -b&");
  }
  system(System->get_home() . "/sbin/volverify -k -b");
  print Client->http_OK();
  print "<STATUS>OK</STATUS>\n";
}

sub process {
  my($out, $db) = @_;
  my $VAR1;
  if ($out) {
    eval $out;
    foreach my $el (keys %$VAR1) {
      $db->{$el} = $VAR1->{$el} if (!exists($db->{$el}));
    }
  }
}

#
# Report of the devices under Vol-Verify control
#
sub report {
  print Client->http_OK();
  print "<VOL_VERIFY_REPORT>\n";
  my ($renv, $devs, $hosts, $notifs);
  ($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();

  my $L	 = Labels->read("GUI::VolVerify");
  my $G	 = Labels->read();

  my $db = Util->deserializeDir("VolVerify");

  my (@array, %D, $x, %H);

  for ($x=0; $x <= $#$devs; $x++) {
    my $d = $devs->[$x];
    next if (index(",t3,6020,6120,", ",$d->{type},") < 0);
    $H{$d->{host}} = 1;
    my $host = $d->{host} || $renv->{hostname};
    $d->{no} = $x;
    $D{"$host.$d->{key}"} = $d;

  }


# Bug 6189030: The cause is that "Util::Http->readFile($h->{ipno}, "VolVerify/")" doesn't work
# since "VolVerify" is a directory, not a file. The fix is to read each file one by one.

  foreach my $h (@$hosts) {
    next if (!$H{$h->{hostname}});
    for ($x=0; $x <= $#$devs; $x++) {
      my $d = $devs->[$x];
      next if (index(",t3,6020,6120,", ",$d->{type},") < 0);
      next if ($d->{host} ne $h->{hostname});
      my $data = Util::Http->readFile($h->{ipno}, "VolVerify/" . $d->{key});
      &process($data, $db);
    }
  }

#  foreach my $h (@$hosts) {
#    next if (!$H{$h->{hostname}});
#    my $data = Util::Http->readFile($h->{ipno}, "VolVerify/");
#    my @lines = split(/\n/, $data);
#    my ($var, $VAR1);
#    foreach my $l (@lines) {
#      if ($l =~ /\$VAR1/) {
#        &process($var, $db);
#        $var = $l;
#      } else {
#        $var .= $l;
#      }
#    }
#    &process($var, $db);
#  }

  my $last;
  foreach my $name (sort keys %D) {
     my $d = $D{$name};
     my $scrubbing="off";
     (my $readerr, my $rep1) = Report->readReport($d->{type}.":".$d->{key}, "*");
     if ($rep1) {
       my $v = $rep1->value(); 
       $scrubbing="on" if($v->{"system.sysDiskScrubber"} eq "on");
     }
     my $el = $db->{$d->{ipno}};
     my $host = $d->{host} || $renv->{hostname};

     my $ver = $d->{volVerify} || $renv->{volVerify};
     my $progress = $el->{progress};
     $progress .= "%" if ($progress =~ /^\d+/);
     my $type2 = uc($d->{type});
     my $url = "<sort $d->{name}><a href=javascript:win1('$type2','$d->{no}')>$d->{name} / $d->{ipno}</a>";
     my $host1 = Util->shortHostname($host);
     my $end;

     if ($progress eq "ABORTED") {
       $end   = $el->{abort_date};

     } elsif ($el->{end}) {
       $progress = "DONE";
       $end   = substr($el->{end},5);

     } elsif ($el->{start}) {
       $end   = $G->{running};
     }

     my $vols = $el->{VOL};
     my $list  = ",";
     foreach my $v (keys %$vols) {
          $list .= "$v,";
     }
     if ($scrubbing eq "on"){
       $ver = $L->{scrubber};
       push(@array, [ $host1, $d->{ipno}, $ver,]); 
       next;
     #
     # ADD TO REPORT ONLY IF IT'S NOT IN THE VOLUME SECTION(VOL) OR IT'S CURRENTLY RUNNING.
     #
     } elsif ($el->{volume} && (index($list, ",$el->{volume},") < 0 || !$el->{end})) {
       push(@array, [ $host1, $d->{name}, $d->{key}, $d->{type}, $d->{ipno}, "$ver", "$el->{volume_name} $el->{volume}", 
                    substr($el->{start},5), $end, "", "", $progress ]);
     }

     my $vols = $el->{VOL};
     #
     # SHOW VOLUMES THAT ARE NOT CURRENTLY RUNNING.
     #
     foreach my $v (keys %$vols) {
        my $el2 = $vols->{$v};
        next if (!$el2->{end});
        my $dur_h = int($el2->{duration} / 60/60);
        my $dur_m = int($el2->{duration}/60) - $dur_h * 60;
        my $dur_display;
        if ($el2->{start}) {
           $dur_display = sprintf("%2.2d:%2.2d:00", $dur_h, $dur_m);
        } else {
           $dur_display = "";
        }
        my $err;
        foreach my $en ('soft','firm','hard') {
          $err = ucfirst($en) . ":$el2->{$en}," if ($el2->{$en});
        }
        chop($err) if ($err);
        $err = $G->{none} if (!$err);

        push(@array, [ $host1, $d->{name}, $d->{key}, $d->{type}, $d->{ipno}, $ver, "$el2->{volume_name} $el2->{volume}", 
                    substr($el2->{start},5), 
                    substr($el2->{end},5), $dur_display,
                    $err, "DONE"]);
     }
  }

  for ($x=0; $x <= $#array; $x++) {
    my $host      = $array[$x][0];
    my $name      = $array[$x][1];
    my $key       = $array[$x][2];
    my $type      = $array[$x][3];
    my $ip        = $array[$x][4];
    my $verify    = $array[$x][5];
    my $volume    = $array[$x][6];
    my $startDate = $array[$x][7];
    my $endDate   = $array[$x][8];
    my $duration  = $array[$x][9];
    my $errors    = $array[$x][10];
    my $status    = $array[$x][11];
    
    print "  <DEVICE>\n";
    print "    <HOST>$host</HOST>\n";
    print "    <NAME>" . Client->xmlEncode($name) . "</NAME>\n";
    print "    <KEY>" . Client->xmlEncode($key) . "</KEY>\n";
    print "    <TYPE>$type</TYPE>\n";
    print "    <IP>$ip</IP>\n";
    print "    <VERIFY>$verify</VERIFY>\n";
    print "    <VOLUME>$volume</VOLUME>\n";
    print "    <START_DATE>$startDate</START_DATE>\n";
    print "    <END_DATE>$endDate</END_DATE>\n";
    print "    <DURATION>$duration</DURATION>\n";
    print "    <ERRORS>$errors</ERRORS>\n";
    print "    <STATUS>$status</STATUS>\n";
    print "  </DEVICE>\n";
  }
  print "</VOL_VERIFY_REPORT>\n";

}

#
# Log of the process to kill vol verify processes
#
sub log {
  my ($q) = @_;
  open(0, System->get_home() . "/DATA/tmp/volverify.out");
  my ($l, $out, $done);
  while ($l = <0>) {
    $out .= $l;
    $done = 1 if ($l =~ /^EXIT/);
  }
  close(0);
  print Client->http_OK();
  print "<LOG>\n$out</LOG>\n";
}

1;


 
