package Client::TO;
use System;
use TO;
use strict;
use Client;
use Util;

#
# schedule the removal of topology and all the hba devices on master and slaves
# occurs only when the agent runs
#
sub clearTopo {
  my($q) = @_;
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  $renv->{reset_topology} = time;
  PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);
  my $DIR =  System->get_home() . "/DATA/topo";
  opendir(O, $DIR);
  my @files = readdir(O);
  foreach my $f (@files) {
     if (substr($f,0,1) ne ".") {
       unlink "$DIR/$f";
     }
  }
}


sub compareSnapshot {

  my($q) = @_;
  my $TH = System->get_home() . "/DATA/topohist";
  my $t1 = $q->{topo1};
  my $t2 = $q->{topo2};

  my(@t1stat, @t2stat);
  @t1stat = stat($TH . $t1);
  @t2stat = stat($TH . $t2);
  # compare file times
  if ($t1stat[9] gt $t2stat[9]) {
    # move the oldest file to the first position
    my $save = $t1; $t1 = $t2; $t2 = $save;
  }

  my $topo1 = Util->deserialize("topohist/$t1");
  my $topo2 = Util->deserialize("topohist/$t2");
  my $diff = TO->diff($topo1, $topo2, 2);
 
  print Client->http_OK();
  print "<COMPARESNAPSHOT> \n";
  foreach my $l (@$diff) {
      print "<VALUE ID=\"$l->[0]\">$l->[2]</VALUE> \n";
  }
  print "</COMPARESNAPSHOT> \n";

}

sub listSnapshot {

  my($q) = @_;
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  my $TH = System->get_home() . "/DATA/topohist";
  
  opendir(O, $TH);
  my @D = readdir(O); closedir(O);
  my($curr);
  my ($date_list, @array, $to);

  print Client->http_OK();
  print "<SNAPSHOTLIST> \n";
  foreach my $f  (sort @D) {
    next if (substr($f,0,1) eq ".");
    next if ($f =~ /B_MERGE/);
    my $ix = rindex($f, ".");
    $to = substr($f, 0, $ix);
    print "<VALUE ID=\"$f\">$f</VALUE> \n";
  }
  print "</SNAPSHOTLIST> \n";
}

sub deleteSnapshot {
  my($q) = @_;
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  my $TH = System->get_home() . "/DATA/topohist";
  unlink "$TH/" . $q->{snapshot};
  print Client->http_OK();
  print "<DELETESNAPSHOT>$q->{snapshot}</DELETESNAPSHOT> \n";
}

sub takeSnapshot {
  my($q) = @_;
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();

  my $date1 = Util->get_today();
  Util->copyToHistory("topo/MERGE-MASTER","topohist","MERGE-MASTER", $date1, $renv->{topo_history_size});
  print Client->http_OK();
  print "<TAKESNAPSHOT>done</TAKESNAPSHOT> \n";
}


# Topology ID list

sub list {
  my($q) = @_;

  opendir(O, System->get_home() . "/DATA/topo");
  my @L = readdir(O); closedir(O);
 
  print Client->http_OK();

  print "<TOPOLIST>\n";

  foreach my $to (@L) {
     next if (substr($to,0,1) eq ".");
     print "  <TOPO ID=\"$to\"/>\n";
  }
  print "</TOPOLIST>\n";

}

# will return default topology when used with no argument
# http://ccadieux:80/rashttp?GO=Client::TO::details
# key is used to specify a topo (e.g., MERGE-MASTER)
# topo is used to specify the name of a historical topology.

sub details {
  my($q) = @_;

  my $key     = $q->{key};
  my $to_name = $q->{topo};

  my $to;

  if(!$to_name) {
    $to = TO->readExistingTopo($key);
  } else {
    $to = &readHistTopo($to_name);
  }

  print Client->http_OK();

  if(!$to) {
    print Client->error("xml", 1510, "$to_name");
    return;
  }

  print "<TOPOLOGY ID=\"$to_name\">\n" .
        $to->toXML(undef, 1) .
        "</TOPOLOGY>\n";
}

sub readHistTopo {
  my($snap) = @_;
  my($D) = System->get_home() . "/DATA/topohist";
  my(@lines, $VAR1);

  if (open(O, "$D/$snap")) {
    @lines = <O>; close(O);
    eval "@lines";
    if ($VAR1) {
      return $VAR1;
    }
  } 
}

###################################
# data needed for applet params

sub applet {
  my($q) = @_;

  print Client->http_OK();
  require GUI::Graph;
  my ($parms, $to, $dev_cnt,$zoom,$orient ) = TO::Applet->genAppletData($q);

  print "ZOOM=$zoom\nORIENT=$orient\n$parms";
}

sub put_get_topos {
  my($q, $post_data) = @_;
  print Client->http_OK();
  TO::put_topo_xy($q, $post_data);
}

1;

