package Client::System;
use Inventory;
use Logic::Ethers;
use strict;
use Client;

# 
# works with System1/maserati/Unity
#

sub inventory {
  my($q) = @_;
 
  my $inv = Inventory->readInventory();

  print Client->http_OK();

  print $inv->toXML();

}

#
# Initialize/Set up directories/permission
# for the Web server/UI as this one is running 
# as noaccess as is not allowed to perform
# these steps.
#
sub init {
  system("/usr/bin/ln -s /opt/SUNWstade/DATA/Download/ /var/opt/webconsole/webapps/storade/Download");
  system("/usr/bin/ln -s /var/crash /var/opt/webconsole/webapps/storade/Crash");
  print Client->http_OK();
  print "OK";
}

sub trays {
  my($q) = @_;
  my($renv, $devs) = PDM::ConfigFile->read();
  my %D;
  print Client->http_OK();
  my $summary;
  foreach my $d (@$devs) {
     $D{$d->{name}} = $d;
     if ($d->{class} eq "storage.se2") {
       $summary = "$d->{type}:$d->{key}";
     }
  }

  print "<SYSTEM>\n";
  print " <SYSTEM_ID>$renv->{cust_no}</SYSTEM_ID>\n";
  print " <SUMMARY>$summary</SUMMARY>\n";
  print " <RACK ID=\"0\">\n";
  my $tray_max = 12;
  print "   <TRAY_MAX>$tray_max</TRAY_MAX>\n";

  my($id, $t, $rack);
  my $lastrack = "0";
  my $tray = 1;
  my $hostid = System->hostid();

  $id++;
  print "   <TRAY NO=\"$id\">\n";
  print "     <NAME>sp</NAME>\n";
  print "     <KEY>sp:$hostid</KEY>\n";
  print "     <ORDER>12</ORDER>\n";
  print "     <DISPLAYTYPE>Service Processor</DISPLAYTYPE>\n";
  print "     <TRAYID>SP Tray</TRAYID>\n";
  print "     <RACK>0</RACK>\n";
  print "   </TRAY>\n";

  $id++;
  print "   <TRAY NO=\"$id\">\n";
  print "     <NAME>spatray</NAME>\n";
  print "     <ORDER>11</ORDER>\n";
  print "     <TRAYID>SPA Tray</TRAYID>\n";
  print "     <DISPLAYTYPE>SPA Tray</DISPLAYTYPE>\n";
  print "     <RACK>0</RACK>\n";
  print "   </TRAY>\n";

  $id++;
  print "   <TRAY NO=\"$id\">\n";
  print "     <NAME>hub</NAME>\n";
  print "     <ORDER>10</ORDER>\n";
  print "     <TRAYID>HUB Tray</TRAYID>\n";
  print "     <DISPLAYTYPE>Ethernet HUB</DISPLAYTYPE>\n";
  print "     <RACK>0</RACK>\n";
  print "   </TRAY>\n";

  foreach my $d0 (sort keys %D) {
      my $d = $D{$d0};
      if ($d->{type} eq "dsp") {
          $id++;
          print "   <TRAY NO=\"$id\">\n";
          print "     <NAME>$d->{name}</NAME>\n";
          print "     <IP>$d->{ipno}</IP>\n";
          print "     <KEY>dsp:$d->{key}</KEY>\n";
          print "     <ORDER>09</ORDER>\n";
          print "     <TRAYID>DSP Tray</TRAYID>\n";
          print "     <DISPLAYTYPE>Data Service Processor</DISPLAYTYPE>\n";
          print "     <RACK>0</RACK>\n";
          print "   </TRAY>\n";
      }
  }

  foreach my $d0 (sort keys %D) {
      my $d = $D{$d0};
      next if (index(",6020,6120,t3,", ",$d->{type},") < 0);
      my $n = $d->{name};
      $n =~ /array(\d+)/;
      $rack = substr($1,0,1);
      if ($rack ne $lastrack) {
          print " </RACK>\n";
          $lastrack = $rack;
          print " <RACK ID=\"$rack\">\n";
          print "   <TRAY_MAX>$tray_max</TRAY_MAX>\n";
      }
      my $tray_cnt = $d->{units};
      for ($t=1; $t <= $tray_cnt; $t++) {
          $id++;
          print "   <TRAY NO=\"$id\">\n";
          print "     <NAME>$d->{name}</NAME>\n";
          print "     <IP>$d->{ipno}</IP>\n";
          print "     <KEY>$d->{type}:$d->{key}</KEY>\n";
          print "     <TRAYID>Tray $rack$tray</TRAYID>\n";
          print "     <ORDER>$rack$tray</ORDER>\n";
          print "     <DISPLAYTYPE>Storage Array</DISPLAYTYPE>\n";
          print "     <RACK>$rack</RACK>\n";
          print "     <UNIT>u$t</UNIT>\n";
          print "   </TRAY>\n";
          $tray++;
      }
  }
  print "  </RACK>\n";
  print "</SYSTEM>\n";

}

sub ejectCD {
  my($q) = @_;

  if (-x "/usr/bin/eject") {
    print Client->http_OK();

    my $com = "/usr/bin/eject";
    my $rc = `$com 2>&1`;

    print "<COMMAND>\n";
    print "  <VALUE>$com</VALUE>\n";
    print "  <RESULT>$rc</RESULT>\n";
    print "</COMMAND>\n";

  } else {
     print Client->error("xml", 202, "Cannot execute command");
  }

}

################################################
#  CORE FILES
################################################
#
sub coreList {
  my($q) = @_;

  print Client->http_OK();
  require Service::Core;
  my $L = Service::Core::core_list();

  # make the directory rx by other than root
  # since Lockhart runs as noaccess and we want 
  # to enable direct access from Lockhart.
  foreach my $e (@$L) {
     my($id, $relative, $dev, $time, $path) = @$e;
     my $dir = "/var/crash/".$dev;
     system("/usr/bin/chmod a+rx $dir");
  }

  print "<COREFILES>\n";
  foreach my $e (@$L) {
     my($id, $relative, $dev, $time, $path) = @$e;
     print <<EOF;
  <CORE>
    <FILE>$id</FILE>
    <RELATIVE>$relative</RELATIVE>
    <DEVICE>$dev</DEVICE>
    <TIME>$time</TIME>
    <NAME>$path</NAME>
  </CORE>
EOF
  }

  print "</COREFILES>\n";
}

#
#  System::coreDelete&file=<filename>
#
sub coreDelete {
  my($q) = @_;

  require Service::Core;
  my $base = Service::Core->coreBase();
  
  if ($q->{file} && substr($q->{file}, 0, length($base)) eq $base) {
     print Client->http_OK();
     unlink $q->{file};
     print "<DELETED>$q->{file}</DELETED>\n";

  } else {
     print Client->error("xml", 301, "Invalid core file: $q->{file}");
  }
}


###################################################
# SOLUTION EXTRACT
###################################################
#
sub extractStart {
  my($q) = @_;
  my $pass = $q->{password} ; # optional
  require Service::Extract;
  if (Service::Extract::start($q)) {
     print Client->http_OK();
     print "<STARTED>Solution Extract</STARTED>";
  } else {
     print Client->error("xml", 302, "Error: Solution Extract already running");
  }
}

sub extractList {
  my($q) = @_;
  require Service::Extract;
  my $L = Service::Extract::list();

  print Client->http_OK();
  print "<EXTRACTS>\n";
  print Client->xmlHashList("EXTRACT", $L);
  print "</EXTRACTS>\n";
}

#
#  extractDelete&file=<download_url>
#
sub extractDelete {
  my($q) = @_;
  require Service::Extract;
  my $D = System->get_home() . "/DATA";
  if (-f "$D/$q->{file}") {
     print Client->http_OK();
     unlink "$D/$q->{file}";
     print "<DELETED>$q->{file}</DELETED>\n";
  } else {
     print Client->error("xml", 303, "Cannot delete $q->{file}: $!");
  }
}

sub logfile {
  my($q) = @_;
  print Client->http_OK();

  open(O, System->get_home() . "/DATA/Download/Solution/log_$q->{file}.txt");
  my @l = <O>;
  close(O);
  print join("", @l);
}

sub ether {
  my($q) = @_;
  print Client->http_OK();

  my $H = Logic::Ethers->readHosts("192.168");
  my (@array, @L);
  open(0, "/etc/hosts");
  print "<DEVICES>\n";
  foreach my $ip (sort keys %$H) {
    print "  <DEVICE>\n";
    print "    <IP>$ip</IP>\n";
    my $el = $H->{$ip};
    print "    <NAME>$el->[0]</NAME>\n";
    print "    <MAC>$el->[1]</MAC>\n";
    print "  </DEVICE>\n";
  }
  print "</DEVICES>\n";
  close(0);
}

sub updateEther {
  my($q) = @_;
  print Client->http_OK();

  my ($error, $new);
  my %E = &readEther();
  foreach my $el (sort %$q) {
    next if (substr($el,0,3) ne "et_");
    my $name = substr($el, 3);
    my $et = $q->{$el};
    $et = uc(Util->trim($et));
    if (!$et) {
      delete $E{$name};
      next;
    }
    if (!Logic::Ethers->valid($et)) {
      $error = "INVALID";
    } else {
      $new .= "$et\t$name\n";
      delete $E{$name};
    }
  }
  if (!$error) {
    foreach my $el (keys %E) {
      $new .= "$E{$el}\t$el\n";
    }
    open(O, ">/etc/ethers");
    print O $new;
    close(O);
    print "<STATUS>OK</STATUS>\n";
  } else {
    print "<STATUS>$error</STATUS>\n";
  }
}

sub readEther {
  my (%E,$l);
  open(O, "/etc/ethers");
  while ($l = <0>) {
    my($et, $name) = split(/\s+/, $l);
    $E{$name} = $et;
  }
  close(O);
  return %E;
}




1;
