package Client::6130Control;
use Client;
use strict;
use Events;
use Debug;
use Util;
use State;
use Java::TreefrogControls;

sub blinkArrayLEDs {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  print Client->http_OK();
  my $ret = Java::TreefrogControls->blinkArrayLEDs($deviceKey);
  if("OK" eq $ret) {
    print "<LED>$deviceKey</LED>";
  } else {
    print Client->error("xml", 1301, Client->xmlEncode($ret));
  }
 
}

sub blinkTrayLEDs {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $midplaneKey = $q->{fruID};
  print Client->http_OK();
  my $ret = Java::TreefrogControls->blinkTrayLEDs($deviceKey, $midplaneKey);
  if("OK" eq $ret) {
    print "<LED>$deviceKey</LED>";
  } else {
    print Client->error("xml", 1301, Client->xmlEncode($ret));
  }
}

sub blinkDriveLED {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $driveKey = $q->{fruID};
  print Client->http_OK();
  my $ret = Java::TreefrogControls->blinkDriveLED($deviceKey, $driveKey);
  if("OK" eq $ret) {
    print "<LED>$deviceKey</LED>";
  } else {
    print Client->error("xml", 1301, Client->xmlEncode($ret));
  }
}

sub stopLEDBlinking {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  print Client->http_OK();
  my $ret = Java::TreefrogControls->stopLEDBlinking($deviceKey);
  if("OK" eq $ret) {
    print "<LED>$deviceKey</LED>";
  } else {
    print Client->error("xml", 1301, Client->xmlEncode($ret));
  }
}

sub activateController {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $fruKey = $q->{fruID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->activateController($deviceKey, $fruKey);
  if("OK" eq $ret) {
    print "<CONTROLLER>$deviceKey, $fruKey</CONTROLLER>";
  } else {
    print Client->error("xml", 1302, Client->xmlEncode($ret));
  }
}

sub deactivateController {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $fruKey = $q->{fruID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->deactivateController($deviceKey, $fruKey);
  if("OK" eq $ret) {
    print "<CONTROLLER>$deviceKey, $fruKey</CONTROLLER>";
  } else {
    print Client->error("xml", 1303, Client->xmlEncode($ret));
  }
}

sub resetBattery {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $fruKey = $q->{fruID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->resetBattery($deviceKey, $fruKey);
  if("OK" eq $ret) {
    print "<BATTERY>$deviceKey, $fruKey</BATTERY>";
  } else {
    print Client->error("xml", 1304, Client->xmlEncode($ret));
  }
}



1;
