package Catalog::Implementation;
use System;
use Catalog::XML;

# file relative to SUNWstade
#
sub read {
  my($class, $file) = @_;

  my $imp = Catalog::XML->parseFile($file, 
          {  ROOT => 'implementation',
            hash  => { interface => 'name', 
                        property => 'name',
                        value    => 'name',
                     },
          });
  return $imp;
}


sub readAll {
  my($class, $dir) = @_;
  my %IMPL;
  $dir = System->get_home() if (!$dir);
  my $L = $dir . Catalog->device_path();
  opendir(R, $L);
  my @dirs = readdir(R); closedir(R);
  foreach my $d (@dirs) {
     next if (substr($d,0,1) eq ".");
     if (-f "$L/$d/implementation.xml") {
        my $i = $class->read( "$L/$d/implementation.xml");
        $i->{implementation}{_ATT}{BASE_DIR} = $dir;
        my $type = $i->{implementation}{_ATT}{type};
        $IMPL{$type} = $i;
        
     }
  }
  return \%IMPL;
}

1;

