package Agent::SAMFS;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 

#  $Id: SAMFS.pm,v 1.7 2004/09/13 22:42:47 bkeslin Exp $

use strict;
use Agent;
use base 'Agent';
use Util;
use Report;
use Data::Dumper; 
use DeviceReport;
use Labels;
use Util;


sub isSelectable {"Sun SAM-QFS"}

sub revision {'$Revision: 1.7 $'}
sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::SAMFS');
  return $self;
}
use vars qw($ERR );

sub RUN {
  my($agent, $static_list, $pass) = @_;
  my ($timelapse, $dc);
  my($renv) = System->get_renv();
  $DB::single = 1;
  my $processed_list = [];

  foreach my $dev ( $agent->deviceList($static_list) ) {
     next if ($dev->{active} eq "N");
     $dc++;  

     my $sys_report;
         my $connect_errs;
     my $local_ip = Util->name2ip();
     my $samfs_ip  = Util->name2ip($dev->{ipno});

     if ($local_ip eq $samfs_ip) {
     my $pk = System->getPackageInfo("", "SUNWsamfsr", "_ALL_");

       if ( $pk->{VERSION} !~ /^4.1/) {
         $sys_report = $agent->INSTRUMENTATION($dev);
         $sys_report->{"id.device_product_id"} = $pk->{NAME};

        if(exists $sys_report->{"samfm.pkg.version"}) {
        } else {
          $connect_errs = "Health monitoring can not communicate with SAM-QFS";
                  $sys_report->{'id.connect_errs'} = $connect_errs;
                }
       } 
     }
     my $wwn = $dev->{key};
     my $problems = PDM->get_last_event();
     my($id) = {
                 deviceName=> $dev->{key},
                 active    => $dev->{active},
                 logFile     => "",
                 class     => $dev->{class},
                 name      => $dev->{name},
                 display   => "$dev->{name} ($dev->{key})",
                 category  => Report::CAT_SAMAGENT,
                 ip        => $dev->{ipno},
                };

     $sys_report = {} if (!$sys_report);
     $agent->copyDev($dev, $sys_report);
     my $new_rep;

     if ($connect_errs) {   
       $new_rep = Report->new($id, $sys_report,undef, Report::STATUS_CANNOT_CONNECT );
     } else {
       $sys_report->{'id.name'}     = $dev->{name};
       $sys_report->{"id.mgmtLevel"}= $dev->{mgmtLevel};
       $sys_report->{"id.ip"}       = $dev->{ip};
       $sys_report->{"id.ipno"}     = $dev->{ipno};
       $sys_report->{"id.wwn"}      = $dev->{key};
       $new_rep = Report->new($id, $sys_report);
     }

     require Health::SAMFS;
     Health::SAMFS->all_logic($new_rep); 
     PDM->saveReport($new_rep);
     my ($broke, $abort) = $agent->new_events($problems, $dev, 1);
     push(@$processed_list, $dev);
     last if ($broke && $pass == 1 || $abort);
  }

  return $processed_list;
}

# FUNCTION: getWWN($ip, $host);
#  works local and remote, 
#  runs on the slave if needed and return an error if the sam version is wrong.
#
sub getWWN {
  my($class, $ip, $host) = @_;
  my $rc;

  my $VAR1;
  $ERR = undef;
  if ($host) {
      $rc = Util::Http->getCommand($host, "Agent::SAMFS::WWN&ip=$ip&HTTP=1", 10);
      if (substr($rc,0,3) eq "ERR") {
         $ERR = $rc;
         return undef;
      } else {
         eval substr($rc,3);
         $rc = $VAR1;
      }
  } else {
      $rc = get_WWN({ip => $ip});
  }
  return $rc;
}

sub get_WWN {

  my($q) = @_;
  my $renv = System->get_renv();
  my $rc;
  my $local_ip = Util->name2ip();
  $rc->{ipno}  = Util->name2ip($q->{ip});
  $rc->{ip}    = $q->{ip};
  $rc->{key}   = "samfs_$rc->{ipno}";
  $rc->{wwn}   = "N/A";
  $rc->{type}  = "samfs";
  $rc->{class} = "application.samfs";

  my($err, $pingout) = Util->run_command("/usr/sbin/ping $rc->{ipno}");

  if ($pingout->[0] !~ /alive$/ ) {
     $rc->{error} = "Can not ping $rc->{ipno}";

  } elsif ($local_ip eq $rc->{ipno} ) {
     my $pk = System->getPackageInfo("", "SUNWsamfsr", "_ALL_");
     $rc->{version} = $pk->{VERSION};
     $rc->{product} = $pk->{NAME};
     
     if ($rc->{version} < "4.1") {
        if (defined($rc->{version})) {
          $rc->{error} = "Current version $rc->{version} must be 4.1 or higher.";
        } else {
          my $old_pk = System->getPackageInfo("", "SUNWsamfs", "_ALL_");
          $rc->{error} = "Current version $old_pk->{VERSION} must be 4.1 or higher.";
        }
     }
  }

  if ($q->{HTTP}) {
    require Data::Dumper;
    print "OK " . Data::Dumper::Dumper($rc);
  } else {
    return $rc;
  }
}


sub INSTRUMENTATION {
  my($agent, $device) = @_;
  my(@s, %dev, $in, %info);

  return Report->readTest($device) if (System->get_testMode());

  my $report = {};
  my $prefix     = "";
  my $array_list = ",devent,ident_data";
  my $word_map = { "samfs" => "CAPACITY" };

  $ENV{LD_LIBRARY_PATH} = "/opt/SUNWsamfs/lib";
  my ($err, $lines) = Util->run_command("/opt/SUNWsamfs/sbin/samstorade");

  # remove the first 2 lines until xml2report undertands them.
  $lines->[0] = "";
  $lines->[1] = "";

  my $error = Report->xml2report( $report, "@$lines", $prefix, 
                             $array_list, $word_map);

  return $report;
}


sub REPORT {
  my($class, $host, $report, $arg) = @_;
  return if (!$report);

  my $r= $report->content();

  my $local_ip = Util->name2ip();
  my $samfs_ip  = $r->{"id.ipno"};


    if ($r->{"samfm.pkg.version"}) {


      my $LB = Labels->read("GUI::Samqfs");

      my($info, $package, $devs, $x, $y);
        
print <<EOF;
          <table border=1 width=100% bgcolor=white cellspacing=0>
          <tr><td bgcolor=#D0D0D0 colspan=2><b>SAM-QFS Identification Information</td>
EOF

          my %ID_MAP = ( 'device_ip'    => $LB->{device_ip},
                               'device_ipno'  => $LB->{device_ipno},
                               'device_product_id' => $LB->{device_product_id},);

          my @ID_LIST  = ('device_ip','device_ipno', 'device_product_id');

          foreach my $el (@ID_LIST) {
        my $val = $r->{"id.$el"};
        my $el2 = $ID_MAP{$el} || $el;
        print "<tr><td align=right>$el2: </td><td>$val</td>";
          }

          my %DEV_COLS_MAP = ( 'name' => "Name",
                               'scsi_type' => "Type",
                               'vendor' => "Vendor",
                               'product' => "Product", 
                               'state'  => "State",
                               'revision' => "Firmware",                                             
                               'serial' => "Serial Number",              
                             );

          my @DEV_COLS = ('name', 'scsi_type', 'vendor', 'product', 'state', 'revision', 'serial');
          my $cols = $#DEV_COLS + 2;

print <<EOF;
          <tr><td align=right>Package Version: </td><td>$r->{'samfm.pkg.version'}</td>
          <tr><td align=right>Package PatchID: </td><td>$r->{'samfm.pkg.patch_id'}</td>
          </table>

          <table border=1 width=100% bgcolor=white cellspacing=0 cellpadding=1>
          <tr><td colspan=$cols bgcolor=#D0D0D0><b>Device Entries </td><tr>
EOF

          my $no = 0;

          # HEADERS
          foreach my $el ('No', @DEV_COLS) {
        my $el2 = $DEV_COLS_MAP{$el} || ucfirst($el);
        print "<td><b>$el2</td>";
          }

          # MAIN DEVICE TABLEOF DEVENT

          my %SCSI_TYPE = ( '1'  => 'Tape',
                        '7' => 'Optical',
                            '8'  => 'Library',
                       );

          for ($x=1 ; $x <= $r->{"samfm.devent.COUNT_"}; $x++) {
            print "<tr><td><center>$x</td>";
            my $k = "samfm.devent.$x";

            foreach my $el (@DEV_COLS) {
              my $val = $r->{"$k.$el"};
              if ($el eq "scsi_type") { 
               $val = $SCSI_TYPE{$val};
          }
            print "<td>$val&nbsp;</td>" ;
            }

            # -----------Status Entries ------  
            my $statusData;  
  
            if ($r->{"$k.scsi_type"} == 8) {
              my %STATUS_MAP = ( 'ready' => "Ready",
                             'attention'    => "Attention",
                             'stor_full'  => "Storage Full",
                             'scan_err'  => "Scan Error",
                             );
              my @STATUS_LIST  = ('ready', 'attention','stor_full', 'scan_err');

              foreach my $el (@STATUS_LIST) {
            my $val = $r->{"$k.status.$el"};
                my $el2 = $STATUS_MAP{$el} || $el;
                $statusData .= "<tr><td align=left>$el2: </td><td>$val</td>";
          }
        } else {
            my %STATUS_MAP = ( 'ready'     => "Ready",
                               'attention' => "Attention",
                               'vsn'       => "VSN",
                               'bad_media' => "Bad Media",
                          );
        my @STATUS_LIST  = ('ready', 'attention', 'vsn', 'bad_media');
        my $val;
          foreach my $el (@STATUS_LIST) {
            if ($el eq "vsn"){
            $val = $r->{"$k.vsn"};
            } else {
            $val = $r->{"$k.status.$el"};
            }
            my $el2 = $STATUS_MAP{$el} || $el;
            $statusData .= "<tr><td align=left>$el2: </td><td>$val</td>";
          }
        } 

  
        if ($statusData) {
      my $col3 = $cols - 5;
      print "<tr><td colspan=1></td><td colspan=$col3>
              <table border=0 width=100% cellspacing=1 cellpadding=1><tr bgcolor=#E0E0E0>
                      <td>Status</td>
                      <td>Value</td>
                  $statusData
              </table>
              </td>";

    }
  
  
    #-----------------ID entries --------
    my $data;


    my @TYPE     = ('0','SCSI ID','EUI-64 I.D.', 'WWN','Port');

    my $data_count = $r->{"$k.devid.ident_data.COUNT_"};

      for ($y=1 ; $y <= $data_count; $y++) {
        my $ident = $r->{"$k.devid.ident_data.$y.ident"};
        my $type  = $TYPE[$r->{"$k.devid.ident_data.$y.type"}];
        $data .= "<tr><td>$type</td><td>$ident</td>";
      }

    if ($data) {
      my $col2 = $cols - 5;
      print "<tr><td colspan=1></td><td colspan=$col2>
              <table border=0 width=100% cellspacing=1 cellpadding=1><tr bgcolor=#E0E0E0>
                      <td>I.D. Type</td>
                      <td>Value</td>
                  $data
              </table>
              </td>";
    }
    
    }
    print "</table>";

    } else {
        get41report();
    }# end else 4.1

  sub get41report {
    my($out);
    my($tableCnt) = $arg->{tableCnt};
    my($rev)      = $report->{'_value'}{"info.revision"};
    my($host0)    = $host || System->hostname();
    my($v)        = $report->{_value};
    my $c = "#CCCCFF";
    $out .= $class->reportHead("SAM-QFS", $report);
    $out .= "
     <tr><td bgcolor=$c align=right><b>Name:</td><td width=25%>&nbsp;$report->{_id}{name}</td>
         <td bgcolor=$c align=right><b>Monitored on:</td><td>&nbsp;$host0</td>
   
     <tr>
         <td bgcolor=$c align=right><b>ProductID:</td><td>&nbsp;Sun SAM-QFS</td>
         <td bgcolor=$c align=right><b>Vendor:</td><td>&nbsp;Sun</td>
    </table>
    ";
   $out .= "</table>\n";
   return $out;
  }
}# end REPORT
1;




