package Agent::HBASWITCH;
use System;
use strict;
use Agent;
use base 'Agent';
use Util;
use System;
use Discover;

#------------------------------------------
# This report can include multiple generic switches
#------------------------------------------

sub isSelectable {0}
sub revision {'$Revision: 1.13 $'}

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::HBASWITCH');
  return $self;
}
use vars qw($ERR );
#
# Used to generate a hbaapi report and
# optionally fix the topology with the informatio found.
#

sub RUN {
  my($agent, $static_list, $pass) = @_;
  my ($timelapse, $dc);

  my($renv) = System->get_renv();
  $DB::single = 1;
  my $processed_list = [];
  return [] if ($renv->{solution} ne "N");

  my $freq  = $renv->{'hbaapi.freq' } || 60*24;
  my $delay = $renv->{"hbaapi.delay"} || 5;
  my $type  =  Report::CAT_HBASWITCH;

  if (Timer->isXmins("hbaapi_switch", $freq) || System->get_allDevices()) {
    my $switch_list = HBAApi->switches();

    my $wwn = "switches-" . System->hostid();

    my $dev = { type => $type, key => $wwn, name => "HBA Switches" };

    my($report) = $agent->INSTRUMENTATION( $switch_list, $dev);

    my $problems = PDM->get_last_event();
    Discover->updateTopoInterconnects($switch_list);

    my($id) = {
                deviceName=> $wwn,
                active    => "Y",
                class     => "switch.$type",
                name      => uc($type) . " " . $renv->{hostname},
                display   => uc($type) . " " . $renv->{hostname},
                category  => $type,
                ip        => Util->name2ip(),
               };

     my $new_rep = Report->new($id, $report);

     require Health::HBASwitch;
     Health::HBASwitch->all_logic($new_rep);
     PDM->saveReport($new_rep);

     my ($broke, $abort) = $agent->new_events($problems, $dev, 1);
     push(@$processed_list, $dev);
     last if ($broke && $pass == 1 || $abort);
  }
  return $processed_list;
}

sub INSTRUMENTATION {
  my($agent, $switch_list, $dev) = @_;
  my (%R,$x, $p);

  return Report->readTest($dev) if (System->get_testMode());

  for ($x=0; $x <= $#$switch_list; $x++) {
       my(%R2);
       my $sw = $switch_list->[$x];
       my $info = $sw->{info};
       $info->{InterLogicalName} =~ s/[<>]//g;
       foreach my $el (keys %$info) {
          $R{"switch.$x.info.$el"} = $info->{$el};
          $R2{"info.$el"}          = $info->{$el};
       }
       $R{"switch.$x.fru.0._Model"} = $info->{ModelName};
       $R2{"fru.0._Model"}          = $info->{ModelName};

       $R{"switch.$x.fru.0._Vendor"} = $info->{VendorName};
       $R2{"fru.0._Vendor"}          = $info->{VendorName};

       $R{"switch.$x.fru.0._Firmware"} = $info->{ReleaseCode};
       $R2{"fru.0._Firmware"}          = $info->{ReleaseCode};

       $R{"switch.$x.fru.0._Type"} = $info->{InterconnectType};
       $R2{"fru.0._Type"}          = $info->{InterconnectType};

       $R{"switch.$x.fru.0._name"} = $info->{InterNodeWWN};
       $R2{"fru.0._name"}          = $info->{InterNodeWWN};
       $R{"switch.$x.fru.0._Name"} = $info->{InterNodeWWN};
       $R2{"fru.0._Name"}          = $info->{InterNodeWWN};

       $R{"switch.$x.fru.0._ElementName"} = $info->{InterNodeWWN};
       $R2{"fru.0._ElementName"}          = $info->{InterNodeWWN};


       my $ports = $sw->{portInfo};
       for ($p=0; $p<= $#$ports; $p++) {
          my $port = $ports->[$p];
          foreach my $el (keys %$port) {
            $R{"switch.$x.fcport.$p.$el"} = $port->{$el};
            $R2{"fcport.$p.$el"}          = $port->{$el};
          }
          my $wwn = $port->{LocalPortWWN};

          $R{"switch.$x.fcport.$p._Name"} = $wwn;
          $R2{"fcport.$p._Name"}          = $wwn;

          $R{"switch.$x.fcport.$p._ElementName"} = $wwn;
          $R2{"fcport.$p._ElementName"}          = $wwn;

          $R{"switch.$x.fcport.$p._WWN"} = $wwn;
          $R2{"fcport.$p._WWN"}          = $wwn;

          $R{"switch.$x.fcport.$p._Caption"} = $port->{PortType};
          $R2{"fcport.$p._Caption"}          = $port->{PortType};
       }
       $R{"switch.$x.fcport.count"} = $#$ports+1;
       $R2{"fcport.count"} = $#$ports+1;

       $agent->writeReport($sw, \%R2);
  }
  return \%R;
}

# WRITE SWITCH-SPECIFIC REPORT
sub writeReport {
  my($agent, $sw, $R2) = @_;

  my $type =  Report::CAT_HBASWITCH;
  my $key  = "IB" . $sw->{info}{InterNodeWWN};
  my $name = $sw->{info}{InterLogicalName} || $key;
  my $id = { deviceName => $key,
             active    => "Y",
             class     => "switch.$type",
             name      => $name,
             display   => "$sw->{info}{ModelName} $name",
             category  => $type,
             ip        => $sw->{info}{IPAddress},
           };
  my $report = Report->new($id, $R2);
  #PDM->saveReport($report);
}

1;


