package Agent::5210;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  Keyur Desai 
#  $Id: 
use strict;
use Agent;
use base 'Agent';
use Revision;
use Report;
use Matrix;
use System;
use Util;

sub isSelectable {"Sun 5210"}

sub revision {'$Revision: 1.6 $'}

# DO NOT REMOVE THIS COMMENT
# Report::CAT_5210MESSAGE

sub category { Report::CAT_5210 }

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::5210');
  return $self;
}

use vars qw ($ERR);

###############################################
# sub RUN
###############################################
sub RUN {

  my($agent, $static_list, $pass) = @_;
  my($HBA, $logfile, $r, @results);
  my($xml, @lux_dif, $dif, $ev, $found);
  my($log_err, $lines, $timelapse);
  my(%DONE, $report, $device, $key, $id, $x, $l, $connect_errs);
  $DB::single=1;
  
  my $renv = System->get_renv();
  my $type = $agent->category();
  my $ping_to  = $renv->{'timeout.ping'} || 10;

  my $today = Util->today("YMDH");
  my $processed_list = [];
  my($dc) = 0;

  foreach $device ( $agent->deviceList($static_list)) {
    next if ($device->{active} eq "N");
    $dc++;

    Debug->print1("-> " . uc($device->{type}) . ": Reading device $device->{name}/$device->{wwn}/$device->{path}");
    
    
    # SAVE EVENT POINTER
    my $problems = PDM->get_last_event();

    if (($device->{path} =~ /dev/) ||
        ($device->{ipno} && Util->ping2($device->{ipno}, $ping_to))
       ) {
      #my($err, $lines) = $agent->readLog($device, $report);
      #my($warn_lines)  = $agent->find_alert($lines, $device);
      #if ($warn_lines) {
      #  $id = {
      #        deviceName  => $device->{key},
      #        active      => "Y",
      #        display     => $device->{name},
      #        name        => $device->{name},
      #        class       => "storage.$type",  # Report::CAT_5210MESSAGE
      #        category    => $type,
      #        ip          => $device->{ipno},
      #     };
      #  $report->{"id.name"} = $device->{name};
      #  
      #  my $new_rep = Report->new($id, $report , $warn_lines, Report::STATUS_OK);
      #  require Health::Message;
      #  Health::Message->all_logic($new_rep);
      #  PDM->saveReport( $new_rep );
      #}
    }

    # CALL INSTRUMENTATION  
    ($key, $connect_errs, $report) = $agent->INSTRUMENTATION($device);
    $key= lc($key);
    if ($connect_errs eq "BUSY") {
       Debug->print2("Device $device->{name} is busy, skipping!");
       next;
    }

    # CREATE A REPORT HEADER
    $id = {  
              deviceName  => $device->{key},
              active      => $device->{active},
              logFile     => "",
              display     => "$device->{name}",
              name        => $device->{name},
              class       => $device->{class},
              category    => $type,
              ip          => $device->{ipno},
           };
     $report = {} if (!$report);
     $agent->copyDev($device, $report);
      
     $HBA = $device->{hba} || System->get_hba;
     $report->{"id.name"} = $device->{name};
     $report->{"id.ipno"} = System->get_ipno();
     $report->{"id.wwn"}  = $device->{key};
     my $new_rep;
     if ($connect_errs || !$key) {
        $report->{'id.connect_errs'} = $connect_errs;
        $new_rep = Report->new($id, $report , undef, Report::STATUS_CANNOT_CONNECT);
     } else {
        Discover->updateTopoDevice($device, {report => $report});
        $new_rep = Report->new($id, $report , undef);
     }

     # CALL HEALTH MODULE, generate EVENTS
     require Health::5210;
     Health::5210->all_logic($new_rep); # create event

     # SAVE INSTRUMENTATION REPORT
     PDM->saveReport($new_rep);

     # ABORT THE INSTRUMENTATION LOOP if a problem was found
     my ($broke, $abort) = $agent->new_events($problems, $device, 1);
     push(@$processed_list, $device);
     last if ($broke && $pass == 1 || $abort);

  } 

  # RETURN A LIST OF PROCESSED DEVICE
  return $processed_list;

}

###############################################
# sub INSTRUMENTATION
###############################################
sub INSTRUMENTATION {
  my($agent, $device) = @_;
  my(@s, %dev, $in, $key, $state, $num);
  my $report = {};

  if (System->get_testMode()) {
     my $testrep = Report->readTest($device);
     return ($device->{key}, "", $testrep);
  }

  my $renv = System->get_renv();
  my $ping_to  = $renv->{'timeout.ping'} || 10;
  my $public = $renv->{'snmp.comunity'} || "public";
  my $TO = $renv->{'timeout.snmp'} || 40;
  my $DIR = System->get_home();
  my $ip = $device->{ip};
  my $MIBDIR = System->get_home() . "/snmp/share/snmp/mibs";
  my $OPT = "-v1 -c$public -r1 -t$TO -Ose";

  $report->{'info.ethernet_status'} = "ok";

  # CHECK for access problem
  if (!$device->{path} && $device->{ipno} && !Util->ping($device->{ipno},$ping_to)) {
     $report->{'info.ethernet_errs'} = "Ping failed to $device->{ipno} (timeout=$ping_to)";
     $report->{'info.ethernet_status'} = "ping_failed";
     return ($device->{key}, "Ping failed", $report);
  }

  # START TIMELAPSE ON A DEVICE
  Timelapse->startDev( $device); 


  # REPLACE THIS PART
  
  # Put SNMP Walk stuff here.

  my $raidtable =[];
  # 1. Do all the walks by table
  my($err_systemtable,$systemtable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210System",
                       "System Group", 2*$TO +5);

  my($err_interfacestable,$interfacestable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/mcdata/rfc1213.mib $ip interfaces",
                       "MIB2 Interface Group", 2*$TO +5);

  my($err_environmentable,$environmenttable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210Environment",
                       "Environment Group", 2*$TO +5);

#  my($err_raidControllertable,$raidControllertable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidControllerTable",
#                       "RAID Controller", 2*$TO +5);
# Break Controller table in to small tables for performance reasons.

  my($err_raidControllertableN,$raidControllerName) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidControllerName",
                       "RAID Controller Name", 2*$TO +5);
  push (@$raidtable, @$raidControllerName);

  my($err_raidControllertableF,$raidControllerFirmware) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidControllerFirmwareVersion",
                       "RAID Controller Firmware", 2*$TO +5);
  push (@$raidtable, @$raidControllerFirmware);

  my($err_raidControllertableE,$raidControllerEnclCount) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidControllerEnclosureCount",
                       "RAID Controller Encl Count", 2*$TO +5);
  push (@$raidtable, @$raidControllerEnclCount);

  my($err_raidControllertable,$raidControllerStatus) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidControllerStatus",
                       "RAID Controller Status", 2*$TO +5);
  push (@$raidtable, @$raidControllerStatus);

# End of push
#  push (@$raidtable, @$raidControllertable); 

  my($err_raidChanneltable,$raidChanneltable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidChannelTable",
                       "RAID Channel", 2*$TO +5);
  push (@$raidtable, @$raidChanneltable);

  my($err_raidPhysicaltable,$raidPhysicalDrivetable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidPhysicalDriveTable",
                       "RAID Physical Drive", 4*$TO +5);
  push (@$raidtable, @$raidPhysicalDrivetable);

  my($err_raidSystemtable,$raidSystemDrivetable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidSystemDriveTable",
                       "RAID System Drive", 2*$TO +5);
  push (@$raidtable, @$raidSystemDrivetable); 

  my($err_raidBBUtable,$raidBBUtable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidBBUTable",
                       "RAID BBU", 2*$TO +5);
  push (@$raidtable, @$raidBBUtable);

  my $list_numenclosure = \@$raidControllerEnclCount;
  my(@a) = split(/ +\= */, $list_numenclosure->[0]);
  my $noOfEnclosure =  $a[1];

  if (($noOfEnclosure) && ($noOfEnclosure > 1)) {
    my($err_raidEnclosuretable,$raidEnclosuretable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidEnclosureTable",
                       "RAID Enclosure", 2*$TO +5);
    push (@$raidtable, @$raidEnclosuretable);

    my($err_raidPowertable,$raidPowerSupplytable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidPowerSupplyTable",
                       "RAID Power Supply", 2*$TO +5);
    push (@$raidtable, @$raidPowerSupplytable);

    my($err_raidFantable,$raidFantable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidFanTable",
                       "RAID Fan", 2*$TO +5);
    push (@$raidtable, @$raidFantable);

    my($err_raidTStable,$raidTStable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidThermalSensorTable",
                       "RAID TS", 2*$TO +5);
    push (@$raidtable, @$raidTStable);
  }

  if ($err_systemtable || $err_interfacestable || $err_raidControllertable || $err_environmentable) {
    Debug->err(SNMP => "Cannot run snmp on $ip:$err_systemtable$err_interfacestable$err_raidControllertable$err_environmentable");
    $report->{'rc.error'} = "$err_systemtable$err_interfacestable$err_raidControllertable$err_environmentable";
    return ($device->{key}, "Ping failed", $report);
  } 

  # 2. Parse the each tables 
  my $totalController = 0;
  my $totalBattery = 0;
  my $totalPort = 0;
  my $totalPowerSupply = 0;
  my $totalFan = 0;
  my $totalSensor = 0; 
  my $totalLogicalDrive = 0;
  my $totalPhysicalDrive = 0;
  my $totalPartition = 0;
  my $totalChannel = 0;
  my $totalEnvPowerSupply = 0;
  my $totalEnvFan = 0;
  my $totalEnvSensor = 0;

  foreach my $x (@$systemtable) {
     my(@a) = split(/ +\= */, $x);

     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
     $a[0] =~ s/se5210//;
      
     if (($a[0] =~ /Sys/) || ($a[0] =~ /OsVersion/) ) {
         $report->{'info.'.$a[0]} =  $a[1];
     } elsif ($a[0] =~ /Partition/)  {
	 my $ix = rindex($a[0],".");
	 my $partitionNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);

         if ($a0 =~ /Mode/) {
            $a[1] = $agent->snmpPartitionModeToText($a[1]);
	    $totalPartition++;
         }

	 $report->{'partition.'.$partitionNumber. '.' .$a0} =  $a[1];
         
     } elsif ($a[0] =~ /Processor/)  {
         my $ix = rindex($a[0],".");
	 my $processorNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
	 $report->{'processor.'.$processorNumber. '.' .$a0} =  $a[1];

     } 
  }

  foreach my $x (@$interfacestable) {
     my(@a) = split(/ +\= */, $x);

     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
     $a[0] =~ s/if//;

     my $ix = rindex($a[0],".");
     my $portID = substr($a[0],$ix+1); 
     my $a0 = substr($a[0],0,$ix);
     
     $a[1] =~ s/Gauge\d+\://;
     $a[1] =~ s/Counter\d+\://;
     if ($a0 =~ /Status/) {
         $a[1] = $agent->snmpPortStatusToText($a[1]);
     } elsif ($a0 =~ /Type/) {
	 
         $a[1] = $agent->snmpPortTypeToText($a[1]);
 	 $totalPort++;
	 
     }

     $report->{'port.'.$portID. '.' .$a0} =  $a[1];

  }


  foreach my $x (@$raidtable) {
     my(@a) = split(/ +\= */, $x);

     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
     $a[0] =~ s/se5210//;
     
     if ($a[0] =~ /RaidController/) {
         my $ix = rindex($a[0],".");
         my $controllerNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
	 
	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpRaidCntrlStatusToText($a[1]);
	    $totalController++;
         }

         $report->{'controller.'.$controllerNumber. '.' .$a0} =  $a[1];
     } elsif ($a[0] =~ /RaidChannel/)  {
         my $ix = rindex($a[0],".");
         my $channelNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);           
	 $a0 = substr($a0,0,-2);

	 if ($a0 =~ /RaidChannelConnectedDevice/) {
	     $totalChannel++;
	 }

         $report->{'channel.'.$channelNumber. '.' .$a0} =  $a[1];
     } elsif ($a[0] =~ /RaidPhysicalDrive/)  {
         my $ix = rindex($a[0],".");
         my $diskdriveNumber = substr($a[0],$ix+1); 
	 
	 my $splita0 = substr($a[0],0,$ix);
	 my $channelix = rindex($splita0,".");
	 my $channelID = substr($splita0,$channelix+1);
	 my $a0 = substr($a[0],0,$channelix); 
	 # Get rid of the Raid Controller
	 $a0 = substr($a0,0,-2);

	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpPhysicalDriveStatusToText($a[1]);
	    $totalPhysicalDrive++;
         }  elsif ($a0 =~ /Type/) {
            $a[1] = $agent->snmpPhysicalDriveTypeToText($a[1]); 
         }

	 next if (($a0 =~ /RaidPhysicalDriveSectorRead/) || 
	          ($a0 =~ /RaidPhysicalDriveSectorWrite/));
	 $report->{'physicaldrive.'.$channelID."-".$diskdriveNumber. "." .$a0} =  $a[1];
     } elsif ($a[0] =~ /RaidSystemDrive/)  {
         my $ix = rindex($a[0],".");
         my $logicaldriveNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix); 

	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpSystemDriveStatusToText($a[1]);
	    $totalLogicalDrive++;
         } elsif ($a0 =~ /CachePolicy/) {
            $a[1] = $agent->snmpCachePolicyToText($a[1]);
         } 

	 $report->{'logicaldrive.'.$logicaldriveNumber. '.' .$a0} =  $a[1];
     } elsif ($a[0] =~ /RaidBBU/ || $a[0] =~ /RaidBat/ || $a[0] =~ /RaidCharge/ )  {
         my $ix = rindex($a[0],".");
         my $batteryNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
	 
         if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpBatteryStatusToText($a[1]);
	    $totalBattery++;
         } elsif ($a0 =~ /Type/) {
            $a[1] = $agent->snmpBatteryTypeToText($a[1]); 
         }
	  
	 $report->{'battery.'.$batteryNumber. '.' .$a0} =  $a[1];
     } elsif ($a[0] =~ /RaidEnclosure/)  {
         my $ix = rindex($a[0],".");
         my $enclNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
	 $report->{'raid_enclosure.'.$enclNumber. '.' .$a0} =  $a[1];          
     } elsif ($a[0] =~ /RaidPowerSupply/)  {
         my $ix = rindex($a[0],".");
         my $powerSupplyNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
	 $a0 = substr($a0,0,-2);

	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpStatusToText($a[1]);
	    if ($a[1] ne "absent") {
	        $totalPowerSupply++;
	    }
         }

	 $report->{'powersupply.'.$powerSupplyNumber. '.' .$a0} =  $a[1]; 
     } elsif ($a[0] =~ /RaidFan/)  {
         my $ix = rindex($a[0],".");
         my $fanNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
	 $a0 = substr($a0,0,-2);
	 
	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpStatusToText($a[1]);
	    $totalFan++;
         } elsif ($a0 =~ /Speed/) {
            $a[1] = $agent->snmpSpeedToText($a[1]);
         }

	 $report->{'fan.'.$fanNumber. '.' .$a0} =  $a[1]; 
     } elsif ($a[0] =~ /RaidThermalSensor/)  {
         my $ix = rindex($a[0],".");
         my $thsensorNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
         $a0 = substr($a0,0,-2);

	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpStatusToText($a[1]);
	    $totalSensor++;
         }

	 $report->{'thermalsensor.'.$thsensorNumber. '.' .$a0} =  $a[1]; 
     }   
  }

  foreach my $x (@$environmenttable) {
     my(@a) = split(/ +\= */, $x);

     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
     $a[0] =~ s/se5210//;


     if ($a[0] =~ /UpsStatus/) {  
     	 $report->{'ups.'.$a[0]} =  $a[1];
     } elsif ($a[0] =~ /EnvPower/)  {
         my $ix = rindex($a[0],".");
         my $powerSupplyNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);

	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpEnvPowerStatusToText($a[1]);
	    if (($a[1] eq "normal") || ($a[1] eq "warning")) {
 	      $totalEnvPowerSupply++;
	    }	     
         }

	 $report->{'environment_ps.'.$powerSupplyNumber. '.' .$a0} =  $a[1]; 
     } elsif ($a[0] =~ /EnvFan/)  {
         my $ix = rindex($a[0],".");
         my $fanNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
	 my $status = "failed";
	 
         if ($a0 =~ /RPM/) {
	    if ($a[1] ne 0) {
	      $status = "normal";
	    }
	    $totalEnvFan++;
         }

	 $report->{'environment_fn.'.$fanNumber. '.' .$a0} = $a[1]; 
	 $report->{'environment_fn.'.$fanNumber.'.EnvFanStatus'} = $status;
     } elsif ($a[0] =~ /EnvTemperature/)  {
         my $ix = rindex($a[0],".");
         my $thsensorNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);			    

	 if ($a0 =~ /Temperature/) {
	    $totalEnvSensor++;
         }

	 $report->{'environment_ts.'.$thsensorNumber. '.' .$a0} =  $a[1]; 
     }   
  }

  # For Performance reason, hardcode the vendor and model
  $report->{'controller.1.RaidControllerModel'} = "MegaRAID SCSI 320-2XLSI Logic"; ;
  $report->{'controller.1.RaidControllerVendor'} = "LSI Logic";

  $report->{'info.totalJBODFan'} =  $totalFan;
  $report->{'info.totalJBODThermalSensor'} = $totalSensor;
  $report->{'info.totalJBODPowerSupply'} =  $totalPowerSupply;
  $report->{'info.totalBattery'} = $totalBattery;
  $report->{'info.totalPhysicalDiskDrive'} =  $totalPhysicalDrive;
  $report->{'info.totalLogicalDiskDrive'} =  $totalLogicalDrive;
  $report->{'info.totalPort'} =  $totalPort - 1;
  $report->{'info.totalRaidController'} =  $totalController;
  $report->{'info.totalPartition'} = $totalPartition;
  $report->{'info.totalChannel'} = $totalChannel;
  $report->{'info.totalEnclosureCount'} =  $report->{'controller.1.RaidControllerEnclosureCount'};
  $report->{'info.totalEnvironmentFan'} =  $totalEnvFan;
  $report->{'info.totalEnvironmentPowerSupply'} = $totalEnvPowerSupply;
  $report->{'info.totalEnvironmentTempSensor'} = $totalEnvSensor;


  # ADD Site Identification data to the report
  $agent->addIdentification($report);

  # ADD 'rc.key' to the report
  $report->{'rc.key'} = $device->{key};
  Timelapse->stopDev( $device); 

  # RETURN a pointer to the HASH
  return ($device->{key}, "", $report);

}



###############################################
# sub FRUs
###############################################
sub FRUS {
  my($class, $r, $name) = @_;
  my($v) = $r->{_value};
  my @FRUS;
  my $devtype = $v->{"id.device_type"} || "5210";
  my $model = $v->{"info.SysModel"} || $devtype;
  my $serial = $v->{"info.SysSerialNo"};


  foreach my $el (sort keys %$v) {
     if ($el =~ /controller.(\d+).RaidControllerName/) {
        my $ix = $1;
        my $d = "controller.$ix";
        my $model  = $v->{"$d.RaidControllerModel"};
        my $vendor = $v->{"$d.RaidControllerVendor"};
        my $serial = $serial;
        my $rev    = $v->{"$d.RaidControllerFirmwareVersion"};
        my $status = $v->{"$d.RaidControllerStatus"};

        push(@FRUS, [ $name ,$devtype, "controller", "controller.$ix",
             $vendor || " N/A", $model||" N/A", $serial||" N/A", $rev, $status]);

     } elsif ($el =~ /physicaldrive.(\d)-(\d+).RaidPhysicalDriveType/) {
       
        my $channelID = $1;
        my $targetID = $2;
        my $ix = $channelID ."-" .$targetID;

        my $d = "physicaldrive.$ix";
        my $model  = $v->{"$d.RaidPhysicalDriveModel"};
        my $vendor = $v->{"$d.RaidPhysicalDriveVendor"};
        my $serial = $v->{"$d.RaidPhysicalDriveSerial"};
        my $rev    = $v->{"$d.RaidPhysicalDriveFwRevision"};
        my $status = $v->{"$d.RaidPhysicalDriveStatus"};
        my $type   = $v->{"$d.RaidPhysicalDriveType"};

        push(@FRUS, [ $name ,$devtype, $type, "physicaldrive.$ix",
             $vendor || "N/A", $model ||"N/A", $serial ||"N/A", $rev, $status]);
     }  elsif ($el =~ /battery.(\d+).RaidBBUStatus/) {
        my $ix = $1;
	my $d = "battery.$ix";
	my $status = $v->{"$d.RaidBBUStatus"};
	my $type   = $v->{"$d.RaidBatteryType"};

        push(@FRUS, [ $name ,$devtype, "Battery", "battery.$ix",
             "N/A", "N/A", "N/A", "N/A", $status]);

     }  elsif ($el =~ /fan.(\d+).RaidFanStatus/) {
        my $ix = $1;
	my $d = "fan.$ix";
	my $status = $v->{"$d.RaidFanStatus"};
	my $speed   = $v->{"$d.RaidFanSpeed"};

        push(@FRUS, [ $name ,$devtype, "JBOD Fan", "fan.$ix",
             "N/A", "N/A", "N/A", "N/A", $status]);

     }  elsif ($el =~ /powersupply.(\d+).RaidPowerSupplyStatus/) {
        my $ix = $1;
	my $d = "powersupply.$ix";
	my $status = $v->{"$d.RaidPowerSupplyStatus"};  
	
        push(@FRUS, [ $name ,$devtype, "JBOD Power Supply", "powersupply.$ix",
             "N/A", "N/A", "N/A", "N/A", $status]);
     	
     }  elsif ($el =~ /environment_fn.(\d+).EnvFanRPM/) {
        my $ix = $1;
	my $d = "environment_fn.$ix";
	my $status = $v->{"$d.EnvFanStatus"};
	my $speed   = $v->{"$d.EnvFanRPM"};

        push(@FRUS, [ $name ,$devtype, "Environment Fan", "environment_fn.$ix",
             "N/A", "N/A", "N/A", "N/A", $status]);

     }  elsif ($el =~ /environment_ps.(\d+).EnvPowerStatus/) {
        my $ix = $1;
	my $d = "environment_ps.$ix";
	my $status = $v->{"$d.EnvPowerStatus"};  
	
        push(@FRUS, [ $name ,$devtype, "Environment Power Supply", "environment_ps.$ix",
             "N/A", "N/A", "N/A", "N/A", $status]);
     	
     }


  }
  return \@FRUS;
}

###############################################
# sub REPORT
###############################################
sub REPORT {
  my($class, $host, $r, $arg) = @_;

  my($v) = $r->{_value};
  my($out);
  my($tableCnt) = $arg->{tableCnt};
  my($host0) = $host || System->hostname();
  my $comm = ($r->{_status} eq "CC") ? "<font color=red>Communication Lost: Data may be old!</font>" : "";
 
  my $totalController = $v->{"info.totalRaidController"};
  my $totalBattery = $v->{"info.totalBattery"};
  my $totalPort =  $v->{"info.totalPort"};
  my $totalProcessor = $v->{"info.SysProcessorCount"};  
  my $totalPowerSupply = $v->{"info.totalJBODPowerSupply"};
  my $totalFan =  $v->{"info.totalJBODFan"};
  my $totalSensor = $v->{"info.totalJBODThermalSensor"}; 
  my $totalLogicalDrive = $v->{"info.totalLogicalDiskDrive"};
  my $totalPartition = $v->{"info.totalPartition"};
  my $totalChannel = $v->{"info.totalChannel"};
  my $totalEnvFan = $v->{"info.totalEnvironmentFan"};
  my $totalEnvPowerSupply = $v->{"info.totalEnvironmentPowerSupply"};
  my $totalEnvSensor = $v->{"info.totalEnvironmentTempSensor"};
  my $totalPhysicalDrive = $v->{"info.totalPhysicalDiskDrive"};


  $out .= $class->reportHead($v->{'id.device_type'}, $r);
  my $cnt;
  $out .= "<tr> <td colspan=4><center><b>$v->{'id.device_type'} $v->{'id.device_key'}</td>";
  $out .= "<tr> <td colspan=4><b><center>$comm</td>";
  foreach my $el (sort keys %$v) {
     if ($el =~ /^info\.(.+)/)  {
       my $n = $1;

       $out .= "<tr>" if ($cnt++ % 2 == 0);
       my $v1 = $v->{$el};
       my $le = length($v1);
       if ($le > 20) {
         my $half = int($le/2);
         $v1 = "<small>" . substr($v1,0,$half) . " " . substr($v1,$half);
       }
       $out .= "<td bgcolor=$Style::LIGHT align=right><small>$n:</td>
                   <td><small>&nbsp;$v1</td>";
     }   
   } 
  $out .= "</table>";

  my $x;

############
# Processor

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Processor</td>";

  if ($totalProcessor eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No Processor info found !</td></tr>";
  } else {
    $out .= "<tr bgcolor=$Style::LIGHT>
        <th>Number
        <th>Type
        <th>Load (%)";
    for ($x=1; $x <= $totalProcessor; $x++) {

        $out .=<<EOF;
        <tr><td><b><small><center>$x</td>
            <td><small><center>$v->{"processor.$x.ProcessorType"}</td>
            <td><small><center>$v->{"processor.$x.ProcessorLoad"}</td></tr>
EOF
    }
  }
  $out .= "</table>";


############
# Controller

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Raid Controller</td>";

  if ($totalController eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No Controller info found !</td></tr>";
  } else {
    $out .= "<tr bgcolor=$Style::LIGHT>
        <th>Name
        <th>Status
        <th>Vendor/Model/Serial
        <th>Revision";
    my $x;
    for ($x=1; $x <= $totalController; $x++) {

      $out .=<<EOF;
        <tr>
              <td><b><small><center>$v->{"controller.$x.RaidControllerName"}</b></td>
              <td><small><center>$v->{"controller.$x.RaidControllerStatus"}</td>
              <td><small><center>$v->{"controller.$x.RaidControllerVendor"}/ $v->{"controller.$x.RaidControllerModel"}/ $v->{"info.SysSerialNo"}</td>
              <td><small><center>$v->{"controller.$x.RaidControllerFirmwareVersion"}</td>
	</tr>
EOF
    }
  }
  $out .= "</table>";

 
##########
# CHANNELS
  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=7><font color=white><b>Channels</td></tr>";

  if ($totalChannel eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No channel info found !</td></tr>";
  } else {

    $out .= "<tr bgcolor=$Style::LIGHT>
        	<th>Channel ID 
	        <th>Connected Devices
		<th>Max. Devices Connected";

    for ($x=1; $x <= $totalChannel; $x++) {
       		$out .=<<EOF;
	        <tr>
        	      <td><b><small><center>$x</b></td>
		      <td><small><center>$v->{"channel.$x.RaidChannelConnectedDevice"}</td>
	              <td><small><center>$v->{"channel.$x.RaidChannelMaxDevice"}</td>
	  	</tr>
EOF
    }
  }
  $out .= "</table>";



######################
# DISKS

  my %diskDriveID;
  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=7><font color=white><b>Disks</td>";

  if ($totalPhysicalDrive eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No Physical drive found !</td></tr>";
  } else {
    $out .= " <tr bgcolor=$Style::LIGHT>
	        <th>Ch-Id
	        <th>Type / Size (Mb) / Lun Name
		<th>Enclosure / Row / Column
		<th>Drive Read / Write 
	        <th>Status
	        <th>Model / Serial / Vendor
		<th>Revision";

    foreach my $el (sort keys %$v)  {
	   if ($el =~ /physicaldrive.(\d)-(\d+).RaidPhysicalDriveType/)  { 
	     my $channelID = $1;
	     my $targetID = $2;
	     my $x = $channelID ."-" .$targetID; 

	     my $diskLunName = $v->{"physicaldrive.$x.RaidPhysicalDriveLunName"};

	     # For Disk Drives in a LUN
	     $diskDriveID{$x} = $diskLunName;
	                  
	     $out .=<<EOF;
	       <tr><td><b><small><center>$x</b></td>
	         <td><small><center>$v->{"physicaldrive.$x.RaidPhysicalDriveType"} / 
	                    $v->{"physicaldrive.$x.RaidPhysicalDriveSize"} / 
			    $v->{"physicaldrive.$x.RaidPhysicalDriveLunName"}</td>
	         <td><small><center>$v->{"physicaldrive.$x.RaidPhysicalDriveEnclosure"} / 
	                    $v->{"physicaldrive.$x.RaidPhysicalDriveEncRow"} /
			    $v->{"physicaldrive.$x.RaidPhysicalDriveEncCol"}</td>
	         <td><small><center>$v->{"physicaldrive.$x.RaidPhysicalDriveRead"} /
			    $v->{"physicaldrive.$x.RaidPhysicalDriveWrite"}</td>
		 <td><small><center>$v->{"physicaldrive.$x.RaidPhysicalDriveStatus"}</td> 
	         <td><small>$v->{"physicaldrive.$x.RaidPhysicalDriveModel"} / 
	                    $v->{"physicaldrive.$x.RaidPhysicalDriveSerial"} / 
			     $v->{"physicaldrive.$x.RaidPhysicalDriveVendor"} </td>
	         <td><small><center>$v->{"physicaldrive.$x.RaidPhysicalDriveFwRevision"}</td>
	       </tr> 
EOF
	   }
    }
  }
  $out .= "</table>";


############
# Partition

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Partitions</td>";

  if ($totalPartition eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No Partition info found !</td></tr>";
  } else {
    $out .= "<tr bgcolor=$Style::LIGHT>
        <th>Number
        <th>FSType
        <th>MountPoint
	<th>Size (Kb) / Utilization (%)";
    for ($x=1; $x <= $totalPartition; $x++) {

      $out .=<<EOF;
        <tr><td><b><small><center>$x</td>
            <td><small><center>$v->{"partition.$x.PartitionFSType"}</td>
            <td><small><center>$v->{"partition.$x.PartitionMountPoint"}</td>
	    <td><small><center>$v->{"partition.$x.PartitionSize"}/ $v->{"partition.$x.PartitionUtilization"} </td></tr>

EOF
    }
  }
  $out .= "</table>";
  

######################
# LOGICAL DRIVE

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Logical Drives</td>";

  if ($totalLogicalDrive eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No LUN info found !</td></tr>";
  } else {
    $out .= "<tr bgcolor=$Style::LIGHT>
        <th>Name 
        <th>Drive Count
        <th>Size (Mb)
        <th>Status
        <th>Cache Policy
        <th>Raid Level";

    for ($x=1; $x <= $totalLogicalDrive; $x++) {
      $out .=<<EOF;
        <tr>
              <td><b><small><center>$v->{"logicaldrive.$x.RaidSystemDriveName"}</b></td>
              <td><small><center>$v->{"logicaldrive.$x.RaidSystemDriveDeviceCount"} </td>
              <td><small><center>$v->{"logicaldrive.$x.RaidSystemDriveSize"}</td>
              <td><small><center>$v->{"logicaldrive.$x.RaidSystemDriveStatus"}</td>
	      <td><small><center>$v->{"logicaldrive.$x.RaidSystemDriveCachePolicy"}</td>
	      <td><small><center>$v->{"logicaldrive.$x.RaidSystemDriveRaidLevel"}</td>

EOF
    }
  }
  $out .= "</table>";

#######################
# Disk Drives in a Logical Volume
  my $diskID = \%diskDriveID;
  my($key, $value);
  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Disk Drives in a LUN</td>";

  if ($totalLogicalDrive eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No LUN info found !</td></tr>";
  } else {
    $out .= "
    <tr bgcolor=$Style::LIGHT>
        <th>LUN Name
	<th>ChannelID-TargetID of Physical Drive";

	for ($x=1; $x <= $totalLogicalDrive; $x++) {	  
	  
  	  my $drivesinLUN = "";
	  my $logicalDriveName = $v->get("logicaldrive.$x.RaidSystemDriveName");
	  #foreach my $diskDriveLunName (values %$diskID) {
	  while (($key, $value) = each %$diskID) {
            if ($logicalDriveName eq $value) {
	       $drivesinLUN .= "$key <BR>";
	    }
	  }
          $out .=<<EOF;
            <tr>
	        <td><small><center>$logicalDriveName</td>
		<td><small><center>$drivesinLUN</td>
	    </tr>
EOF
	}
  }
  $out .= "</table>";


################
# Battery Status

  $out .="<table border=1 cellspacing=0 width=95% bgcolor=white>
  <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Battery</td>";

  if ($totalBattery eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No Battery info found !</td></tr>";
  } else {
    $out .= "<tr bgcolor=$Style::LIGHT>
        <th>Status
	<th>Type
        <th>ChargeLevel (%)
        <th>Charge Minute/Threshold/Max. Minute";

    for ($x=1; $x <= $totalBattery; $x++) {
      $out .=<<EOF;
        <tr>
              <td><small><center>$v->{"battery.$x.RaidBBUStatus"}</td>
              <td><small><center>$v->{"battery.$x.RaidBatteryType"}</td>
              <td><small><center>$v->{"battery.$x.RaidBattChargeLevel"}</td>
              <td><small><center>$v->{"battery.$x.RaidChargeMinute"}/ $v->{"battery.$x.RaidChargeThresh"}/ $v->{"battery.$x.RaidChargeMaxMinute"}</td>
EOF
    }
  }
  $out .= "</table>";


######################
# Port

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Ports</td>";

  if ($totalPort eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No Port info found !</td></tr>";
  } else {
    $out .= "<tr bgcolor=$Style::LIGHT>
        <th>Port ID
	<th>Port Admin Status/ Operating Status
        <th>Port Speed (bps)/Type/Address
	<th>Port MTU/InOctets/OutOctets";
    for ($x=1; $x <= ($totalPort+1); $x++) {
      my $descr = $v->{"port.$x.Descr"};
      next if ($descr =~ /lo0/);
              
      $out .=<<EOF;
        <tr><td><b><small><center>$v->{"port.$x.Descr"}</td>
            <td><small><center>$v->{"port.$x.AdminStatus"}/ $v->{"port.$x.OperStatus"} </td>
            <td><small><center>$v->{"port.$x.Speed"}/ $v->{"port.$x.Type"}/ $v->{"port.$x.PhysAddress"} </td>
	    <td><small><center>$v->{"port.$x.Mtu"}/ $v->{"port.$x.InOctets"}/ $v->{"port.$x.OutOctets"} </td></tr>
EOF
    }
  }
  $out .= "</table>";


######################
# Environment FAN

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Environment Fans</td>";

  if ($totalEnvFan eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No Environment Fan info found !</td></tr>";
  } else {
    $out .= "<tr bgcolor=$Style::LIGHT>
        <th>Fan ID
        <th>Fan Status";
    for ($x=1; $x <= $totalEnvFan; $x++) {
 
      $out .=<<EOF;
        <tr><td><b><small><center>$x</td>
	    <td><small><center>$v->{"environment_fn.$x.EnvFanStatus"}</td></tr>

EOF
    }
  }
  $out .= "</table>";

######################
# Environment Power Supply
  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Environment Power Supplies</td>";

  if ($totalEnvPowerSupply eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No Environment Power Supply info found !</td></tr>";
  } else {
    $out .= "<tr bgcolor=$Style::LIGHT>
        <th>Power Supply ID
        <th>Power Supply Status";
    for ($x=1; $x <= $totalEnvPowerSupply; $x++) {
 
      $out .=<<EOF;
        <tr><td><b><small><center>$x</td>
            <td><small><center>$v->{"environment_ps.$x.EnvPowerStatus"}</td></tr>
EOF
    }
  }
  $out .= "</table>";

######################
# Environment Thermal Sensor
  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Environment Thermal Sensors</td>";

  if ($totalEnvSensor eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No Environment Thermal Sensor info found !</td></tr>";
  } else {
    $out .= "<tr bgcolor=$Style::LIGHT>
        <th>Sensor ID
        <th>Temperature (degrees C)";
    for ($x=1; $x <= $totalEnvSensor; $x++) {
     
     $out .=<<EOF;
        <tr><td><b><small><center>$x</td>
            <td><small><center>$v->{"environment_ts.$x.EnvTemperature"}</td></tr>
EOF
    }
  }
  $out .= "</table>";


######################
# RAID FAN

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Fans in attached JBOD</td>";

  if ($totalFan eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No Raid Fan info found !</td></tr>";
  } else {
    $out .= "<tr bgcolor=$Style::LIGHT>
        <th>Fan ID
        <th>Fan Status";
    for ($x=1; $x <= $totalFan; $x++) {
 
      $out .=<<EOF;
        <tr><td><b><small><center>$x</td>
            <td><small><center>$v->{"fan.$x.RaidFanStatus"}</td></tr>
EOF
    }
  }
  $out .= "</table>";

######################
# RAID Power Supply
  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Power Supplies in attached JBOD</td>";

  if ($totalPowerSupply eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No Raid Power Supply info found !</td></tr>";
  } else {
    $out .= "<tr bgcolor=$Style::LIGHT>
        <th>Power Supply ID
        <th>Power Supply Status";
    for ($x=1; $x <= $totalPowerSupply; $x++) {
 
      $out .=<<EOF;
        <tr><td><b><small><center>$x</td>
            <td><small><center>$v->{"powersupply.$x.RaidPowerSupplyStatus"}</td></tr>
EOF
    }
  }
  $out .= "</table>";

######################
# RAID Thermal Sensor
  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Thermal Sensors in attached JBOD</td>";

  if ($totalSensor eq '0') {
    $out .= "<tr bgcolor=$Style::LIGHT><td><center>No Raid Thermal Sensor info found !</td></tr>";
  } else {
    $out .= "<tr bgcolor=$Style::LIGHT>
        <th>Sensor ID
        <th>Sensor Status";
    for ($x=1; $x <= $totalSensor; $x++) {
    
      my $status = $v->{"thermalsensor.$x.RaidThermalSensorStatus"};
      if ($status) {
      } else {
        $status = 'absent';
      }
     
      $out .=<<EOF;
        <tr><td><b><small><center>$x</td>
            <td><small><center>$status</td></tr>
EOF
    }
  }
  $out .= "</table>";

#######################
# Attached UPS
  my $upsStatus = $v->{"ups.UpsStatus"};
  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>External UPS</td>
    <tr bgcolor=$Style::LIGHT>
        <th>Status<tr><td><b><small><center>$upsStatus</td></tr>";

  $out .= "</table>";
 
  return $out;

}

##########################################
# sub getWWN
##########################################

sub getWWN {
  my($agent, $name, $host) = @_;
  my($wwn);
  $ERR = undef;
  my($renv) = System->get_renv();
  my($TO) = $renv->{'timeout.snmp'} || 40;

  if (!$host) {
     return &get_WWN({name => $name});
  } else {
     my $rc = Util::Http->getCommand($host, "Agent::5210::WWN&name=$name&HTTP=1" , $TO);
     if ($rc !~ /OK /) {
        $ERR = "5210: getWWN: cannot identify $name on $host";
        return undef;
     } else {
        my $VAR1;
        my $ix = index($rc, "OK ");
        eval substr($rc,$ix+3);
        return $VAR1;
     }
  }
}

##########################################
# Identifying a 5210
##########################################

sub get_WWN {
  my($q) = @_;
  my $report = {};
  my $rc = {};
  my $DIR = System->get_home();
  my $renv = System->get_renv();
  my $TO  = $renv->{'timeout.snmp'} || 40;
  my $public = $renv->{'snmp.community'} || "public";
  my $MIBDIR = System->get_home() . "/snmp/share/snmp/mibs";
  my $OPT = "-v1 -c$public -r1 -t$TO -Ose";
  my $ip = $q->{name};

  my $comm;
  

  if (Util->ping($q->{name}, 10) ){
    #my $err = Agent::5210->getConfig({ipno => $q->{name} }, $report);
    #if($err){
    #   $rc->{error} = "Error on getConfig, $err";
    #}else{  
       
       $comm = "$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210SysSerialNo";
       my($err,$id) = Util->run_command($comm, "getWWN", 2*$TO+5);
       my $sn;
       								        
       foreach my $x (@$id) {
           my(@a) = split(/ +\= */, $x);

           $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
           $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
	   
	   $sn = $a[1];
       }
       
       $rc->{key}      = $sn;
       $rc->{wwn}      = $sn;
       $rc->{type}     = "5210";       
       $rc->{userLabel} = $rc->{type};
       $rc->{error}    = $err;
       
       #$rc->{model}    = $report->{'info.model'};
       #$rc->{disk_map} = $report->{"info.disk_map"};
       #$rc->{top_disk} = $report->{"info.top_disk"};
       #$rc->{units}    = 1;
       #$rc->{wwns}     = "";
       #$rc->{revision} = $report->{'info.firmware_version'};
       $rc->{serial}   = $sn;
       $rc->{ip}       = $ip;
       $rc->{ipno}     = Util->name2ip($rc->{ip});
     #}  
  } else {
    $rc->{error} = "Cannot ping $q->{name}";
  }

  if ($q->{HTTP}) {
    $Data::Dumper::Indent = 0;
    print "\nOK " . Data::Dumper::Dumper($rc) . "\n";
  } else {
    return $rc;
  }

}

## 
# For Topology, Work on it in future.
##
sub getInfoForTopology {
  
  my($class, $name) = @_;
  my $rc = {};
  my $DIR = System->get_home();
  my $renv = System->get_renv();
  my $TO  = $renv->{'timeout.snmp'} || 40;
  my $public = $renv->{'snmp.community'} || "public";
  my $MIBDIR = System->get_home() . "/snmp/share/snmp/mibs";
  my $OPT = "-v1 -c$public -r1 -t$TO -Ose";
  my $ip = $name;

  my $comm;
  
  if (Util->ping($ip, 10) ){
 
       $comm = "$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidControllerEnclosureCount";
       my($err,$enclCount) = Util->run_command($comm, "No. of Enclosure", 2*$TO+5);
       my $enclCnt;
       								        
       foreach my $x (@$enclCount) {
           my(@a) = split(/ +\= */, $x);

           $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
           $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
	   
	   $enclCnt = $a[1];
       }

       my($err_portCount, $portCount) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/mcdata/rfc1213.mib $ip ifIndex",
                       "PortCount", 2*$TO +5);
       my $portCnt = 0;
       foreach my $x (@$portCount) {
         $portCnt++;    
       }

       $comm = "$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5210_1.mib $ip se5210RaidPhysicalDriveType";
       my($err_diskDrive, $diskCount) = Util->run_command($comm,"No of diskdrive", 2*$TO +5);
       my $diskCnt = 0; # Default is 6
       foreach my $x (@$diskCount) {
         $diskCnt++;    
       }
       if (($diskCnt eq '0') || ($diskCnt eq '7')) {
	 $diskCnt = 6; 
       }
       
       if ($portCnt ne 0) {
         $portCnt = $portCnt - 1; # Filter out lo0     
       }

       $rc->{'portCount'} = $portCnt;
       $rc->{'diskCount'} = $diskCnt;
       $rc->{'enclCount'} = $enclCnt;

  } else {
    $rc->{error} = "Cannot ping $ip";
  }

  return $rc;
}


sub snmpStatusToText {
  my($agent, $snmpVal) = @_;

  if ($snmpVal eq '0') {
      return 'absent';
  } elsif ($snmpVal eq '1') {
      return 'normal';
  } elsif ($snmpVal eq '2') {
      return 'failed';
  }
  return 'unknown';
}

sub snmpEnvPowerStatusToText {
  my($agent, $snmpVal) = @_;

  if ($snmpVal eq '0') {
      return 'normal';
  } elsif ($snmpVal eq '1') {
      return 'warning';
  } elsif ($snmpVal eq '2') {
      return 'failed';
  } elsif ($snmpVal eq '3') {
      return 'failed';
  }

  return 'unknown';
}


sub snmpSpeedToText {
  my($agent, $snmpVal) = @_;

  if ($snmpVal eq '0') {
      return 'unknown';
  } elsif ($snmpVal eq '1') {
      return 'lowest';
  } elsif ($snmpVal eq '2') {
      return 'highest';
  } elsif ($snmpVal eq '3') {
      return 'normal';
  }

  return 'unknown';
}

sub snmpPortStatusToText {
  my($agent, $snmpVal) = @_;

  if ($snmpVal eq '1') {
      return 'up';
  } elsif ($snmpVal eq '2') {
      return 'down';
  } elsif ($snmpVal eq '3') {
      return 'testing';
  }
  return 'unknown';
}

sub snmpPortTypeToText {
  my($agent, $snmpVal) = @_;

  if ($snmpVal eq '6') {
      return 'ethernet';
  } 
  
  return 'other';
}

sub snmpSystemDriveStatusToText {
  my($agent, $snmpVal) = @_;
  
  if ($snmpVal eq '0') {
      return 'online';
  } elsif ($snmpVal eq '1') {
      return 'critical';
  } elsif ($snmpVal eq '2') {
      return 'offline';
  } elsif ($snmpVal eq '3') {
      return 'unknown';
  } elsif ($snmpVal eq '4') {
      return 'rebuild';
  } elsif ($snmpVal eq '5') {
      return 'missing';
  } elsif ($snmpVal eq '6') {
      return 'initializing';
  }

  return 'unknown';

}

sub snmpCachePolicyToText {
  my($agent, $snmpVal) = @_;

  if ($snmpVal eq '0') {
      return 'write-through';
  } elsif ($snmpVal eq '1') {
      return 'write-back';
  } 
 
  return 'unknown';
}

sub snmpRaidCntrlStatusToText {
  my($agent, $snmpVal) = @_;

  if ($snmpVal eq '0') {
      return 'failed';
  } elsif ($snmpVal eq '1') {
      return 'normal';
  }
  
  return 'unknown';
}

sub snmpPhysicalDriveStatusToText {
  my($agent, $snmpVal) = @_;
  
  if ($snmpVal eq '0') {
      return 'absent';
  } elsif ($snmpVal eq '1') {
      return 'unconfigured';
  } elsif ($snmpVal eq '2') {
      return 'rebuild';
  } elsif ($snmpVal eq '3') {
      return 'online';
  } elsif ($snmpVal eq '4') {
      return 'stand-by';
  } elsif ($snmpVal eq '5') {
      return 'unknown';
  } elsif ($snmpVal eq '6') {
      return 'offline';
  } elsif ($snmpVal eq '7') {
      return 'failed';
  } elsif ($snmpVal eq '8') {
      return 'critical';
  }

  return 'unknown';

}

sub snmpPhysicalDriveTypeToText {
  my($agent, $snmpVal) = @_;
  
  if ($snmpVal eq '0') {
      return 'other-scsi';
  } elsif ($snmpVal eq '1') {
      return 'scsi-hard-disk';
  } elsif ($snmpVal eq '2') {
      return 'sequential-access';
  } elsif ($snmpVal eq '3') {
      return 'cdrom';
  } elsif ($snmpVal eq '4') {
      return 'fc-disk';
  }

  return 'unknown';

}


sub snmpBatteryStatusToText {
  my($agent, $snmpVal) = @_;
  
  if ($snmpVal eq '0') {
      return 'unknown';
  } elsif ($snmpVal eq '1') {
      return 'normal';
  } elsif ($snmpVal eq '2') {
      return 'not-installed';
  } elsif ($snmpVal eq '3') {
      return 'failed';
  } elsif ($snmpVal eq '4') {
      return 'busy';
  }

  return 'unknown';

}

sub snmpBatteryTypeToText {
  my($agent, $snmpVal) = @_;
  
  if ($snmpVal eq '0') {
      return 'unknown';
  } elsif ($snmpVal eq '1') {
      return 'Nickel-Cadmium';
  } elsif ($snmpVal eq '2') {
      return 'Nickel-Metal-Hybrid';
  } elsif ($snmpVal eq '3') {
      return 'Lithium-Ion';
  }

  return 'unknown';

}

sub snmpPartitionModeToText {
  my($agent, $snmpVal) = @_;
  
  if ($snmpVal eq '0') {
      return 'undefined';
  } elsif ($snmpVal eq '1') {
      return 'read-write';
  } elsif ($snmpVal eq '2') {
      return 'read-only';
  } elsif ($snmpVal eq '3') {
      return 'granted';
  } elsif ($snmpVal eq '4') {
      return 'no-access';
  }  
  return 'unknown';

}

1;



