/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class PropertyConfig {
    private Properties top;
    private Map sub;
    public static final String _SOURCE_REVISION = "$Revision: 1.1 $";

    public PropertyConfig() {
        this.top = new Properties();
        this.sub = new HashMap();
    }

    public Properties getProperties() {
        return this.top;
    }

    public String getProperty(String name) {
        return this.top.getProperty(name);
    }

    public Properties getProperties(String section) {
        return (Properties)this.sub.get(section);
    }

    public String getProperty(String section, String name) {
        Properties p = (Properties)this.sub.get(section);
        if (p == null) {
            return null;
        }
        return p.getProperty(name);
    }

    public Properties addNewSection(String name) {
        Properties p = new Properties();
        this.sub.put(name, p);
        return p;
    }

    public String[] getSectionNames() {
        Set keys = this.sub.keySet();
        String[] names = new String[keys.size()];
        keys.toArray(names);
        return names;
    }

    public void store(OutputStream os) throws IOException {
        this.list(new PrintWriter(os));
    }

    public void list(PrintWriter out) {
        this.list(this.top, out);
        Set keys = this.sub.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String section = (String)iter.next();
            Properties p = (Properties)this.sub.get(section);
            out.println();
            out.print("[");
            out.print(section);
            out.println("]");
            this.list(p, out);
        }
        out.flush();
    }

    private void list(Properties p, PrintWriter out) {
        TreeMap<Object, Object> t = new TreeMap<Object, Object>(p);
        Set<Map.Entry<Object, Object>> s = t.entrySet();
        Iterator<Map.Entry<Object, Object>> iter = s.iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            out.println(key + "=" + value);
        }
    }

    public static PropertyConfig load(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader in = new BufferedReader(isr);
        return PropertyConfig.load(in);
    }

    public static PropertyConfig load(BufferedReader in) throws IOException {
        Properties prop = new Properties();
        HashMap<String, Properties> config = new HashMap<String, Properties>();
        String section = null;
        Properties place = prop;
        while (true) {
            char first;
            String line;
            if ((line = in.readLine()) == null) {
                if (place == null || place == prop) break;
                config.put(section, place);
                break;
            }
            if ((line = line.trim()).length() == 0 || line.startsWith("#") || (first = line.charAt(0)) == '\n') continue;
            if (first == '[') {
                int index;
                if (place != null && place != prop) {
                    config.put(section, place);
                    place = null;
                }
                if ((index = line.indexOf(93)) <= 1) continue;
                section = line.substring(1, index);
                place = new Properties();
                continue;
            }
            if (place == null) continue;
            String name = line;
            String value = "";
            int i = line.indexOf("=");
            if (i > 0) {
                name = line.substring(0, i);
                value = line.substring(i + 1);
            }
            place.setProperty(name, value);
        }
        return new PropertyConfig(prop, config);
    }

    private PropertyConfig(Properties top, Map sub) {
        this.top = top;
        this.sub = sub;
    }

    static {
        _SOURCE_REVISION = _SOURCE_REVISION;
    }
}

