/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.util;

import java.util.HashMap;

public class Options {
    private String[] cmdArgs;
    private String optArgs;
    private HashMap opts;
    private int argIndex = 0;

    public Options(String optArgs) {
        this.optArgs = optArgs;
    }

    public Options(String optArgs, String[] args) {
        this.optArgs = optArgs;
        this.parseOptions(args);
    }

    public String getOption(String option) {
        return (String)this.opts.get(option);
    }

    public String getOption(String option, String defaultValue) {
        String opt = this.getOption(option);
        if (opt == null) {
            return defaultValue;
        }
        return opt;
    }

    public int getIntOption(String option) {
        return Integer.parseInt(this.getOption(option));
    }

    public int getIntOption(String option, int defaultValue) {
        String opt = this.getOption(option);
        if (opt == null) {
            return defaultValue;
        }
        return Integer.parseInt(opt);
    }

    public boolean getFlagOption(String option) {
        String value = this.getOption(option);
        return "Y".equals(value);
    }

    public String getUsage() {
        return this.optArgs;
    }

    public String[] getArgs() {
        return this.cmdArgs;
    }

    public String[] parseOptions(String[] args) {
        this.opts = new HashMap();
        this.argIndex = 0;
        while (this.argIndex < args.length) {
            String arg = args[this.argIndex];
            if (!arg.startsWith("-") || arg.equals("-")) break;
            int index = this.optArgs.indexOf(arg.charAt(1));
            if (index >= 0) {
                if (++index < this.optArgs.length() && ":".equals(this.optArgs.substring(index, index + 1))) {
                    this.opts.put(arg.substring(1, 2), args[++this.argIndex]);
                } else {
                    int i = 1;
                    while (arg.length() > i) {
                        this.opts.put(arg.substring(i, i + 1), "Y");
                        ++i;
                    }
                }
            } else {
                throw new IllegalArgumentException("Unknown option " + arg);
            }
            ++this.argIndex;
        }
        this.cmdArgs = new String[args.length - this.argIndex];
        int i = this.argIndex;
        int j = 0;
        while (i < args.length) {
            this.cmdArgs[j] = args[i];
            ++i;
            ++j;
        }
        return this.cmdArgs;
    }
}

