/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.util;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;

public class InetIterator
implements Iterator {
    private BigInteger current;
    private BigInteger startInt;
    private BigInteger endInt;
    private long numAddresses;
    private long numSearched;

    public InetIterator(String ipstart, String ipend) throws UnknownHostException {
        this(InetAddress.getByName(ipstart), InetAddress.getByName(ipend));
    }

    public InetIterator(InetAddress startAddr, InetAddress endAddr) {
        byte[] startNum = startAddr.getAddress();
        byte[] endNum = endAddr.getAddress();
        this.startInt = new BigInteger(1, startNum);
        this.endInt = new BigInteger(1, endNum);
        if (this.startInt.compareTo(this.endInt) > 0) {
            BigInteger tmpInt = this.startInt;
            this.startInt = this.endInt;
            this.endInt = tmpInt;
        }
        BigInteger numAddersSearch = this.endInt.subtract(this.startInt);
        this.numAddresses = numAddersSearch.intValue() + 1;
        this.current = this.startInt;
    }

    public boolean hasNext() {
        return this.current.compareTo(this.endInt) < 1;
    }

    public Object next() {
        if (!this.hasNext()) {
            return null;
        }
        byte[] raw = this.current.toByteArray();
        byte[] rawip = new byte[4];
        int i = raw.length - 1;
        int j = 3;
        while (i >= 0 && j >= 0) {
            rawip[j] = raw[i];
            --i;
            --j;
        }
        InetAddress ip = null;
        try {
            ip = InetAddress.getByAddress(rawip);
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        this.current = this.current.add(BigInteger.ONE);
        ++this.numSearched;
        return ip;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public long getNumAddresses() {
        return this.numAddresses;
    }

    public long getNumInterated() {
        return this.numSearched;
    }

    public static void main(String[] args) {
        try {
            InetIterator iter = new InetIterator(args[0], args[1]);
            while (iter.hasNext()) {
                InetAddress addr = (InetAddress)iter.next();
                System.out.println(addr.getHostAddress() + ", " + addr.getHostName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

