/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.util;

import com.sun.netstorage.fm.storade.util.LockManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class ResourceLock {
    private String resourceName;
    private long expireSeconds;
    private String pid;
    private String info;
    private String application = "Java";
    private String description = "";
    private String ip_address = "localhost";
    private String userName = "nobody";
    public static final String sccs_id = "@(#)ResourceLock.java 1.2     03/12/05 SMI";

    public ResourceLock(String resourceName) throws IllegalArgumentException {
        if (resourceName == null) {
            throw new IllegalArgumentException("null");
        }
        int i = resourceName.lastIndexOf(".lock");
        this.resourceName = i > 0 ? resourceName.substring(0, i) : resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public long getExpireTime() {
        return this.expireSeconds;
    }

    public long getExpireInterval() {
        long ei = this.expireSeconds - this.getCurrentSeconds();
        return ei < 0L ? 0L : ei;
    }

    public String getLockProcessId() {
        return this.pid;
    }

    public String getInfo() {
        return this.info;
    }

    private String getInfo(int index) {
        String retval = null;
        try {
            StringTokenizer st = new StringTokenizer(this.info, "|", true);
            int i = 0;
            String lastToken = "|";
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("|".equals(token)) {
                    ++i;
                    if ("|".equals(lastToken)) {
                        retval = "";
                    }
                } else {
                    retval = token;
                }
                if (i == index) {
                    return retval;
                }
                lastToken = token;
            }
        }
        catch (Exception e) {
            return null;
        }
        return retval;
    }

    public String getApplication() {
        return this.getInfo(1);
    }

    public String getDescription() {
        return this.getInfo(3);
    }

    public Date getStartDate() {
        String date = this.getInfo(4);
        if (date == null) {
            return null;
        }
        try {
            int year = Integer.parseInt(date.substring(0, 4));
            int month = Integer.parseInt(date.substring(5, 7));
            int day = Integer.parseInt(date.substring(8, 10));
            int hour = Integer.parseInt(date.substring(11, 13));
            int minute = Integer.parseInt(date.substring(14, 16));
            int second = Integer.parseInt(date.substring(17, 19));
            Calendar cal = Calendar.getInstance();
            cal.set(year, month, day, hour, minute, second);
            return cal.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getDuration() {
        String dur = this.getInfo(5);
        try {
            return Integer.parseInt(dur);
        }
        catch (Exception e) {
            return (int)(this.getExpireInterval() / 60L);
        }
    }

    public String getIpAddress() {
        return this.getInfo(6);
    }

    public String getUser() {
        return this.getInfo(7);
    }

    public void setInfo(String application, String description, String ip_address, String userName) {
        this.application = application;
        this.description = description;
        this.ip_address = ip_address;
        this.userName = userName;
    }

    public boolean isLocked() {
        if (this.getCurrentSeconds() > this.expireSeconds) {
            this.unlink();
            return false;
        }
        return true;
    }

    public boolean isFRULocked() throws IOException {
        File lockDir = new File("/tmp/MgmtLocks");
        String subfru = this.resourceName + "~";
        String[] fnames = lockDir.list(new FRUFilter(subfru));
        if (fnames != null) {
            int i = 0;
            while (i < fnames.length) {
                ResourceLock lock = new ResourceLock(fnames[i]);
                lock.readLock();
                if (lock.isLocked()) {
                    return true;
                }
                ++i;
            }
        }
        StringTokenizer st = new StringTokenizer(this.resourceName, "~");
        String sys = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            sys = sys == null ? token : sys + "~" + token;
            ResourceLock lock = new ResourceLock(sys);
            lock.readLock();
            if (!lock.isLocked()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void readLock() throws IOException {
        FileReader fr;
        block8: {
            block7: {
                File resourceFile = this.getResourceFile();
                if (!resourceFile.exists()) {
                    this.expireSeconds = 0L;
                    this.pid = null;
                    this.info = null;
                    return;
                }
                fr = null;
                try {
                    try {
                        fr = new FileReader(resourceFile);
                        BufferedReader in = new BufferedReader(fr);
                        String expLine = in.readLine();
                        if (expLine == null) {
                            this.expireSeconds = 0L;
                            this.pid = null;
                            this.info = null;
                            Object var6_6 = null;
                            if (fr == null) return;
                            break block7;
                        }
                        this.expireSeconds = Long.parseLong(expLine);
                        this.pid = in.readLine();
                        this.info = in.readLine();
                        break block8;
                    }
                    catch (IOException e) {
                        this.expireSeconds = 0L;
                        this.pid = null;
                        this.info = null;
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (fr == null) throw throwable;
                    fr.close();
                    throw throwable;
                }
            }
            fr.close();
            return;
        }
        Object var6_7 = null;
        if (fr == null) return;
        fr.close();
    }

    synchronized boolean lock(long expireTime, String info) throws IOException {
        this.readLock();
        if (this.isLocked()) {
            return false;
        }
        File resourceFile = this.getResourceFile();
        resourceFile.createNewFile();
        PrintWriter out = null;
        String expLine = Long.toString(expireTime);
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(resourceFile)));
            out.println(expLine);
            out.println(LockManager.getPid());
            if (info == null) {
                info = this.getInfo(expireTime);
            }
            out.println(info);
            Object var9_6 = null;
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
        return true;
    }

    synchronized void unlock() throws IOException {
        this.readLock();
        if (this.isLocked()) {
            this.unlink();
        }
    }

    private String getInfo(long expireTime) {
        StringBuffer buf = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(2);
        StringBuffer start = new StringBuffer();
        start.append(cal.get(1));
        start.append("-");
        start.append(nf.format(cal.get(2) + 1));
        start.append("-");
        start.append(nf.format(cal.get(5)));
        start.append(" ");
        start.append(nf.format(cal.get(11)));
        start.append(":");
        start.append(nf.format(cal.get(12)));
        start.append(":");
        start.append(nf.format(cal.get(13)));
        long duration = (expireTime - cal.getTimeInMillis() / 1000L) / 60L;
        buf.append(this.application);
        buf.append("|");
        buf.append(this.resourceName);
        buf.append("|");
        buf.append(this.description);
        buf.append("|");
        buf.append(start.toString());
        buf.append("|" + duration);
        buf.append("|");
        buf.append(this.ip_address);
        buf.append("|");
        buf.append(this.userName);
        return buf.toString();
    }

    private void unlink() {
        File resourceFile = this.getResourceFile();
        if (resourceFile.exists()) {
            this.expireSeconds = 0L;
            this.pid = null;
            this.info = null;
            resourceFile.delete();
        }
    }

    private File getResourceFile() {
        return new File("/tmp/MgmtLocks", this.resourceName + ".lock");
    }

    private long getCurrentSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    static {
        sccs_id = sccs_id;
    }

    private class FRUFilter
    implements FilenameFilter {
        private String comp;

        FRUFilter(String comp) {
            this.comp = comp;
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(this.comp);
        }
    }
}

