/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.service.message;

import com.sun.netstorage.fm.storade.service.message.Message;
import com.sun.netstorage.fm.storade.service.message.MessageSeverity;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogMessage
implements Message {
    private String messageID;
    private int severity;
    private String source;
    private String component;
    private Date messageTime;
    private String description;
    public static final String _SOURCE_REVISION = "$Revision: 1.5 $";

    public LogMessage(String messageID, int severity, String source, String component, Date messageTime, String description) {
        this.messageID = messageID;
        this.severity = severity;
        this.source = source;
        this.component = component;
        this.messageTime = messageTime;
        this.description = description;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getType() {
        return "Log";
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getSource() {
        return this.source;
    }

    public String getComponent() {
        return this.component;
    }

    public Date getMessageTime() {
        return this.messageTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.messageTime == null) {
            this.messageTime = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd HH:mm:ss");
        sdf.format(this.messageTime, buf, new FieldPosition(0));
        buf.append(" ");
        buf.append(this.source);
        if (this.component != null) {
            buf.append(" ");
            buf.append(this.component);
        }
        buf.append(": ");
        if (this.messageID != null) {
            buf.append("[ID ");
            buf.append(this.messageID);
            buf.append("] ");
        }
        buf.append(MessageSeverity.toString(this.severity) + ": ");
        buf.append(this.description);
        return buf.toString();
    }

    static {
        _SOURCE_REVISION = _SOURCE_REVISION;
    }
}

