/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.service.message;

import com.sun.netstorage.fm.storade.service.message.Message;
import com.sun.netstorage.fm.storade.service.message.MessageSeverity;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class FaultMessage
implements Message {
    private String messageID;
    private String type;
    private String version;
    private int severity;
    private Date messageTime;
    private String environment;
    private String source;
    private String eventID;
    private String description;
    private String knowledgeLink;
    private String autoResponse;
    private String impact;
    private String requiredAction;
    public final String cvs_id = "$Id: FaultMessage.java,v 1.2 2004/08/11 22:55:37 jkremer Exp $";

    public FaultMessage(Properties props) {
        this.messageID = props.getProperty("MessageID");
        this.type = props.getProperty("Type");
        this.version = props.getProperty("Version");
        this.severity = FaultMessage.parseSeverity(props.getProperty("Severity"));
        this.messageTime = FaultMessage.parseMessageTime(props.getProperty("Event-Time"));
        this.environment = props.getProperty("Environment");
        this.source = props.getProperty("Source");
        this.eventID = props.getProperty("EventID");
        this.description = props.getProperty("Description");
        this.knowledgeLink = props.getProperty("Knowledge-Link");
        this.autoResponse = props.getProperty("Auto-Response");
        this.impact = props.getProperty("Impact");
        this.requiredAction = props.getProperty("Required-Action");
    }

    public FaultMessage(String messageID, String type, String version, int severity, Date eventTime, String environment, String source, String eventID, String description, String knowledgeLink, String autoResponse, String impact, String requiredAction) {
        this.messageID = messageID;
        this.type = type;
        this.version = version;
        this.severity = severity;
        this.messageTime = eventTime;
        this.environment = environment;
        this.source = source;
        this.eventID = eventID;
        this.description = description;
        this.knowledgeLink = knowledgeLink;
        this.autoResponse = autoResponse;
        this.impact = impact;
        this.requiredAction = requiredAction;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public int getSeverity() {
        return this.severity;
    }

    public Date getMessageTime() {
        return this.messageTime;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getComponent() {
        return this.environment;
    }

    public String getSource() {
        return this.source;
    }

    public String getEventID() {
        return this.eventID;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKnowledgeLink() {
        return this.knowledgeLink;
    }

    public String getAutoResponse() {
        return this.autoResponse;
    }

    public String getImpact() {
        return this.impact;
    }

    public String getRequiredAction() {
        return this.requiredAction;
    }

    public String toString() {
        StringBuffer msg = new StringBuffer();
        msg.append("SUNW-MSG-ID:" + this.getMessageID());
        msg.append(", TYPE:" + this.getType());
        msg.append(", VER:" + this.getVersion());
        msg.append(", SEVERITY:" + MessageSeverity.toString(this.getSeverity()) + "\n");
        msg.append("EVENT-TIME:" + this.getMessageTime() + "\n");
        msg.append("DOMAIN-ID:" + this.getEnvironment() + "\n");
        msg.append("SOURCE:" + this.getSource() + "\n");
        msg.append("EVENT-ID:" + this.getEventID() + "\n");
        msg.append("DESC:" + this.getDescription() + this.getKnowledgeLink() + "\n");
        msg.append("AUTO-RESPONSE:" + this.getAutoResponse() + "\n");
        msg.append("IMPACT:" + this.getImpact() + "\n");
        msg.append("REQ-ACTION:" + this.getRequiredAction() + "\n");
        return msg.toString();
    }

    private static int parseSeverity(String sSeverity) {
        MessageSeverity ms = new MessageSeverity(sSeverity);
        return ms.getSeverity();
    }

    private static Date parseMessageTime(String time) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy");
            return sdf.parse(time, new ParsePosition(0));
        }
        catch (Exception e) {
            return new Date();
        }
    }
}

