/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.service.device;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class DeviceProperties
implements Serializable {
    public static final String ACTIVE = "active";
    public static final String KEY = "key";
    public static final String HOST = "host";
    public static final String TYPE = "type";
    public static final String CLASS = "class";
    public static final String NAME = "name";
    public static final String LABEL = "userLabel";
    public static final String TIME_ADDED = "time_added";
    public static final String WWN = "wwn";
    public static final String ALT_WWN = "wwn2";
    public static final String WWN_LIST = "wwns";
    public static final String IP = "ip";
    public static final String IPNO = "ipno";
    public static final String ALT_IP = "altip";
    public static final String ALT_IPNO = "altipno";
    public static final String IP_LIST = "ips";
    public static final String PROXYS = "proxys";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    private Properties dp;
    public static final String cvs_id = "$Id: DeviceProperties.java,v 1.6 2004/10/13 18:10:07 jkremer Exp $";

    public DeviceProperties() {
        this.dp = new Properties();
    }

    public DeviceProperties(Properties deviceProperties) {
        this.dp = deviceProperties;
    }

    public String getKey() {
        return this.dp.getProperty(KEY);
    }

    public void setKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.dp.setProperty(KEY, key);
    }

    public String getType() {
        return this.dp.getProperty(TYPE);
    }

    public void setType(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.dp.setProperty(TYPE, type);
    }

    public String getDevClass() {
        return this.dp.getProperty(CLASS);
    }

    public void setClass(String devClass) {
        if (devClass == null) {
            throw new IllegalArgumentException();
        }
        this.dp.setProperty(CLASS, devClass);
    }

    public boolean getActive() {
        String active = this.dp.getProperty(ACTIVE);
        return "Y".equals(active);
    }

    public void setActive(boolean active) {
        this.dp.setProperty(ACTIVE, active ? "Y" : "N");
    }

    public String getHost() {
        String host = this.dp.getProperty(HOST);
        if (host == null) {
            return "localhost";
        }
        return host;
    }

    public void setHost(String host) {
        if (host == null) {
            this.dp.remove(HOST);
        } else {
            this.dp.setProperty(HOST, host);
        }
    }

    public String getName() {
        return this.dp.getProperty(NAME);
    }

    public void setName(String name) {
        if (name == null) {
            this.dp.remove(NAME);
        } else {
            this.dp.setProperty(NAME, name);
        }
    }

    public String getWWN() {
        return this.dp.getProperty(WWN);
    }

    public void setWWN(String wwn) {
        if (wwn == null) {
            this.dp.remove(WWN);
        } else {
            this.dp.setProperty(WWN, wwn);
        }
    }

    public String[] getWWNs() {
        String wwns = this.dp.getProperty(WWN_LIST);
        if (wwns == null) {
            return new String[0];
        }
        LinkedList<String> list = new LinkedList<String>();
        if (wwns != null) {
            StringTokenizer st = new StringTokenizer(wwns, "|");
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return this.makeArray(list);
    }

    public void setWWNs(String[] wwns) {
        this.setValueList(WWN_LIST, wwns);
    }

    public void addWWN(String wwn) {
        this.addValueToList(WWN_LIST, wwn);
    }

    public void removeWWN(String wwn) {
        this.removeValueFromList(WWN_LIST, wwn);
    }

    public String getIP() {
        return this.dp.getProperty(IP);
    }

    public void setIP(String ip) {
        if (ip == null) {
            this.dp.remove(IP);
        } else {
            this.dp.setProperty(IP, ip);
        }
    }

    public void setIPAddress(String ip) throws UnknownHostException {
        if (ip == null) {
            this.dp.remove(IP);
            this.dp.remove(IPNO);
        }
        InetAddress addr = InetAddress.getByName(ip);
        this.dp.setProperty(IP, addr.getHostName());
        this.dp.setProperty(IPNO, addr.getHostAddress());
    }

    public String getIPNumber() {
        return this.dp.getProperty(IPNO);
    }

    public void setIPNumber(String ipno) {
        if (ipno == null) {
            this.dp.remove(IPNO);
        } else {
            this.dp.setProperty(IPNO, ipno);
        }
    }

    public String getAlternateIP() {
        return this.dp.getProperty(ALT_IP);
    }

    public void setAlternateIP(String ip) {
        if (ip == null) {
            this.dp.remove(ALT_IP);
        } else {
            this.dp.setProperty(ALT_IP, ip);
        }
    }

    public String getAlternateIPNumber() {
        return this.dp.getProperty(ALT_IPNO);
    }

    public void setAlternateIPAddress(String ip) throws UnknownHostException {
        if (ip == null) {
            this.dp.remove(ALT_IP);
            this.dp.remove(ALT_IPNO);
        }
        InetAddress addr = InetAddress.getByName(ip);
        this.dp.setProperty(ALT_IP, addr.getHostName());
        this.dp.setProperty(ALT_IPNO, addr.getHostAddress());
    }

    public void setAlternateIPNumber(String ip) {
        if (ip == null) {
            this.dp.remove(ALT_IPNO);
        } else {
            this.dp.setProperty(ALT_IPNO, ip);
        }
    }

    public String[] getManagementAddresses() {
        String proxys = this.dp.getProperty(PROXYS);
        if (proxys == null) {
            return new String[0];
        }
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(proxys, "|");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return this.makeArray(list);
    }

    public void setManagementAddresses(String[] adders) {
        this.setValueList(PROXYS, adders);
    }

    public void addManagementAddress(String address) {
        this.addValueToList(PROXYS, address);
    }

    public void removeManagementAddress(String address) {
        this.removeValueFromList(PROXYS, address);
    }

    public String getPassword() {
        String pass = this.dp.getProperty(PASSWORD);
        if (pass == null) {
            return null;
        }
        if ("".equals(pass)) {
            return "";
        }
        int tsize = 0;
        int i = 0;
        while (i < pass.length()) {
            if ('%' == pass.charAt(i)) {
                ++tsize;
            }
            ++i;
        }
        if (tsize == 0) {
            return pass;
        }
        char[] pb = new char[tsize];
        StringTokenizer st = new StringTokenizer(pass, "%");
        i = 0;
        while (st.hasMoreTokens()) {
            int c = Integer.parseInt(st.nextToken(), 16);
            c ^= 0xFFFFFFFF;
            pb[i] = (char)(c -= 13);
            ++i;
        }
        return new String(pb);
    }

    public void setPassword(String password) {
        if (password == null) {
            this.dp.remove(PASSWORD);
        } else {
            StringBuffer encode = new StringBuffer();
            char[] pb = password.toCharArray();
            int i = 0;
            while (i < pb.length) {
                int c = pb[i] + 13;
                encode.append(Integer.toHexString(~c & 0xFFFF));
                encode.append("%");
                ++i;
            }
            this.dp.setProperty(PASSWORD, encode.toString());
        }
    }

    public String getUserName() {
        return this.dp.getProperty(USER);
    }

    public void setUserName(String user) {
        if (user == null) {
            this.dp.remove(USER);
        } else {
            this.dp.setProperty(USER, user);
        }
    }

    public String getLabel() {
        return this.dp.getProperty(LABEL);
    }

    public void setLabel(String label) {
        if (label == null) {
            this.dp.remove(LABEL);
        } else {
            this.dp.setProperty(LABEL, label);
        }
    }

    public String getProperty(String name) {
        return this.dp.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.dp.setProperty(name, value);
    }

    public void removeProperty(String name) {
        this.dp.remove(name);
    }

    public Properties getProperties() {
        return this.dp;
    }

    private String[] makeArray(List list) {
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    private void setValueList(String name, String[] vlist) {
        if (vlist == null || vlist.length == 0) {
            this.dp.remove(name);
            return;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < vlist.length) {
            buf.append(vlist[i]);
            if (i < vlist.length - 1) {
                buf.append("|");
            }
            ++i;
        }
        this.dp.setProperty(name, buf.toString());
    }

    private String[] getValueList(String name) {
        String vals = this.dp.getProperty(name);
        if (vals == null) {
            return new String[0];
        }
        LinkedList<String> list = new LinkedList<String>();
        if (vals != null) {
            StringTokenizer st = new StringTokenizer(vals, "|");
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
        }
        return this.makeArray(list);
    }

    private void addValueToList(String name, String val) {
        String list = this.dp.getProperty(name);
        if (list == null) {
            this.dp.setProperty(name, val);
            return;
        }
        int vindex = list.indexOf(val);
        if (vindex >= 0) {
            return;
        }
        this.dp.setProperty(name, list + "|" + val);
    }

    private void removeValueFromList(String name, String val) {
        String list = this.dp.getProperty(name);
        if (list == null) {
            return;
        }
        int vindex = list.indexOf(val);
        int len = val.length();
        if (vindex < 0) {
            return;
        }
        if (vindex == 0) {
            this.dp.setProperty(name, list.substring(len + 1));
        } else {
            this.dp.setProperty(name, list.substring(0, vindex - 1) + list.substring(vindex + len));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        TreeMap<Object, Object> t = new TreeMap<Object, Object>(this.dp);
        Set<Map.Entry<Object, Object>> s = t.entrySet();
        Iterator<Map.Entry<Object, Object>> iter = s.iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            buf.append((String)entry.getKey());
            buf.append("=");
            buf.append((String)entry.getValue());
            buf.append(" ");
        }
        return buf.toString();
    }

    static {
        ACTIVE = ACTIVE;
        KEY = KEY;
        HOST = HOST;
        TYPE = TYPE;
        CLASS = CLASS;
        NAME = NAME;
        LABEL = LABEL;
        TIME_ADDED = TIME_ADDED;
        WWN = WWN;
        ALT_WWN = ALT_WWN;
        WWN_LIST = WWN_LIST;
        IP = IP;
        IPNO = IPNO;
        ALT_IP = ALT_IP;
        ALT_IPNO = ALT_IPNO;
        IP_LIST = IP_LIST;
        PROXYS = PROXYS;
        USER = USER;
        PASSWORD = PASSWORD;
        cvs_id = cvs_id;
    }
}

