/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.AbstractService;
import com.sun.netstorage.fm.storade.client.http.AgentCommand;
import com.sun.netstorage.fm.storade.client.http.AgentError;
import com.sun.netstorage.fm.storade.client.http.HTTPResponse;
import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.message.Message;
import com.sun.netstorage.fm.storade.service.message.MessagePostService;
import java.net.URL;
import org.w3c.dom.Node;

public class MessagePostImpl
extends AbstractService
implements MessagePostService {
    public static final String _SOURCE_REVISION = "$Revision: 1.1 $";

    public MessagePostImpl(URL agent, String user, String credential) {
        super(agent, user, credential);
    }

    public void post(Message message) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Message::logLine");
        cmd.setProperty("type", message.getSource());
        cmd.setProperty("line", message.toString());
        cmd.setProperty("component", message.getComponent());
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp, "MESSAGE");
        if (error.isError()) {
            throw error.toException();
        }
        String data = MessagePostImpl.parseRootData(resp.getData());
        if (!"LOGGED".equals(data)) {
            throw new StoradeException("sa.error", new Object[]{data});
        }
    }

    public void post(Message[] s) throws StoradeException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < s.length) {
            this.post(s[i]);
            ++i;
        }
    }

    private static String parseRootData(String report) {
        Node node = XMLUtil.getNode(report);
        if (node.getNodeType() == 1 && "MESSAGE".equals(node.getNodeName())) {
            return XMLUtil.getCdata(node);
        }
        return null;
    }

    static {
        _SOURCE_REVISION = _SOURCE_REVISION;
    }
}

