/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.AgentCommand;
import com.sun.netstorage.fm.storade.client.http.AgentError;
import com.sun.netstorage.fm.storade.client.http.HTTPConnection;
import com.sun.netstorage.fm.storade.client.http.HTTPResponse;
import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.lock.LockInfo;
import com.sun.netstorage.fm.storade.service.lock.LockManagerService;
import java.net.URL;
import java.util.LinkedList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LockManagerImpl
implements LockManagerService {
    private URL agent;
    private String user;
    private String credential;
    public static final String cvs_id = "$Id: LockManagerImpl.java,v 1.5 2004/10/13 18:09:46 jkremer Exp $";

    public LockManagerImpl(URL agent, String user, String credential) {
        this.agent = agent;
        this.user = user;
        this.credential = credential;
    }

    public synchronized boolean lock(String resourceName, String application, String description, String ip_address, String userName, int length, int wait) throws StoradeException {
        HTTPConnection http = this.getConnection();
        AgentCommand cmd = new AgentCommand("Client::Lock::lock");
        cmd.setProperty("resource", resourceName);
        cmd.setProperty("app", application);
        cmd.setProperty("desc", description);
        cmd.setProperty("ip", ip_address);
        cmd.setProperty("user", userName);
        cmd.setProperty("seconds", Integer.toString(length));
        cmd.setProperty("wait", Integer.toString(wait));
        HTTPResponse resp = http.getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            if (error.getErrorNumber() == 101) {
                return false;
            }
            throw error.toException();
        }
        return true;
    }

    public synchronized boolean isLocked(String resourceName) throws StoradeException {
        LockInfo li = this.getLockInfo(resourceName);
        return li.isLocked();
    }

    public synchronized void unlock(String resourceName, String application, String userName) throws StoradeException {
        HTTPConnection http = this.getConnection();
        AgentCommand cmd = new AgentCommand("Client::Lock::unlock");
        cmd.fastcgi();
        cmd.setProperty("resource", resourceName);
        HTTPResponse resp = http.getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
    }

    public synchronized LockInfo getLockInfo(String resourceName) throws StoradeException {
        HTTPConnection http = this.getConnection();
        AgentCommand cmd = new AgentCommand("Client::Lock::check");
        cmd.fastcgi();
        cmd.setProperty("resource", resourceName);
        HTTPResponse resp = http.getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
        return LockManagerImpl.parseLockCheck(resp.getData(), resourceName);
    }

    public synchronized LockInfo[] getLocks() throws StoradeException {
        HTTPConnection http = this.getConnection();
        AgentCommand cmd = new AgentCommand("Client::Lock::list");
        cmd.fastcgi();
        HTTPResponse resp = http.getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
        return LockManagerImpl.parseLockList(resp.getData());
    }

    private static LockInfo parseLockCheck(String doc, String resource) {
        return LockManagerImpl.parseLockCheck(XMLUtil.getNode(doc), resource);
    }

    private static LockInfo parseLockCheck(Node node, String resource) {
        if (node.getNodeType() == 1 && "LOCK_CHECK".equals(node.getNodeName())) {
            LockInfo li = new LockInfo();
            li.setResourceName(resource);
            NodeList children = node.getChildNodes();
            if (children != null) {
                int j = 0;
                while (j < children.getLength()) {
                    Node cnode = children.item(j);
                    LockManagerImpl.parseLockNode(cnode, li);
                    ++j;
                }
            }
            return li;
        }
        return null;
    }

    private static LockInfo[] parseLockList(String doc) {
        return LockManagerImpl.parseLockList(XMLUtil.getNode(doc));
    }

    private static LockInfo[] parseLockList(Node node) {
        NodeList children;
        LinkedList list = new LinkedList();
        if (node.getNodeType() == 1 && "LOCK_LIST".equals(node.getNodeName()) && (children = node.getChildNodes()) != null) {
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                LockManagerImpl.parseLock(cnode, list);
                ++j;
            }
        }
        LockInfo[] li = new LockInfo[list.size()];
        list.toArray(li);
        return li;
    }

    private static void parseLock(Node node, LinkedList list) {
        NodeList children;
        if (node.getNodeType() == 1 && "LOCK".equals(node.getNodeName()) && (children = node.getChildNodes()) != null) {
            LockInfo li = new LockInfo();
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                LockManagerImpl.parseLockNode(cnode, li);
                ++j;
            }
            list.add(li);
        }
    }

    private static void parseLockNode(Node node, LockInfo li) {
        if (node.getNodeType() == 1) {
            if ("LOCKED".equals(node.getNodeName())) {
                String lval = XMLUtil.getCdata(node).trim();
                if ("1".equals(lval)) {
                    li.setLocked(true);
                } else {
                    li.setLocked(false);
                }
            } else if ("TIME_LEFT".equals(node.getNodeName())) {
                String tval = XMLUtil.getCdata(node).trim();
                li.setSecondsRemaining(Integer.parseInt(tval));
            } else if ("INFO".equals(node.getNodeName())) {
                li.parseInfo(XMLUtil.getCdata(node));
            } else if ("PID".equals(node.getNodeName())) {
                li.setPid(XMLUtil.getCdata(node));
            } else if ("RESOURCE".equals(node.getNodeName())) {
                li.setResourceName(XMLUtil.getCdata(node));
            }
        }
    }

    private HTTPConnection getConnection() {
        if (this.user == null) {
            return new HTTPConnection(this.agent);
        }
        return new HTTPConnection(this.agent, this.user, this.credential);
    }

    static /* synthetic */ LockInfo access$000(String x0, String x1) {
        return LockManagerImpl.parseLockCheck(x0, x1);
    }

    static {
        cvs_id = cvs_id;
    }
}

