/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.AgentCommand;
import com.sun.netstorage.fm.storade.client.http.AgentError;
import com.sun.netstorage.fm.storade.client.http.ComponentSummaryImpl;
import com.sun.netstorage.fm.storade.client.http.HTTPConnection;
import com.sun.netstorage.fm.storade.client.http.HTTPResponse;
import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.device.DeviceReportService;
import com.sun.netstorage.fm.storade.service.device.DeviceSummary;
import java.net.URL;
import java.util.LinkedList;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeviceReportImpl
implements DeviceReportService {
    private URL agent;
    private String user;
    private String credential;
    public static final String cvs_id = "$Id: DeviceReportImpl.java,v 1.5 2004/10/13 18:09:45 jkremer Exp $";

    public DeviceReportImpl(URL agent, String user, String credential) {
        this.agent = agent;
        this.user = user;
        this.credential = credential;
    }

    public DeviceSummary[] getDeviceList() throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Device::getSummary");
        cmd.fastcgi();
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp, "DEVICE_SUMMARY");
        if (error.isError()) {
            throw error.toException();
        }
        return DeviceReportImpl.parseDeviceSummaryNode(XMLUtil.getNode(resp.getData()));
    }

    public DeviceSummary getDeviceSummary(String key) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Device::getSummary");
        cmd.fastcgi();
        cmd.setProperty("key", key);
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp, "DEVICE_SUMMARY");
        if (error.isError()) {
            throw error.toException();
        }
        DeviceSummary[] ds = DeviceReportImpl.parseDeviceSummaryNode(XMLUtil.getNode(resp.getData()));
        if (ds != null && ds.length > 0) {
            return ds[0];
        }
        throw new StoradeException();
    }

    public Properties getClassProperties(String type) throws StoradeException {
        return null;
    }

    public Properties getProperties(String devKey, boolean stdOnly) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::InstrReport::report");
        cmd.setProperty("key", devKey);
        cmd.setProperty("format", "xml");
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isOK()) {
            Properties hp = new Properties();
            Properties dp = new Properties();
            DeviceReportImpl.parseReportDoc(resp.getData(), hp, dp);
            if (stdOnly) {
                // empty if block
            }
            return dp;
        }
        throw error.toException();
    }

    public Properties getProperties(String devKey, String component, boolean stdOnly) throws StoradeException {
        Properties dp = this.getProperties(devKey, stdOnly);
        return dp;
    }

    public Properties getSystemProperties(String devKey, boolean stdOnly) throws StoradeException {
        return null;
    }

    public String[] getComponentNames(String devKey) throws StoradeException {
        return new String[0];
    }

    private static void parseReportDoc(String doc, Properties hp, Properties cp) {
        DeviceReportImpl.parseReportNode(XMLUtil.getNode(doc), hp, cp);
    }

    private static void parseReportNode(Node node, Properties hp, Properties cp) {
        if (node.getNodeType() == 1) {
            if ("REPORT".equals(node.getNodeName())) {
                NodeList children = node.getChildNodes();
                if (children != null) {
                    Properties p = new Properties();
                    int j = 0;
                    while (j < children.getLength()) {
                        Node cnode = children.item(j);
                        DeviceReportImpl.parseReportNode(cnode, hp, cp);
                        ++j;
                    }
                }
            } else if ("HEADER".equals(node.getNodeName())) {
                XMLUtil.parseValues(node, hp);
            } else if ("COMPONENT".equals(node.getNodeName())) {
                XMLUtil.parseValues(node, cp);
            }
        }
    }

    private static DeviceSummary[] parseDeviceSummaryNode(Node node) {
        if (!XMLUtil.isElement(node, "DEVICE_SUMMARY")) {
            return new DeviceSummary[0];
        }
        LinkedList<Properties> list = new LinkedList<Properties>();
        NodeList children = node.getChildNodes();
        if (children != null) {
            int j = 0;
            while (j < children.getLength()) {
                Node cnode = children.item(j);
                Properties p = DeviceReportImpl.parseDeviceSummaryProperties(cnode);
                if (p != null) {
                    list.add(p);
                }
                ++j;
            }
        }
        Properties[] props = new Properties[list.size()];
        list.toArray(props);
        DeviceSummary[] ds = new DeviceSummary[list.size()];
        int i = 0;
        while (i < ds.length) {
            ds[i] = new DeviceSummary(props[i]);
            ++i;
        }
        return ds;
    }

    private static Properties parseDeviceSummaryProperties(Node node) {
        if (!XMLUtil.isElement(node, "DEVICE")) {
            return null;
        }
        Properties p = new Properties();
        XMLUtil.parseValues(node, p);
        return p;
    }

    private static void parseSummaryNode(Node node, LinkedList list) {
        if (node.getNodeType() == 1) {
            if ("REPORT".equals(node.getNodeName()) || "CONTENT".equals(node.getNodeName()) || "LOGICAL".equals(node.getNodeName()) || "FRU".equals(node.getNodeName())) {
                NodeList children = node.getChildNodes();
                if (children != null) {
                    Properties p = new Properties();
                    int j = 0;
                    while (j < children.getLength()) {
                        Node cnode = children.item(j);
                        DeviceReportImpl.parseSummaryNode(cnode, list);
                        ++j;
                    }
                }
            } else if ("COMPONENT".equals(node.getNodeName())) {
                Properties p = new Properties();
                XMLUtil.parseValues(node, p);
                list.add(new ComponentSummaryImpl(p));
            }
        }
    }

    private HTTPConnection getConnection() {
        if (this.user == null) {
            return new HTTPConnection(this.agent);
        }
        return new HTTPConnection(this.agent, this.user, this.credential);
    }

    static {
        cvs_id = cvs_id;
    }
}

