/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.AbstractService;
import com.sun.netstorage.fm.storade.client.http.AgentCommand;
import com.sun.netstorage.fm.storade.client.http.AgentError;
import com.sun.netstorage.fm.storade.client.http.AlarmSummaryXML;
import com.sun.netstorage.fm.storade.client.http.AlarmXMLImpl;
import com.sun.netstorage.fm.storade.client.http.HTTPResponse;
import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.alarm.Alarm;
import com.sun.netstorage.fm.storade.service.alarm.AlarmCounts;
import com.sun.netstorage.fm.storade.service.alarm.AlarmQueryService;
import com.sun.netstorage.fm.storade.service.alarm.AlarmSummary;
import com.sun.netstorage.fm.storade.util.StoradeDate;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AlarmQueryImpl
extends AbstractService
implements AlarmQueryService {
    public static final String cvs_id = "$Id: AlarmQueryImpl.java,v 1.8 2004/10/13 18:09:45 jkremer Exp $";

    public AlarmQueryImpl(URL agent, String user, String credential) {
        super(agent, user, credential);
    }

    public AlarmCounts getAlarmCounts() throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Alarm::summary");
        cmd.fastcgi();
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isError()) {
            throw error.toException();
        }
        AlarmCounts ac = AlarmQueryImpl.parseAlarmCounts(resp.getData());
        return ac;
    }

    public AlarmCounts getAlarmCounts(String deviceFilter) throws StoradeException {
        AlarmSummary[] as = this.getAlarms(null, null, new String[]{deviceFilter});
        int[] counts = new int[4];
        int i = 0;
        while (i < as.length) {
            this.addCount(as[i].getSeverity(), counts);
            ++i;
        }
        return new AlarmCounts(counts[0], counts[1], counts[2], counts[3]);
    }

    public AlarmCounts getAlarmCounts(int[] state, String[] device) throws StoradeException {
        AlarmSummary[] as = this.getAlarms(null, state, device);
        int[] counts = new int[4];
        int i = 0;
        while (i < as.length) {
            this.addCount(as[i].getSeverity(), counts);
            ++i;
        }
        return new AlarmCounts(counts[0], counts[1], counts[2], counts[3]);
    }

    private boolean devMatch(String type, String key, String filter) {
        if (filter == null) {
            return true;
        }
        if (filter.indexOf(":") > 0) {
            return filter.equals(type + ":" + key);
        }
        return filter.equals(type);
    }

    private void addCount(int severity, int[] counts) {
        switch (severity) {
            case 4: {
                counts[0] = counts[0] + 1;
                break;
            }
            case 3: {
                counts[1] = counts[1] + 1;
                break;
            }
            case 2: {
                counts[2] = counts[2] + 1;
                break;
            }
            case 1: {
                counts[3] = counts[3] + 1;
            }
        }
    }

    public AlarmSummary[] getAlarms() throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Control::GetAlarms");
        cmd.setProperty("format", "xml");
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp.getData());
        if (error.isError()) {
            throw error.toException();
        }
        return AlarmSummaryXML.parseXML(resp.getData());
    }

    public AlarmSummary[] getAlarms(int[] severity, int[] state, String[] device) throws StoradeException {
        AlarmSummary[] as = this.getAlarms();
        LinkedList<AlarmSummary> list = new LinkedList<AlarmSummary>();
        int i = 0;
        while (i < as.length) {
            int aState = as[i].getState();
            String type = as[i].getDeviceType();
            String key = as[i].getDeviceKey();
            boolean stateFilter = true;
            boolean devFilter = true;
            if (state != null) {
                stateFilter = false;
                int s = as[i].getState();
                int j = 0;
                while (j < state.length) {
                    if (s == state[j]) {
                        stateFilter = true;
                        break;
                    }
                    ++j;
                }
            }
            if (device != null) {
                devFilter = false;
                int j = 0;
                while (j < device.length) {
                    if (this.devMatch(type, key, device[j])) {
                        devFilter = true;
                        break;
                    }
                    ++j;
                }
            }
            if (devFilter && stateFilter) {
                list.add(as[i]);
            }
            ++i;
        }
        AlarmSummary[] retval = new AlarmSummary[list.size()];
        list.toArray(retval);
        return retval;
    }

    public Alarm getAlarmDetail(String alarmSummaryId) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Alarm::GetAlarm");
        cmd.setProperty("format", "xml");
        cmd.setProperty("event", alarmSummaryId);
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp.getData());
        if (error.isError()) {
            throw error.toException();
        }
        return AlarmXMLImpl.parseAlarm(resp.getData());
    }

    public Alarm getAlarmDetail(String alarmSummaryId, Locale locale) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Alarm::GetAlarm");
        cmd.setProperty("format", "xml");
        cmd.setProperty("event", alarmSummaryId);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        cmd.setProperty("locale", locale.getCountry());
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp.getData());
        if (error.isError()) {
            throw error.toException();
        }
        return AlarmXMLImpl.parseAlarm(resp.getData());
    }

    private static AlarmCounts parseAlarmCounts(String report) {
        int[] a = new int[4];
        Date date = new Date();
        AlarmQueryImpl.parseAlarmCountsNode(XMLUtil.getNode(report), a, date);
        return new AlarmCounts(a[0], a[1], a[2], a[3], date);
    }

    private static void parseAlarmCountsNode(Node node, int[] a, Date d) {
        if (node.getNodeType() == 1) {
            if ("alarmSummary".equals(node.getNodeName())) {
                NodeList children = node.getChildNodes();
                if (children != null) {
                    int j = 0;
                    while (j < children.getLength()) {
                        Node cnode = children.item(j);
                        AlarmQueryImpl.parseAlarmCountsNode(cnode, a, d);
                        ++j;
                    }
                }
            } else if ("date".equals(node.getNodeName())) {
                StoradeDate sd = new StoradeDate(XMLUtil.getCdata(node));
                d = sd.getDate();
            } else if ("down".equals(node.getNodeName())) {
                a[0] = Integer.parseInt(XMLUtil.getCdata(node).trim());
            } else if ("critical".equals(node.getNodeName())) {
                a[1] = Integer.parseInt(XMLUtil.getCdata(node).trim());
            } else if ("major".equals(node.getNodeName())) {
                a[2] = Integer.parseInt(XMLUtil.getCdata(node).trim());
            } else if ("minor".equals(node.getNodeName())) {
                a[3] = Integer.parseInt(XMLUtil.getCdata(node).trim());
            }
        }
    }

    static {
        cvs_id = cvs_id;
    }
}

