/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.resource.report;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class ReportClass
implements Serializable {
    private String className;
    private String key;
    private ReportClass parent;
    private List children;
    private Properties prop;
    private String description;

    public ReportClass() {
    }

    public ReportClass(String className, String key) {
        this.setClassName(className);
        this.setKey(key);
    }

    public ReportClass(String className) {
        this.setClassName(className);
    }

    public ReportClass newSubInstance() {
        ReportClass rc = new ReportClass();
        this.addChild(rc);
        return rc;
    }

    public ReportClass newSubInstance(String inClassName) {
        ReportClass rc = new ReportClass(inClassName);
        this.addChild(rc);
        return rc;
    }

    public ReportClass newSubInstance(String inClassName, String inKey) {
        ReportClass rc = new ReportClass(inClassName, inKey);
        this.addChild(rc);
        return rc;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ReportClass getParent() {
        return this.parent;
    }

    public void setParent(ReportClass parent) {
        this.parent = parent;
    }

    public Collection getChildren() {
        return this.children;
    }

    public Collection getPeers() {
        if (this.parent != null) {
            return this.parent.getChildren();
        }
        return null;
    }

    public int getNumChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public ReportClass findChild(String className, String propName, String propValue) {
        if (className == null || propName == null || propValue == null) {
            return null;
        }
        if (className.equals(this.className) && propValue.equals(this.getProperty(propName))) {
            return this;
        }
        if (this.children != null) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                ReportClass rc = (ReportClass)iter.next();
                ReportClass fc = rc.findChild(className, propName, propValue);
                if (fc == null) continue;
                return fc;
            }
        }
        return null;
    }

    public void replace(ReportClass newrc, String className, String propName, String propValue) {
        if (this.children != null) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                ReportClass rc = (ReportClass)iter.next();
                if (className.equals(rc.getClassName()) && propValue.equals(rc.getProperty(propName))) {
                    this.children.remove(rc);
                    if (newrc != null) {
                        this.children.add(newrc);
                    }
                    return;
                }
                rc.replace(newrc, className, propName, propValue);
            }
        }
    }

    public void addChild(ReportClass child) {
        if (child != null) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            child.setParent(this);
            this.children.add(child);
        }
    }

    public Properties getProp() {
        return this.prop;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    public void setProperty(String name, String value) {
        if (name == null || value == null || value.length() == 0) {
            return;
        }
        if (this.prop == null) {
            this.prop = new Properties();
        }
        this.prop.setProperty(name, value);
    }

    public void clearProperty(String name) {
        if (this.prop != null) {
            this.prop.remove(name);
        }
    }

    public void setStringProperty(String name, String value) {
        this.setStringProperty(name, value, "null");
    }

    public void setStringProperty(String name, String value, String defaultValue) {
        if (value == null || value.length() == 0) {
            value = defaultValue;
        }
        this.setProperty(name, value);
    }

    public void setIntProperty(String name, String value) {
        if (value == null) {
            value = "0";
        } else {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                value = "0";
            }
        }
        this.setProperty(name, value);
    }

    public void setFloatProperty(String name, String value) {
        if (value == null) {
            value = "0.0";
        } else {
            try {
                Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                value = "0.0";
            }
        }
        this.setProperty(name, value);
    }

    public String getProperty(String name) {
        if (this.prop == null) {
            return null;
        }
        return this.prop.getProperty(name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void toTab(OutputStream out) {
        this.toLine(new PrintWriter(out), "\t", "", new ClassMap());
    }

    public void toProperties(OutputStream out) {
        this.toLine(new PrintWriter(out), "=", "", new ClassMap());
    }

    public void toLine(PrintWriter out, String sep, String root, ClassMap cmap) {
        Iterator iter;
        Collection cc;
        String rkey;
        out.flush();
        root = root == null || "".equals(root) || "system.".equals(root) ? this.className + "." : root + this.className + ".";
        String ckey = cmap.getKey(root, this.key);
        if (ckey != null) {
            root = root + ckey + ".";
        }
        if ((rkey = this.getKey()) == null) {
            rkey = ckey;
        }
        if (rkey != null) {
            out.write(root);
            out.write("_Key");
            out.write(sep);
            out.write(rkey);
            out.write("\n");
        }
        if (this.prop != null) {
            TreeMap<Object, Object> t = new TreeMap<Object, Object>(this.prop);
            Set<Map.Entry<Object, Object>> s = t.entrySet();
            Iterator<Map.Entry<Object, Object>> iter2 = s.iterator();
            while (iter2.hasNext()) {
                Map.Entry<Object, Object> entry = iter2.next();
                Object name = entry.getKey();
                Object value = entry.getValue();
                out.write(root);
                out.write(name.toString());
                out.write(sep);
                out.write(value.toString());
                out.write("\n");
            }
        }
        if ((cc = this.getChildren()) != null && (iter = cc.iterator()) != null && iter.hasNext()) {
            while (iter.hasNext()) {
                ((ReportClass)iter.next()).toLine(out, sep, root, cmap);
            }
        }
        if ("system.".equals(root)) {
            HashMap hmap = cmap.getClassMap();
            Set cset = hmap.keySet();
            Iterator siter = cset.iterator();
            while (siter.hasNext()) {
                String cname = (String)siter.next();
                HashMap imap = (HashMap)hmap.get(cname);
                out.write(cname);
                out.write("count");
                out.write(sep);
                out.write(Integer.toString(imap.size()));
                out.write("\n");
            }
        }
        out.flush();
    }

    public void toXML(OutputStream out) {
        this.toXML(out, "");
    }

    public void toXML(OutputStream out, String pre) {
        PrintWriter pw = new PrintWriter(out);
        this.toXML(pw, pre);
    }

    public void toXML(PrintWriter out) {
        this.toXML(out, null);
    }

    public void toXML(PrintWriter out, String pre) {
        if (pre == null) {
            this.toXML(out, null, "");
        } else {
            this.toXML(out, "", pre);
        }
    }

    public void toXML(PrintWriter out, String pre, String orig) {
        Collection cc;
        Iterator<Object> iter;
        String nextpre = null;
        if (pre != null) {
            nextpre = pre + orig;
            out.write(pre);
        }
        String xmlTag = this.className != null ? this.className : "component";
        out.write("<");
        out.write(xmlTag);
        if (this.key != null) {
            out.write(" key='");
            out.write(this.key);
            out.write("'");
        }
        out.write(">\n");
        if (this.prop != null) {
            TreeMap<Object, Object> t = new TreeMap<Object, Object>(this.prop);
            Set<Map.Entry<Object, Object>> s = t.entrySet();
            iter = s.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (nextpre != null) {
                    out.write(nextpre);
                }
                out.write("<");
                out.write(key.toString());
                out.write(">");
                out.write(this.encodetoXML(value.toString()));
                out.write("</");
                out.write(key.toString());
                out.write(">\n");
            }
        }
        if ((cc = this.getChildren()) != null && (iter = cc.iterator()) != null && iter.hasNext()) {
            while (iter.hasNext()) {
                ((ReportClass)iter.next()).toXML(out, nextpre, orig);
            }
        }
        if (pre != null) {
            out.write(pre);
        }
        out.write("</");
        out.write(xmlTag);
        out.write(">\n");
        out.flush();
    }

    public String toXML() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.toXML(pw);
        return sw.toString();
    }

    public String toXML(String pre) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.toXML(pw, pre);
        return sw.toString();
    }

    public String encodetoXML(String in) {
        int len = in.length();
        StringBuffer sb = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char ch = in.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String[] toNameValueList() {
        LinkedList list = new LinkedList();
        this.addStringArray(list, "", new ClassMap());
        String[] retval = new String[list.size()];
        list.toArray(retval);
        return retval;
    }

    public void addStringArray(List out, String root, ClassMap cmap) {
        Iterator iter;
        Collection cc;
        String ckey = cmap.getKey(root = root == null || "".equals(root) || "system.".equals(root) ? this.className + "." : root + this.className + ".", this.key);
        if (ckey != null) {
            root = root + ckey + ".";
        }
        if (this.prop != null) {
            TreeMap<Object, Object> t = new TreeMap<Object, Object>(this.prop);
            Set<Map.Entry<Object, Object>> s = t.entrySet();
            Iterator<Map.Entry<Object, Object>> iter2 = s.iterator();
            while (iter2.hasNext()) {
                Map.Entry<Object, Object> entry = iter2.next();
                Object name = entry.getKey();
                Object value = entry.getValue();
                out.add(root + name.toString());
                out.add(value.toString());
            }
        }
        if ((cc = this.getChildren()) != null && (iter = cc.iterator()) != null && iter.hasNext()) {
            while (iter.hasNext()) {
                ((ReportClass)iter.next()).addStringArray(out, root, cmap);
            }
        }
        if ("system.".equals(root)) {
            HashMap hmap = cmap.getClassMap();
            Set cset = hmap.keySet();
            Iterator siter = cset.iterator();
            while (siter.hasNext()) {
                String cname = (String)siter.next();
                HashMap imap = (HashMap)hmap.get(cname);
                out.add(cname + "count");
                out.add(Integer.toString(imap.size()));
                Iterator kiter = imap.keySet().iterator();
                while (kiter.hasNext()) {
                    String kname = (String)kiter.next();
                    String kval = (String)imap.get(kname);
                    out.add(cname + kval + "._name");
                    out.add(kname);
                }
            }
        }
    }

    public static void main(String[] args) {
        ReportClass rc = new ReportClass("system", "local");
        rc.setProperty("a", "b");
        ReportClass unit = rc.newSubInstance("unit", "a");
        unit.setProperty("c", "d");
        unit = rc.newSubInstance("unit", "b");
        unit.setProperty("c", "d");
        ReportClass dev = unit.newSubInstance("dev", "1");
        dev.setProperty("e", "f");
        rc.toProperties(System.out);
        rc.toXML(System.out, "\t");
    }

    private static class ClassMap {
        HashMap map = new HashMap();

        public String getKey(String cname, String key) {
            String ckey;
            if (cname == null || key == null) {
                return null;
            }
            if ("system.".equals(cname)) {
                return null;
            }
            HashMap<String, String> kmap = (HashMap<String, String>)this.map.get(cname);
            if (kmap == null) {
                kmap = new HashMap<String, String>();
                this.map.put(cname, kmap);
            }
            if ((ckey = (String)kmap.get(key)) == null) {
                ckey = Integer.toString(kmap.size() + 1);
                kmap.put(key, ckey);
            }
            return ckey;
        }

        public HashMap getClassMap() {
            return this.map;
        }
    }
}

