/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.resource.diags;

import com.sun.netstorage.fm.storade.resource.diags.TestParameter;
import com.sun.netstorage.fm.util.LocalizedString;

public class TestProperties {
    private String deviceType;
    private String componentType;
    private String className;
    private LocalizedString warning;
    private LocalizedString description;
    private LocalizedString title;
    private boolean abortable;
    private boolean validate;
    private TestParameter[] testParameters;
    public final String _SOURCE_REVISION = "$Revision: 1.5 $";

    public TestProperties(String className, String deviceType, String componentType) {
        this.className = className;
        this.deviceType = deviceType;
        this.componentType = componentType;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public LocalizedString getWarning() {
        return this.warning;
    }

    public void setWarning(LocalizedString warning) {
        this.warning = warning;
    }

    public LocalizedString getDescription() {
        return this.description;
    }

    public void setDescription(LocalizedString description) {
        this.description = description;
    }

    public LocalizedString getTitle() {
        return this.title;
    }

    public void setTitle(LocalizedString title) {
        this.title = title;
    }

    public boolean isAbortable() {
        return this.abortable;
    }

    public void setAbortable(boolean abortable) {
        this.abortable = abortable;
    }

    public boolean canValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public TestParameter[] getTestParameters() {
        return this.testParameters;
    }

    public void setTestParameters(TestParameter[] testParameters) {
        this.testParameters = testParameters;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<DIAG_TEST>\n");
        sb.append("<TEST_INFO>\n");
        sb.append(this.value("devType", this.deviceType));
        sb.append(this.value("node", this.componentType));
        sb.append(this.value("sectionName", this.className));
        if (this.title != null) {
            sb.append(this.value("name", this.title.getMessage()));
            sb.append(this.value("title", this.title.getMessage()));
        } else {
            sb.append(this.value("name", "Title not specified"));
        }
        if (this.description != null) {
            sb.append(this.value("description", this.description.getMessage()));
        }
        if (this.warning != null) {
            sb.append(this.value("warning", this.warning.getMessage()));
        }
        if (this.validate) {
            sb.append(this.value("validation_module", "JTest"));
        }
        sb.append("</TEST_INFO>\n");
        if (this.testParameters != null) {
            int i = 0;
            while (i < this.testParameters.length) {
                sb.append(this.testParameters[i]);
                sb.append("\n");
                ++i;
            }
        }
        sb.append("</DIAG_TEST>\n");
        return sb.toString();
    }

    private String value(String name, String value) {
        return " <VALUE ID='" + name + "'>" + value + "</VALUE>\n";
    }
}

