/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.eventlog;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.device.storage.treefrog.eventlog.DecodeMEL;
import com.sun.netstorage.fm.storade.resource.message.LogMessage;
import com.sun.netstorage.fm.storade.resource.message.MessageList;
import com.sun.netstorage.fm.storade.resource.message.MessageProvider;
import devmgr.versioned.symbol.ComponentLocation;
import devmgr.versioned.symbol.EventCategory;
import devmgr.versioned.symbol.MelEntry;
import devmgr.versioned.symbol.MelEntryList;
import devmgr.versioned.symbol.MelExtent;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventLog
implements MessageProvider {
    private static final long MAX_ENTRIES = 8191L;
    private long lastEntry;
    private String array;
    static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageList getNewMessages(String marker, Properties props) {
        SYMbolAPIClientV1 client = null;
        LogMessage[] msgArray = new LogMessage[]{};
        try {
            try {
                long index;
                client = SYMbolConnection.getOpenConnection(props);
                this.array = props.getProperty("ip");
                this.lastEntry = index = this.convertMarker(marker);
                MelEntry[] melEntries = this.getMELEntries(client, index);
                msgArray = this.createMessageArray(melEntries, props);
            }
            catch (Exception e) {
                Object var9_10 = null;
                SYMbolConnection.closeClient(client);
                return new MessageList(msgArray, Long.toString(this.lastEntry));
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SYMbolConnection.closeClient(client);
            throw throwable;
        }
        SYMbolConnection.closeClient(client);
        return new MessageList(msgArray, Long.toString(this.lastEntry));
    }

    public MessageList getAllMessages(Properties device) {
        return this.getNewMessages("0", device);
    }

    public void clearMessages(Properties device) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCurrentMarker(Properties props) {
        SYMbolAPIClientV1 client = null;
        String marker = "0";
        try {
            try {
                client = SYMbolConnection.getOpenConnection(props);
                MelExtent melIndex = client.getMelExtent();
                long index = melIndex.getEndingSeqNum();
                try {
                    marker = Long.toString(index);
                }
                catch (Exception e) {
                }
                Object var9_8 = null;
            }
            catch (Exception e) {
                Object var9_9 = null;
                SYMbolConnection.closeClient(client);
                return marker;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            SYMbolConnection.closeClient(client);
            throw throwable;
        }
        SYMbolConnection.closeClient(client);
        return marker;
    }

    public MelEntry[] getMELEntries(SYMbolAPIClientV1 client, long last) {
        ArrayList<MelEntry> allEntries = new ArrayList<MelEntry>();
        MelEntry[] melEntries = new MelEntry[]{};
        try {
            MelEntry[] events;
            MelExtent melIndex = client.getMelExtent();
            long start = melIndex.getStartingSeqNum();
            long end = melIndex.getEndingSeqNum();
            if (last < 0L) {
                start = end;
            } else if (last > end) {
                start = 0L;
            } else if (last > start) {
                start = last;
            }
            if (end - start > 8191L) {
                start = end - 8191L;
            }
            long totalRead = 0L;
            for (long totalRemaining = end - start; totalRemaining > 0L; totalRemaining -= (long)events.length) {
                long currentReadStart = start + totalRead;
                melIndex.setStartingSeqNum(currentReadStart);
                long currentReadEnd = end;
                if (totalRemaining > 64L) {
                    currentReadEnd = currentReadStart + 64L - 1L;
                }
                melIndex.setEndingSeqNum(currentReadEnd);
                MelEntryList melList = client.getMelEntries(melIndex);
                events = melList.getEvents();
                int x = 0;
                while (x < events.length) {
                    allEntries.add(events[x]);
                    ++x;
                }
                totalRead += (long)events.length;
                if (events.length != 0) continue;
                Level level = Level.parse(Level.FINE.toString());
                logger.setLevel(level);
                if (!logger.isLoggable(Level.FINE)) break;
                logger.fine("Unable to read MEL entries from " + this.array + " ...Skipping\n" + "The attempt was to read from entry " + start + " to entry " + end + "\nNo error is returned from SYMbol in this case.");
                break;
            }
            this.lastEntry = end;
        }
        catch (Exception e) {
            // empty catch block
        }
        melEntries = new MelEntry[allEntries.size()];
        allEntries.toArray(melEntries);
        return melEntries;
    }

    private LogMessage[] createMessageArray(MelEntry[] entries, Properties props) {
        HashMap targetEvents = DecodeMEL.getTargetMap();
        ArrayList<LogMessage> messages = new ArrayList<LogMessage>();
        try {
            int x = 0;
            while (x < entries.length) {
                MelEntry event = entries[x];
                int eventCode = event.getEventType();
                if (targetEvents.containsKey(new Integer(eventCode))) {
                    int priority = event.getPriority().getValue();
                    int type = event.getComponentType().getValue();
                    String typeName = DecodeMEL.getTypeName(type);
                    String date = Utility.convertDate(event.getTimeStamp());
                    String location = "";
                    if (event.getLocationValid()) {
                        ComponentLocation componentLoc = event.getComponentLocation();
                        location = DecodeMEL.getComponentLocation(type, componentLoc) + ",";
                    }
                    String ced = (String)targetEvents.get(new Integer(eventCode));
                    String description = location + " " + ced;
                    String errorCode = "0x" + Integer.toHexString(eventCode).toUpperCase();
                    int severity = this.deriveSeverity(priority, event.getCategory());
                    LogMessage msg = new LogMessage(errorCode, severity, props.getProperty("key"), typeName, Utility.getDate(event.getTimeStamp()), description);
                    messages.add(msg);
                }
                ++x;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        LogMessage[] logMessages = new LogMessage[messages.size()];
        messages.toArray(logMessages);
        return logMessages;
    }

    private int deriveSeverity(int priority, EventCategory category) {
        int severity;
        if (priority == 1) {
            return 5;
        }
        switch (category.getValue()) {
            case 3: {
                severity = 4;
                break;
            }
            case 1: {
                severity = 3;
                break;
            }
            case 2: {
                severity = 3;
                break;
            }
            case 7: {
                severity = 4;
                break;
            }
            case 6: {
                severity = 5;
                break;
            }
            case 4: {
                severity = 5;
                break;
            }
            case 5: {
                severity = 4;
                break;
            }
            default: {
                severity = 5;
            }
        }
        return severity;
    }

    private long convertMarker(String marker) {
        long position = -1L;
        try {
            position = Long.parseLong(marker);
        }
        catch (Exception e) {
            // empty catch block
        }
        return position;
    }

    static {
        MAX_ENTRIES = 8191L;
        logger = Logger.getLogger("com.sun.netstorage.fm.storade.device.storage.treefrog.eventlog");
    }
}

