/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.diags;

import com.sun.netstorage.fm.storade.client.SAClient;
import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.device.storage.treefrog.diags.DiagSetup;
import com.sun.netstorage.fm.storade.resource.diags.DiagnosticResult;
import com.sun.netstorage.fm.storade.resource.diags.DiagnosticSetting;
import com.sun.netstorage.fm.storade.service.device.DeviceMaintenanceService;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import com.sun.netstorage.fm.util.LocalizedString;
import devmgr.versioned.symbol.ControllerDescriptor;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.RuntimeDiagDescriptor;
import devmgr.versioned.symbol.RuntimeDiagResults;
import devmgr.versioned.symbol.RuntimeDiagTestID;
import devmgr.versioned.symbol.RuntimeDiagTestResults;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.util.Properties;

public class DiagUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void executeTest(DiagnosticSetting settings, DiagnosticResult diagResult, int testType) {
        SYMbolAPIClientV1 client2;
        SYMbolAPIClientV1 client1;
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            client1 = null;
                            client2 = null;
                            try {
                                try {
                                    Properties p = settings.getDeviceProperties();
                                    if (p == null) {
                                        diagResult.setState(5);
                                        diagResult.setSynopsis(new LocalizedString("Could not get device properties. key = " + settings.getDeviceId()));
                                        Object var12_7 = null;
                                        break block12;
                                    }
                                    String ip = p.getProperty("ipno");
                                    String altip = p.getProperty("altipno");
                                    client1 = SYMbolConnection.getOpenConnection(ip);
                                    client2 = SYMbolConnection.getOpenConnection(altip);
                                    if (client1 == null) {
                                        diagResult.setState(5);
                                        diagResult.setSynopsis(new LocalizedString("Unable to open a connection to " + ip + "\n" + "Both controllers must be online to run internal diagnostics"));
                                        break block13;
                                    }
                                    if (client2 == null) {
                                        diagResult.setState(5);
                                        diagResult.setSynopsis(new LocalizedString("Unable to open a connection to " + altip + "\n" + "Both controllers must be online to run internal diagnostics"));
                                        SYMbolConnection.closeClient(client1);
                                        break block14;
                                    }
                                    DiagSetup setup = new DiagSetup(client1, client2, settings.getOptions());
                                    if (!setup.isRunnable()) {
                                        diagResult.setState(5);
                                        diagResult.setSynopsis(new LocalizedString(setup.getStatusReason()));
                                        SYMbolConnection.closeClient(client1);
                                        SYMbolConnection.closeClient(client2);
                                        break block15;
                                    }
                                    String password = settings.getOptions().getProperty("password_choice");
                                    if (password == null) {
                                        password = "";
                                    }
                                    if (setup.isRunnable()) {
                                        RuntimeDiagDescriptor rdd = DiagUtility.createDiagDescriptor(settings.getOptions(), setup, testType);
                                        DiagUtility.runDiag(rdd, diagResult, setup, password);
                                        break block16;
                                    } else {
                                        diagResult.setState(5);
                                        diagResult.setSynopsis(new LocalizedString(setup.getStatusReason()));
                                    }
                                    break block16;
                                }
                                catch (Exception e) {
                                    Object var12_12 = null;
                                    SYMbolConnection.closeClient(client1);
                                    SYMbolConnection.closeClient(client2);
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var12_13 = null;
                                SYMbolConnection.closeClient(client1);
                                SYMbolConnection.closeClient(client2);
                                throw throwable;
                            }
                        }
                        SYMbolConnection.closeClient(client1);
                        SYMbolConnection.closeClient(client2);
                        return;
                    }
                    Object var12_8 = null;
                    SYMbolConnection.closeClient(client1);
                    SYMbolConnection.closeClient(client2);
                    return;
                }
                Object var12_9 = null;
                SYMbolConnection.closeClient(client1);
                SYMbolConnection.closeClient(client2);
                return;
            }
            Object var12_10 = null;
            SYMbolConnection.closeClient(client1);
            SYMbolConnection.closeClient(client2);
            return;
        }
        Object var12_11 = null;
        SYMbolConnection.closeClient(client1);
        SYMbolConnection.closeClient(client2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runDiag(RuntimeDiagDescriptor rdd, DiagnosticResult diagResult, DiagSetup setup, String password) {
        SYMbolAPIClientV1 targetClient = setup.getTargetClient();
        SYMbolAPIClientV1 primaryClient = setup.getPrimaryClient();
        try {
            boolean callException;
            RuntimeDiagResults results;
            block12: {
                Utility.setClientPassword(password, targetClient);
                diagResult.setState(1);
                String qval = DiagUtility.quiesceController(targetClient, setup.getTargetRef());
                results = null;
                callException = false;
                try {
                    Object var11_10;
                    try {
                        Utility.setClientPassword(password, primaryClient);
                        results = primaryClient.issueRuntimeDiagnostics(rdd);
                    }
                    catch (Exception ex) {
                        callException = true;
                        diagResult.setState(5);
                        diagResult.setSynopsis(new LocalizedString("Exception while issuing the test: " + ex.toString()));
                        var11_10 = null;
                        Utility.setClientPassword(password, targetClient);
                        qval = DiagUtility.unquiesceController(targetClient, setup.getTargetRef());
                        break block12;
                    }
                    var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    Utility.setClientPassword(password, targetClient);
                    qval = DiagUtility.unquiesceController(targetClient, setup.getTargetRef());
                    throw throwable;
                }
                Utility.setClientPassword(password, targetClient);
                qval = DiagUtility.unquiesceController(targetClient, setup.getTargetRef());
            }
            if (results == null) {
                if (callException) return;
                diagResult.setState(5);
                diagResult.setSynopsis(new LocalizedString("Issue diag call returned null"));
                return;
            }
            if (results.getReturnCode().getValue() != 1) {
                diagResult.setState(5);
                diagResult.setSynopsis(new LocalizedString("Error running diag, RC = " + Translator.translateReturnCode(results.getReturnCode())));
                return;
            }
            StringBuffer resultBuffer = new StringBuffer();
            int runStatus = 0;
            RuntimeDiagTestResults[] allResults = results.getTestResults();
            int x = 0;
            while (true) {
                if (x >= allResults.length) {
                    diagResult.setState(runStatus);
                    diagResult.setSynopsis(new LocalizedString("Test Completed"));
                    diagResult.setOutput(resultBuffer);
                    return;
                }
                if (allResults[x].getTestStatus().getValue() != -1) {
                    resultBuffer.append("Test ID " + Translator.translateTestID(allResults[x].getTestID()));
                    resultBuffer.append(" channel " + allResults[x].getChannel());
                    resultBuffer.append(" Test level " + Translator.translateTestLevel(allResults[x].getTestLevel()));
                    resultBuffer.append(" Test status " + Translator.translateTestStatus(allResults[x].getTestStatus()));
                    resultBuffer.append("\n");
                    if (allResults[x].getTestStatus().getValue() == 1) {
                        runStatus = 4;
                    }
                }
                ++x;
            }
        }
        catch (Exception e) {
            diagResult.setState(5);
            diagResult.setSynopsis(new LocalizedString("Exception while running the test"));
            diagResult.setOutput(new StringBuffer(e.toString()));
        }
    }

    public static RuntimeDiagDescriptor createDiagDescriptor(Properties props, DiagSetup setup, int testID) {
        RuntimeDiagDescriptor descriptor = new RuntimeDiagDescriptor();
        try {
            switch (testID) {
                case 1: {
                    descriptor.setUsePattern(false);
                    break;
                }
                case 3: {
                    descriptor.setUsePattern(false);
                    break;
                }
                case 2: {
                    descriptor.setUsePattern(true);
                    break;
                }
                case 0: {
                    descriptor.setUsePattern(true);
                    break;
                }
                default: {
                    testID = 1;
                    descriptor.setUsePattern(false);
                }
            }
            if (descriptor.getUsePattern()) {
                String channelStr = props.getProperty("channel_choice");
                int channelID = 1;
                try {
                    channelID = Integer.parseInt(channelStr);
                }
                catch (NumberFormatException nfe) {
                    channelID = 1;
                }
                descriptor.setChannel(channelID);
                String patternStr = props.getProperty("pattern_choice");
                byte[] selection = patternStr.getBytes();
                byte[] pattern = new byte[64];
                int y = 0;
                int x = 0;
                while (x < pattern.length) {
                    if (y >= selection.length) {
                        y = 0;
                    }
                    pattern[x] = selection[y];
                    ++y;
                    ++x;
                }
                descriptor.setPattern(pattern);
            } else {
                descriptor.setChannel(1);
                descriptor.setPattern(new byte[64]);
            }
            RuntimeDiagTestID rttid = new RuntimeDiagTestID(testID);
            descriptor.setRuntimeDiagTestID(rttid);
            descriptor.setControllerRef(setup.getTargetRef());
        }
        catch (Exception e) {
            // empty catch block
        }
        return descriptor;
    }

    public static Properties getDeviceProperties(String deviceKey) {
        Properties devProps = null;
        try {
            SAClient sa = new SAClient();
            DeviceMaintenanceService dms = sa.getDeviceMaintenanceService();
            DeviceProperties dp = dms.getDeviceProperties(deviceKey);
            devProps = dp.getProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return devProps;
    }

    public static boolean bindToController(SYMbolAPIClientV1 client, ControllerRef ref) {
        boolean bound = false;
        try {
            ObjectBundle bundle = client.getObjectGraph();
            SAIdentifier said = bundle.getSa().getSaData().getSaId();
            ControllerDescriptor descriptor = new ControllerDescriptor();
            descriptor.setControllerRef(ref);
            descriptor.setSaId(said);
            ReturnCode rc = client.bindToController(descriptor);
            if (rc.getValue() == 1) {
                bound = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bound;
    }

    private static String quiesceController(SYMbolAPIClientV1 client, ControllerRef ref) {
        String rval = "No quiesce status";
        try {
            ReturnCode rcode = client.quiesceController(ref);
            rval = "Quiesce status: " + Translator.translateReturnCode(rcode);
        }
        catch (Exception e) {
            rval = "Error quiescing controller: " + e.toString();
        }
        return rval;
    }

    private static String unquiesceController(SYMbolAPIClientV1 client, ControllerRef ref) {
        String rval = "No quiesce status";
        try {
            ReturnCode rcode = client.unquiesceController(ref);
            rval = "Unquiesce status: " + Translator.translateReturnCode(rcode);
        }
        catch (Exception e) {
            rval = "Error unquiescing controller: " + e.toString();
        }
        return rval;
    }
}

