/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.common;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.ManagementPath;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class SYMbolClient {
    private static int MAX_RETRIES = 3;
    private ManagementPath[] m_PathList;
    private ManagementPath m_SelectedPath;
    private boolean m_VerboseMode = false;
    private SYMbolAPIClientV1 m_RawClient;

    public SYMbolClient(ManagementPath[] paths) {
        this.m_PathList = paths;
    }

    public SYMbolClient(ManagementPath path) {
        this.m_PathList = new ManagementPath[1];
        this.m_PathList[0] = path;
    }

    public boolean connect() {
        ManagementPath thePath = null;
        this.m_RawClient = null;
        int p = 0;
        while (p < this.m_PathList.length && this.m_RawClient == null) {
            block7: {
                thePath = this.m_PathList[p];
                try {
                    ReturnCode rc;
                    if (this.m_VerboseMode) {
                        Utility.showInfo("Connecting to " + thePath.getIPAddress().toString());
                    }
                    this.m_RawClient = new SYMbolAPIClientV1(thePath.getIPAddress(), 2463, true);
                    if (this.m_VerboseMode) {
                        Utility.showInfo("Attempting to bind to controller...");
                    }
                    if ((rc = this.m_RawClient.bindToController(thePath.getControllerDescriptor())).getValue() != 1) {
                        throw new Exception("bindToController failed");
                    }
                }
                catch (Exception ex) {
                    if (this.m_RawClient != null) {
                        this.close();
                    }
                    if (!this.m_VerboseMode) break block7;
                    System.out.println(this.getClass().getName() + ": " + "Unable to connect to controller at " + thePath.getIPAddress().toString() + "; ");
                    ex.printStackTrace();
                }
            }
            ++p;
        }
        this.m_SelectedPath = thePath;
        return this.m_RawClient != null;
    }

    public boolean connectToOtherController() {
        ManagementPath altPath;
        block9: {
            altPath = null;
            this.m_RawClient = null;
            int i = 0;
            while (i < this.m_PathList.length) {
                altPath = this.m_PathList[i];
                if (!Utility.rawCompare(altPath.getControllerDescriptor().getControllerRef().getRefToken(), this.m_SelectedPath.getControllerDescriptor().getControllerRef().getRefToken())) break;
                ++i;
            }
            if (altPath != null) {
                try {
                    ReturnCode returnCode;
                    if (this.m_VerboseMode) {
                        Utility.showInfo("Connecting to " + altPath.getIPAddress().toString());
                    }
                    this.m_RawClient = new SYMbolAPIClientV1(altPath.getIPAddress(), 2463, true);
                    if (this.m_VerboseMode) {
                        Utility.showInfo("Attempting to bind to controller...");
                    }
                    if ((returnCode = this.m_RawClient.bindToController(altPath.getControllerDescriptor())).getValue() != 1) {
                        throw new Exception("bindToController failed");
                    }
                    break block9;
                }
                catch (Exception ex) {
                    if (this.m_RawClient != null) {
                        this.close();
                    }
                    if (this.m_VerboseMode) {
                        System.out.println(this.getClass().getName() + ": " + "Unable to connect to controller at " + altPath.getIPAddress().toString() + "; ");
                        ex.printStackTrace();
                    }
                    break block9;
                }
            }
            System.out.println("Error connecting to alternate controller.");
        }
        this.m_SelectedPath = altPath;
        return this.m_RawClient != null;
    }

    public void setVerboseMode(boolean mode) {
        this.m_VerboseMode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.m_RawClient != null) {
            try {
                try {
                    this.m_RawClient.close();
                }
                catch (Exception ex) {
                    Object var3_2 = null;
                    this.m_RawClient = null;
                }
                Object var3_1 = null;
                this.m_RawClient = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.m_RawClient = null;
                throw throwable;
            }
        }
    }

    public SYMbolAPIClientV1 getRawClient() {
        return this.m_RawClient;
    }

    public ManagementPath getSelectedPath() {
        return this.m_SelectedPath;
    }

    public int getPathCount() {
        return this.m_PathList.length;
    }

    /*
     * Unable to fully structure code
     */
    public void issueCommand(int procedureNumber, XDRType argument, XDRType result) throws RPCError, IOException {
        retryCount = 0;
        if (this.m_RawClient != null) ** GOTO lbl15
        System.out.println("Internal error. No connection to the storage array.");
        throw new RPCError("SYSTEM_ERROR");
lbl-1000:
        // 1 sources

        {
            ++retryCount;
            try {
                this.m_RawClient.call(procedureNumber, argument, result);
                return;
            }
            catch (RPCError rpcError) {
                if (retryCount != SYMbolClient.MAX_RETRIES) continue;
                throw rpcError;
            }
            catch (IOException ioe) {
                if (retryCount != SYMbolClient.MAX_RETRIES) continue;
                throw ioe;
            }
lbl15:
            // 3 sources

            ** while (retryCount < SYMbolClient.MAX_RETRIES)
        }
lbl16:
        // 1 sources

    }

    public void issueCommand(int procedureNumber, XDRType argument, ReturnCode returnCode) throws RPCError, IOException {
        int retryCount = 0;
        boolean alternateTried = false;
        boolean passwordEntryTried = false;
        String password = "";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (retryCount < MAX_RETRIES) {
            block14: {
                ++retryCount;
                try {
                    Utility.setClientPassword(password, this.m_RawClient);
                    this.issueCommand(procedureNumber, argument, (XDRType)returnCode);
                }
                catch (RPCError rpcError) {
                    if (retryCount != MAX_RETRIES) continue;
                    throw rpcError;
                }
                catch (IOException ioe) {
                    if (retryCount != MAX_RETRIES) break block14;
                    throw ioe;
                }
            }
            switch (returnCode.getValue()) {
                case 1: 
                case 14: {
                    return;
                }
                case 3: 
                case 29: {
                    break;
                }
                case 13: {
                    if (!alternateTried && this.connectToOtherController()) {
                        alternateTried = true;
                        retryCount = 0;
                        break;
                    }
                    System.out.println("Unable to connect to the other controller to complete the command.");
                    return;
                }
                case 30: {
                    if (procedureNumber != 56 && !passwordEntryTried) {
                        System.out.print("The current storage array password must be validated to process this procedure.\nPlease enter the current password: ");
                        password = bufferedReader.readLine();
                        passwordEntryTried = true;
                        break;
                    }
                    return;
                }
                default: {
                    if (retryCount == MAX_RETRIES) {
                        System.out.println("   Storage Array returned error " + returnCode.getValue() + " processing procedure " + procedureNumber);
                    }
                    return;
                }
            }
        }
        if (retryCount == MAX_RETRIES) {
            System.out.println("   Retried procedure " + procedureNumber + " " + MAX_RETRIES + " times, but the Storage Array returned error code " + returnCode.getValue());
            return;
        }
    }
}

