/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.AbstractVolRefList;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumePerformance;
import devmgr.versioned.symbol.VolumePerformanceList;

public class VolumeStatistics {
    static String getData(SYMbolAPIClientV1 client1, SYMbolAPIClientV1 client2) {
        StringBuffer data = new StringBuffer();
        data.append(VolumeStatistics.getVolumeStatistics(client1));
        data.append(VolumeStatistics.getVolumeStatistics(client2));
        return data.toString();
    }

    private static String getVolumeStatistics(SYMbolAPIClientV1 client) {
        StringBuffer data = new StringBuffer();
        try {
            Volume[] volumes = client.getObjectGraph().getVolume();
            AbstractVolRef[] volRefArray = new AbstractVolRef[volumes.length];
            int x = 0;
            while (x < volumes.length) {
                volRefArray[x] = volumes[x].getVolumeRef();
                ++x;
            }
            AbstractVolRefList refList = new AbstractVolRefList();
            refList.setAbstractVolRef(volRefArray);
            VolumePerformanceList perfList = client.getVolumePerformance(refList);
            VolumePerformance[] perfArray = perfList.getVolumePerf();
            String header = "volume, Time, Total Requests Serviced, Total Blocks Requested, Total Read Requests, Total Read Blocks Requested, Total Write Requests, Total Write Blocks Requested, Total Percent Read Requests, Total Average Blocks Requested, Total Large Reads, Total Large Read Blocks Requested, Total Large Writes, Total Large Write Blocks Requested, Total Cache Read Checks, Total Cache Read Check Hits, Total Cache Write Requests\n";
            data.append(header);
            int i = 0;
            while (i < perfArray.length) {
                String name = null;
                int y = 0;
                while (y < volumes.length) {
                    if (Utility.rawCompare(perfArray[i].getVolumeRef().getRefToken(), volumes[y].getVolumeRef().getRefToken())) {
                        name = Utility.userLabelString(volumes[y].getLabel());
                        break;
                    }
                    ++y;
                }
                if (name != null) {
                    data.append(name);
                } else {
                    data.append(Utility.bytesArrayString(perfArray[i].getVolumeRef().getRefToken()));
                }
                data.append(", ");
                data.append(Utility.convertDate(perfArray[i].getTime()));
                data.append(", ");
                data.append(perfArray[i].getTotalRequestsServiced());
                data.append(", ");
                data.append(perfArray[i].getTotalBlocksRequested());
                data.append(", ");
                data.append(perfArray[i].getTotalReadRequests());
                data.append(", ");
                data.append(perfArray[i].getTotalReadBlocksRequested());
                data.append(", ");
                data.append(perfArray[i].getTotalWriteRequests());
                data.append(", ");
                data.append(perfArray[i].getTotalWriteBlocksRequested());
                data.append(", ");
                data.append(perfArray[i].getPercentReadRequests());
                data.append(", ");
                data.append(perfArray[i].getAverageBlocksRequested());
                data.append(", ");
                data.append(perfArray[i].getTotalLargeReads());
                data.append(", ");
                data.append(perfArray[i].getTotalLargeReadBlocksRequested());
                data.append(", ");
                data.append(perfArray[i].getTotalLargeWrites());
                data.append(", ");
                data.append(perfArray[i].getTotalLargeWriteBlocksRequested());
                data.append(", ");
                data.append(perfArray[i].getTotalCacheReadChecks());
                data.append(", ");
                data.append(perfArray[i].getTotalCacheReadCheckHits());
                data.append(", ");
                data.append(perfArray[i].getTotalCacheWriteRequests());
                data.append("\n");
                ++i;
            }
        }
        catch (Exception e) {
            data.append(e.toString());
        }
        return data.toString();
    }
}

