/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.ComponentBundle;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.Esm;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.Tray;

public class Util {
    public static String createName(ObjectBundle bundle, DriveRef ref) {
        String name = null;
        byte[] target = ref.getRefToken();
        Drive[] drives = bundle.getDrive();
        int i = 0;
        while (i < drives.length) {
            byte[] current = drives[i].getDriveRef().getRefToken();
            if (Utility.rawCompare(target, current)) {
                Location location = drives[i].getPhysicalLocation();
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                name = physicalTray != null ? "Tray." + physicalTray.getTrayId() + ".Drive." + location.getSlot() : "Tray.<null>.Drive." + location.getSlot();
            }
            ++i;
        }
        return name;
    }

    public static String createShortName(ObjectBundle bundle, DriveRef ref) {
        String name = null;
        byte[] target = ref.getRefToken();
        Drive[] drives = bundle.getDrive();
        int i = 0;
        while (i < drives.length) {
            byte[] current = drives[i].getDriveRef().getRefToken();
            if (Utility.rawCompare(target, current)) {
                Location location = drives[i].getPhysicalLocation();
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                name = physicalTray != null ? "Tray." + physicalTray.getTrayId() + ".Drive." + location.getSlot() : "Drive [<null>," + location.getSlot() + "]";
            }
            ++i;
        }
        return name;
    }

    public static String createName(ObjectBundle bundle, ControllerRef ref) {
        String name = null;
        byte[] target = ref.getRefToken();
        Controller[] controllers = bundle.getController();
        int i = 0;
        while (i < controllers.length) {
            byte[] current = controllers[i].getControllerRef().getRefToken();
            if (Utility.rawCompare(target, current)) {
                Location location = controllers[i].getPhysicalLocation();
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                name = physicalTray != null ? "Tray." + physicalTray.getTrayId() + ".Controller." + location.getSlot() : "Tray.<null>.Controller." + location.getSlot();
            }
            ++i;
        }
        return name;
    }

    public static String createIOMName(ObjectBundle bundle, ComponentRef ref) {
        String name = null;
        byte[] target = ref.getRefToken();
        ComponentBundle compBundle = bundle.getComponentBundle();
        Esm[] ioms = compBundle.getEsm();
        int i = 0;
        while (i < ioms.length) {
            byte[] current = ioms[i].getEsmRef().getRefToken();
            if (Utility.rawCompare(target, current)) {
                Location location = ioms[i].getPhysicalLocation();
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                int tray = -1;
                if (physicalTray != null) {
                    tray = physicalTray.getTrayId();
                }
                int slot = location.getSlot();
                name = "Tray." + tray + ".IOM." + Translator.getSlotName(slot);
            }
            ++i;
        }
        return name;
    }
}

