/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.UnreadableSectorTableEntry;
import devmgr.versioned.symbol.UnreadableSectorTableInfo;

public class UnreadableSectors {
    static String getData(SYMbolAPIClientV1 client) {
        String data = UnreadableSectors.collectData(client);
        return data;
    }

    static String getData(SYMbolAPIClientV1 client1, SYMbolAPIClientV1 client2) {
        String data = "No unreadble sector data collected";
        if (client1 != null) {
            data = UnreadableSectors.collectData(client1);
        } else if (client2 != null) {
            data = UnreadableSectors.collectData(client2);
        }
        return data;
    }

    private static String collectData(SYMbolAPIClientV1 client) {
        StringBuffer data = new StringBuffer();
        try {
            UnreadableSectorTableInfo table = client.readUnreadableSectorDatabase();
            UnreadableSectorTableEntry[] entries = table.getDatabase();
            int maxEntries = table.getMaxLimit();
            data.append("Volume  Date/Time  Volume LBA  Drive Location  Drive LBA  Failure Type\n");
            int x = 0;
            while (x < entries.length) {
                data.append(Utility.hexString(entries[x].getVolumeRef().getRefToken()) + "\t");
                data.append(Utility.convertDate(entries[x].getTimeStamp()) + "\t");
                data.append(entries[x].getVolumeLBA() + "\t");
                data.append(entries[x].getTrayNo() + " ");
                data.append(entries[x].getSlotNo() + "\t");
                data.append(entries[x].getDriveLBA() + "\t");
                data.append(Translator.translateUsmRecordType(entries[x].getRecordType()) + "\n");
                ++x;
            }
        }
        catch (Exception e) {
            data.append("\nError accessing unreadable sector data\n" + e.toString());
        }
        return data.toString();
    }
}

