/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.ReturnCodeWithOpaqueData;
import devmgr.versioned.symbol.SYMbolAPIClientV1;

public class StateCapture {
    static String getData(SYMbolAPIClientV1 client, String password) {
        String data = StateCapture.collectData(client, password);
        return data;
    }

    static String getData(SYMbolAPIClientV1 client1, SYMbolAPIClientV1 client2, String password) {
        String data = "No state capture data collected";
        if (client1 != null) {
            data = StateCapture.collectData(client1, password);
        } else if (client2 != null) {
            data = StateCapture.collectData(client2, password);
        }
        return data;
    }

    private static String collectData(SYMbolAPIClientV1 client, String password) {
        StringBuffer data = new StringBuffer();
        try {
            data.append(StateCapture.performStateCapture(client, password));
        }
        catch (Exception e) {
            data.append("\nError accessing state capture\n" + e.toString());
        }
        return data.toString();
    }

    private static String performStateCapture(SYMbolAPIClientV1 client, String password) throws Exception {
        String[] commands = new String[]{"moduleList", "arrayPrintSummary", "cfgUnitList", "ghsList", "printBatteryAge", "cfgPhyList", "spmShowMaps", "spmShow", "getObjectGraph_MT,1", "getObjectGraph_MT,4", "getObjectGraph_MT,8", "ccmStateAnalyze,8", "fcDevs,1", "i", "dqflush", "dqprint,\"fd=1,tail=400\"", "dqprint,\"fc=hdd->rde,tail=200\"", "fc,111", "hdd,5", "fcAll,10", "showEnclosures", "showEnclosuresPage81", "vdShow,0"};
        StringBuffer data = new StringBuffer();
        Utility.setClientPassword(password, client);
        int x = 0;
        while (x < commands.length) {
            try {
                ReturnCodeWithOpaqueData rcwod = client.stateCapture(commands[x]);
                ReturnCode rc = rcwod.getReturnCode();
                if (rc.getValue() == 1) {
                    byte[] opaqueData = rcwod.getData();
                    String temp = new String(opaqueData);
                    data.append(temp + "\n");
                } else {
                    System.out.println("Accessing " + commands[x] + " ReturnCode = " + Translator.translateReturnCode(rc));
                }
            }
            catch (Exception e) {
                data.append("Exception while accessing " + commands[x]);
            }
            ++x;
        }
        return data.toString();
    }
}

