/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.Util;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.RLSCommand;
import devmgr.versioned.symbol.RLSCommandDescriptor;
import devmgr.versioned.symbol.RLSCount;
import devmgr.versioned.symbol.RLSData;
import devmgr.versioned.symbol.RLSDevice;
import devmgr.versioned.symbol.RLSResults;
import devmgr.versioned.symbol.SYMbolAPIClientV1;

public class ReadLinkStatus {
    static String getData(SYMbolAPIClientV1 client) {
        String data = ReadLinkStatus.collectData(client);
        return data;
    }

    static String getData(SYMbolAPIClientV1 client1, SYMbolAPIClientV1 client2) {
        String data = "No RLS data collected";
        if (client2 != null) {
            data = ReadLinkStatus.collectData(client2);
        } else if (client1 != null) {
            data = ReadLinkStatus.collectData(client1);
        }
        return data;
    }

    private static String collectData(SYMbolAPIClientV1 client) {
        StringBuffer data = new StringBuffer();
        try {
            ObjectBundle bundle = client.getObjectGraph();
            RLSCommand command = new RLSCommand(1);
            RLSCommandDescriptor rlsCommand = new RLSCommandDescriptor();
            rlsCommand.setCommand(command);
            RLSResults rlsResults = client.getReadLinkStatus(rlsCommand);
            data.append("\"Device\",\"Baseline Time\",\"ITW\",\"LF\",\"LOS\",\"LOSG\",\"PSP\",\"ICRC\"\n");
            RLSData[] controllers = rlsResults.getControllers();
            data.append(ReadLinkStatus.getRLSData(controllers, bundle));
            RLSData[] drives = rlsResults.getDrives();
            data.append(ReadLinkStatus.getRLSData(drives, bundle));
            RLSData[] esms = rlsResults.getEsms();
            data.append(ReadLinkStatus.getRLSData(esms, bundle));
        }
        catch (Exception e) {
            data.append("\nError accessing RLS data\n" + e.toString());
        }
        return data.toString();
    }

    private static String getRLSData(RLSData[] rlsData, ObjectBundle bundle) {
        StringBuffer data = new StringBuffer();
        int x = 0;
        while (x < rlsData.length) {
            RLSDevice device = rlsData[x].getDevice();
            int type = device.getType().getValue();
            String id = null;
            if (type == 1) {
                id = Util.createName(bundle, device.getController());
            } else if (type == 2) {
                id = Util.createShortName(bundle, device.getDrive());
            } else if (type == 3) {
                id = Util.createIOMName(bundle, device.getEsm());
            }
            data.append(id + ", ");
            data.append(Utility.convertDate(rlsData[x].getBaselineTime()) + ", ");
            RLSCount count = rlsData[x].getRlsCount();
            data.append(count.getInvalidXmitWord() + ", ");
            data.append(count.getLinkFailureCount() + ", ");
            data.append(count.getLossOfSyncCount() + ", ");
            data.append(count.getLossOfSignalCount() + ", ");
            data.append(count.getPrimSeqProtocolErr() + ", ");
            data.append(count.getInvalidCRCCount() + "\n");
            ++x;
        }
        return data.toString();
    }
}

