/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.diags.DiagUtility;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.NVSRAMRegion;
import devmgr.versioned.symbol.NVSRAMRegionId;
import devmgr.versioned.symbol.NVSRAMRegionList;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.SAData;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.StorageArray;

public class NVSRAMCollector {
    private static final String INDENT_1 = "\t";
    private static final String INDENT_2 = "\t  ";
    private static final String ONE_SPACE = " ";
    private static final String NEWLINE = "\n";

    static String getData(SYMbolAPIClientV1 client1, SYMbolAPIClientV1 client2) {
        StringBuffer data = new StringBuffer();
        data.append(NVSRAMCollector.createHeader(client1));
        data.append(NVSRAMCollector.getCurrentData(client1));
        data.append(NVSRAMCollector.getCurrentData(client2));
        return data.toString();
    }

    private static String getCurrentData(SYMbolAPIClientV1 client) {
        StringBuffer sb = new StringBuffer();
        int slot = 0;
        try {
            Controller[] controllers = client.getObjectGraph().getController();
            int i = 0;
            while (i < controllers.length) {
                if (DiagUtility.bindToController(client, controllers[i].getControllerRef())) {
                    slot = controllers[i].getPhysicalLocation().getSlot();
                }
                ++i;
            }
            sb.append("Controller in slot " + Translator.getSlotName(slot) + NEWLINE + NEWLINE);
            NVSRAMRegionId regionID = new NVSRAMRegionId(-1);
            NVSRAMRegionList regionList = client.getControllerNVSRAM(regionID);
            NVSRAMRegion[] regions = regionList.getNvsram();
            int x = 0;
            while (x < regions.length) {
                NVSRAMRegionId id = regions[x].getRegionId();
                sb.append("\tNVSRAM Region " + x + "   Region Id = (" + id.getValue() + ") " + Translator.translateRegionID(id));
                sb.append(NEWLINE);
                byte[] data = regions[x].getRegionData();
                sb.append(NVSRAMCollector.formatRegionData(data));
                sb.append("\n\n");
                ++x;
            }
        }
        catch (Exception e) {
            sb.append(e.toString());
        }
        return sb.toString();
    }

    private static String formatRegionData(byte[] data) {
        StringBuffer sbuf = new StringBuffer();
        StringBuffer abuf = new StringBuffer();
        sbuf.append(INDENT_2);
        int i = 0;
        while (i < data.length) {
            if (i == 0 || i % 16 == 0) {
                sbuf.append("\n\t  ");
                sbuf.append(NVSRAMCollector.toHex(i, 4) + ": ");
            }
            if (i > 0 && i % 2 == 0 && i % 16 > 0) {
                sbuf.append(ONE_SPACE);
            }
            sbuf.append(NVSRAMCollector.toHex(data[i], 2));
            abuf.append(new String(data, i, 1));
            if (i > 0 && (i + 1) % 16 == 0) {
                sbuf.append("    " + abuf.toString());
                abuf = new StringBuffer();
            }
            ++i;
        }
        return sbuf.toString();
    }

    private static String toHex(int value, int width) {
        StringBuffer buf = new StringBuffer();
        String rep = Integer.toHexString(value);
        while (buf.length() + rep.length() < width) {
            buf.append('0');
        }
        int i = rep.length() > width ? rep.length() - width : 0;
        while (buf.length() < width) {
            buf.append(rep.charAt(i++));
        }
        return buf.toString();
    }

    private static String createHeader(SYMbolAPIClientV1 client) {
        StringBuffer buf = new StringBuffer();
        String nvsram = "Unknown";
        try {
            ObjectBundle bundle = client.getObjectGraph();
            StorageArray stArray = bundle.getSa();
            SAData array = bundle.getSa().getSaData();
            nvsram = array.getNvsramVersion();
        }
        catch (Exception e) {
            nvsram = "Unavailable";
        }
        buf.append("NVSRAM Version = " + nvsram + "\n\n");
        buf.append("NVSRAM Host Type Table\n");
        buf.append(NEWLINE);
        buf.append("\tNVSRAM HOST TYPE INDEX DEFINITIONS\n");
        buf.append(NEWLINE);
        buf.append("\tINDEX        AVT STATUS  TYPE\n");
        buf.append("\t0 (Default)  Unknown     Solaris\n");
        buf.append("\t1            Unknown     DSP\n");
        buf.append("\t2            Unknown     Windows 2000/Server 2003 Non-Clustered\n");
        buf.append("\t3            Unknown     HP-UX\n");
        buf.append("\t4            Unknown     AIX\n");
        buf.append("\t5            Unknown     Irix\n");
        buf.append("\t6            Unknown     Linux\n");
        buf.append("\t7            Unknown     Windows NT Clustered (SP5 or higher)\n");
        buf.append("\t8            Unknown     Windows 2000/Server 2003 Clustered\n");
        buf.append("\t9            Unknown     AIX (with Veritas DMP)\n");
        buf.append("\t10           Unknown     PTX\n");
        buf.append("\t11           Unknown     Netware Failover\n");
        buf.append("\t12           Unknown     Solaris (with Veritas DMP)\n");
        buf.append("\t13           Unknown     Windows NT Non-Clustered (SP5 or higher)\n");
        buf.append("\n\n");
        return buf.toString();
    }

    static {
        INDENT_1 = INDENT_1;
        INDENT_2 = INDENT_2;
        ONE_SPACE = ONE_SPACE;
        NEWLINE = NEWLINE;
    }
}

