/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.device.storage.treefrog.eventlog.DecodeMEL;
import com.sun.netstorage.fm.storade.device.storage.treefrog.eventlog.EventLog;
import devmgr.versioned.symbol.ComponentLocation;
import devmgr.versioned.symbol.MelEntry;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.util.HashMap;

public class MELLog {
    static String getData(SYMbolAPIClientV1 client) {
        String data = "No MEL data collected";
        data = client != null ? MELLog.collectData(client) : "Invalid SYMbol connection to array";
        return data;
    }

    static String getData(SYMbolAPIClientV1 client1, SYMbolAPIClientV1 client2) {
        String data = "No MEL data collected";
        if (client1 != null) {
            data = MELLog.collectData(client1);
        } else if (client2 != null) {
            data = MELLog.collectData(client2);
        }
        return data;
    }

    private static String collectData(SYMbolAPIClientV1 client) {
        StringBuffer data = new StringBuffer();
        try {
            EventLog log = new EventLog();
            MelEntry[] entries = log.getMELEntries(client, 0L);
            if (entries.length == 0) {
                data.append("No MEL Log entries found");
            } else {
                HashMap descriptions = DecodeMEL.getDescriptions();
                int x = 0;
                while (x < entries.length) {
                    data.append(MELLog.decodeEntry(entries[x], descriptions));
                    ++x;
                }
            }
        }
        catch (Exception e) {
            data.append("\nError accessing Major Event Log\n" + e.toString());
        }
        return data.toString();
    }

    static String decodeEntry(MelEntry entry, HashMap descriptions) {
        StringBuffer data = new StringBuffer();
        try {
            data.append("Date/Time: " + Utility.convertDate(entry.getTimeStamp()) + "\n");
            data.append("Sequence number: " + entry.getSequenceNumber() + "\n");
            data.append("Event type: " + Integer.toHexString(entry.getEventType()).toUpperCase() + "\n");
            data.append("Event category: " + Translator.niceEventCategory(entry.getCategory()) + "\n");
            data.append("Priority: " + Translator.translateEventPriority(entry.getPriority()) + "\n");
            String text = "Description unknown";
            Integer eventCode = new Integer(entry.getEventType());
            if (descriptions.containsKey(eventCode)) {
                text = (String)descriptions.get(eventCode);
            }
            data.append("Description: " + text + "\n");
            data.append("Event specific codes: Not specified\n");
            data.append("Component type: " + DecodeMEL.getTypeName(entry.getComponentType()) + " \n");
            int type = entry.getComponentType().getValue();
            ComponentLocation cloc = entry.getComponentLocation();
            data.append("Component location: " + DecodeMEL.getComponentLocation(type, cloc) + " \n");
            int controller = entry.getEventSourceController();
            String source = "unspecified";
            if (controller == 1) {
                source = "A";
            } else if (controller == 2) {
                source = "B";
            }
            data.append("Logged by: Controller in slot " + source + "\n");
            data.append("Raw data:\n\n");
            data.append(MELLog.dumpRawData(entry.getRawData()));
        }
        catch (Exception e) {
            data.append("\nError parsing MelEntry\n" + e.toString());
        }
        data.append("\n\n");
        return data.toString();
    }

    private static String dumpRawData(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        int begin = 0;
        int length = 0;
        int end = 0;
        do {
            if (begin + (length = 16) > data.length) {
                length = data.length - begin;
            }
            end = begin + length;
            buffer.append(Utility.hexBytes(data, begin, end) + "\n");
        } while ((begin += length) < data.length);
        return buffer.toString();
    }
}

