/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveLogData;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DriveLogCollector {
    static boolean getData(SYMbolAPIClientV1 client, String path, String filename) {
        boolean rval = false;
        rval = DriveLogCollector.collectData(client, path, filename);
        return rval;
    }

    static boolean getData(SYMbolAPIClientV1 client1, SYMbolAPIClientV1 client2, String path, String filename) {
        boolean rval = false;
        if (client2 != null) {
            rval = DriveLogCollector.collectData(client2, path, filename);
        } else if (client1 != null) {
            rval = DriveLogCollector.collectData(client1, path, filename);
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean collectData(SYMbolAPIClientV1 client, String path, String filename) {
        DataOutputStream stream = null;
        try {
            try {
                ObjectBundle bundle = client.getObjectGraph();
                Drive[] drives = bundle.getDrive();
                stream = DriveLogCollector.openFile(path, filename);
                int x = 0;
                while (x < drives.length) {
                    DriveRef ref = drives[x].getDriveRef();
                    DriveLogData logData = client.getDriveLogData(ref);
                    if (logData.getReturnCode().getValue() == 1) {
                        byte[] log = logData.getLogs();
                        stream.write(log);
                    } else {
                        stream.writeChars("Error accessing log data, rc = " + Translator.translateReturnCode(logData.getReturnCode()));
                    }
                    ++x;
                }
            }
            catch (Exception e) {
                if (stream != null) {
                    try {
                        stream.writeChars("Exception accessing drive log data, rc = " + e.toString());
                    }
                    catch (Exception e2) {
                    }
                }
                Object var11_13 = null;
                DriveLogCollector.closeFile(stream);
                return true;
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            DriveLogCollector.closeFile(stream);
            throw throwable;
        }
        DriveLogCollector.closeFile(stream);
        return true;
    }

    private static DataOutputStream openFile(String path, String filename) {
        DataOutputStream dos = null;
        try {
            File outfile = new File(path, filename);
            FileOutputStream fos = new FileOutputStream(outfile);
            dos = new DataOutputStream(fos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean closeFile(DataOutputStream dos) {
        block9: {
            if (dos != null) {
                dos.flush();
                Object var3_1 = null;
                try {
                    dos.close();
                }
                catch (IOException ioe) {}
                break block9;
                {
                    catch (Exception e) {
                        Object var3_2 = null;
                        try {
                            dos.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    try {
                        dos.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return false;
    }
}

