/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.TreefrogReport;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.Util;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.resource.report.ReportClass;
import devmgr.versioned.symbol.Battery;
import devmgr.versioned.symbol.ComponentBundle;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ControllerSFP;
import devmgr.versioned.symbol.ControllerTime;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.Esm;
import devmgr.versioned.symbol.Fan;
import devmgr.versioned.symbol.HotSpareCoverage;
import devmgr.versioned.symbol.HotSpareCoverageList;
import devmgr.versioned.symbol.LUNMapping;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.PowerSupply;
import devmgr.versioned.symbol.SAData;
import devmgr.versioned.symbol.SFPParentTypeData;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Sfp;
import devmgr.versioned.symbol.StorageArray;
import devmgr.versioned.symbol.ThermalSensor;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.TrayRef;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumeCache;
import devmgr.versioned.symbol.VolumeGroup;
import devmgr.versioned.symbol.VolumeGroupRef;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ArrayProfile {
    private static final String NEWLINE = "\n";
    private static final String TAB = "\t";
    private static final String TAB2 = "\t\t";
    private static final String TAB3 = "\t\t\t";
    private static final String TBD = "<TBD>";
    private static final int KILOBYTE = 1024;
    private static final int MEGABYTE = 0x100000;
    private static final int GIGABYTE = 0x40000000;

    public static String getData(SYMbolAPIClientV1 client) {
        StringBuffer profile = new StringBuffer();
        try {
            ObjectBundle bundle = client.getObjectGraph();
            HotSpareCoverageList spares = null;
            try {
                profile.append("PROFILE FOR STORAGE ARRAY: " + Utility.userLabelString(bundle.getSa().getSaData().getStorageArrayLabel()) + NEWLINE);
                spares = client.getHotSpareCoverage();
            }
            catch (Exception sube) {
                // empty catch block
            }
            ControllerTime ctime = client.getControllerTime();
            ArrayProfile.getArraySummaryData(bundle, spares, profile);
            ArrayProfile.getControllerData(bundle, ctime, profile);
            ArrayProfile.getVolumeGroupData(bundle, profile);
            ArrayProfile.getVolumeData(bundle, profile);
            ArrayProfile.getDriveData(bundle, profile);
            ArrayProfile.getHotSpareData(bundle, spares, profile);
            ArrayProfile.getTrayData(bundle, profile);
        }
        catch (Exception e) {
            profile.append("Exception: " + e.toString());
        }
        return profile.toString();
    }

    private static void getArraySummaryData(ObjectBundle bundle, HotSpareCoverageList spares, StringBuffer buf) {
        buf.append(NEWLINE);
        buf.append("SUMMARY------------------------------\n");
        try {
            StorageArray stArray = bundle.getSa();
            SAData array = bundle.getSa().getSaData();
            byte[] firmware = array.getFwVersion();
            byte[] wwn = array.getSaId().getWorldWideName();
            boolean noBattery = stArray.getFeatureParameters().getBattery_not_in_configuration();
            String battery = !noBattery ? "Yes" : "No";
            Controller[] controllers = bundle.getController();
            Drive[] drives = bundle.getDrive();
            int hotSpares = 0;
            int installedDrives = 0;
            int x = 0;
            while (x < drives.length) {
                if (drives[x].getHotSpare()) {
                    ++hotSpares;
                }
                if (drives[x].getStatus().getValue() != 6) {
                    ++installedDrives;
                }
                ++x;
            }
            int sparesInUse = 0;
            int standbySpares = hotSpares;
            if (spares != null) {
                HotSpareCoverage[] coverage = spares.getHotSpareCoverage();
                int i = 0;
                while (i < coverage.length) {
                    if (coverage[i].getInUse()) {
                        ++sparesInUse;
                        --standbySpares;
                    }
                    ++i;
                }
            }
            VolumeGroup[] volumeGroups = bundle.getVolumeGroup();
            Volume[] volumes = bundle.getVolume();
            buf.append("\tNumber of controllers: " + controllers.length + NEWLINE);
            buf.append("\tNumber of volume groups: " + volumeGroups.length + NEWLINE);
            buf.append("\tTotal number of volumes " + volumes.length + NEWLINE);
            buf.append("\t   Number of standard volumes: " + volumes.length + NEWLINE);
            buf.append("\tNumber of installed drives: " + installedDrives + NEWLINE);
            buf.append("\tTotal hot spare drives: " + hotSpares + NEWLINE);
            buf.append("\t   Standby: " + standbySpares + NEWLINE);
            buf.append("\t   In use: " + sparesInUse + NEWLINE);
            buf.append("\tCurrent configuration\n");
            buf.append("\t   Firmware version: " + Utility.bytesToDecimalString(firmware) + NEWLINE);
            buf.append("\t   NVSRAM version: " + array.getNvsramVersion() + NEWLINE);
            buf.append("\tNVSRAM configured for batteries: " + battery + NEWLINE);
            buf.append("\tCache block size (in KB): " + stArray.getCache().getCacheBlkSize() / 1024 + NEWLINE);
            buf.append("\tMedia scan frequency (in days): " + stArray.getMediaScanPeriod() + NEWLINE);
            buf.append("\tStorage array pseudo worldwide name (ID): " + Utility.wwnString(wwn) + NEWLINE);
            buf.append(NEWLINE);
        }
        catch (Exception e) {
            buf.append("Problem with StorageArray data.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void getControllerData(ObjectBundle bundle, ControllerTime ctime, StringBuffer buf) {
        block11: {
            buf.append("Controllers------------------------------\n");
            try {
                controllers = bundle.getController();
                nvsram = bundle.getSa().getSaData().getNvsramVersion();
                buf.append("Number of controllers: " + controllers.length + "\n" + "\n");
                x = 0;
                while (x < controllers.length) {
                    controller = controllers[x];
                    buf.append("\t" + Util.createName(bundle, controller.getControllerRef()) + "\n");
                    buf.append("\t   Status: " + Translator.translateControllerStatus(controller.getStatus().getValue()) + "\n");
                    buf.append("\t   Current configuration\n");
                    buf.append("\t      Firmware version: \n");
                    buf.append("\t         Appware version: " + controller.getAppVersion() + "\n");
                    buf.append("\t         Bootware version: " + controller.getBootVersion() + "\n");
                    buf.append("\t      NVSRAM version: " + nvsram + "\n");
                    buf.append("\t   Board ID: " + controller.getBoardID() + "\n");
                    buf.append("\t   Product ID: " + controller.getProductID() + "\n");
                    buf.append("\t   Product revision: " + controller.getProductRevLevel() + "\n");
                    buf.append("\t   Serial number: " + controller.getSerialNumber() + "\n");
                    buf.append("\t   Date of manufacture: " + Utility.convertDate(controller.getManufacturerDate()) + "\n");
                    buf.append("\t   Cache/processor size (MB): " + controller.getCacheMemorySize() + "/" + controller.getProcessorMemorySize() + "\n");
                    if (x == 0) {
                        buf.append("\t   Date/Time: " + Utility.convertDate(ctime.getControllerATime()) + "\n");
                    } else {
                        buf.append("\t   Date/Time: " + Utility.convertDate(ctime.getControllerBTime()) + "\n");
                    }
                    buf.append("\t   Associated Volumes (* = Preferred Owner):\n");
                    buf.append(ArrayProfile.getAssociatedVolumes(bundle, controller.getControllerRef(), "\t\t\t") + "\n");
                    net = controller.getNetInterfaces();
                    i = 0;
                    while (i < net.length) {
                        enet = net[i].getEthernet();
                        gwip = enet.getGatewayIp();
                        ip = enet.getIp();
                        buf.append("\t   Ethernet port: " + (x + 1) + "\n");
                        buf.append("\t      MAC address: " + Utility.bytesToString(enet.getMacAddr()) + "\n");
                        buf.append("\t      IP address: " + Utility.convertIpAddr(ip) + "\n");
                        buf.append("\t      Subnet mask: " + Utility.convertIpAddr(enet.getSubnetMask()) + "\n");
                        buf.append("\t      Gateway: " + Utility.convertIpAddr(gwip) + "\n");
                        buf.append("\t      Remote login: " + enet.getRloginEnabled() + "\n");
                        ++i;
                    }
                    buf.append("\n");
                    driveIFData = controller.getDriveInterfaces();
                    i = 0;
                    while (i < driveIFData.length) {
                        type = driveIFData[i].getInterfaceType().getValue();
                        if (type == 2) {
                            fc = driveIFData[i].getFibre();
                            buf.append("\t   Drive interface: Fibre\n");
                            buf.append("\t      Channel: " + fc.getChannel() + "\n");
                            buf.append("\t      Maximum data rate: " + fc.getMaxSpeed() + " MB/s" + "\n");
                            buf.append("\t      Current data rate: " + fc.getSpeed() + " MB/s" + "\n");
                            temp = fc.getLinkStatus().getValue();
                            buf.append("\t      Link status: " + Translator.translateLinkStatus(temp) + "\n");
                        }
                        ++i;
                    }
                    hostIfData = controller.getHostInterfaces();
                    i = 0;
                    while (i < hostIfData.length) {
                        type = hostIfData[i].getInterfaceType().getValue();
                        if (type == 2) {
                            fc = hostIfData[i].getFibre();
                            buf.append("\t   Host interface: Fibre\n");
                            buf.append("\t      Port: " + Utility.bytesArrayString(fc.getPortId()) + "\n");
                            buf.append("\t      NL-Port ID: " + fc.getLoopID() + "\n");
                            buf.append("\t      Maximum data rate: " + fc.getMaxSpeed() + "\n");
                            buf.append("\t      Current data rate: " + fc.getSpeed() + "\n");
                            temp = fc.getLinkStatus().getValue();
                            buf.append("\t      Link status: " + Translator.translateLinkStatus(temp) + "\n");
                            buf.append("\t      Topology: " + Translator.translateTopologyType(fc.getTopology().getValue()) + "\n");
                            buf.append("\t      World-wide port name: " + Utility.wwnString(fc.getPortName()) + "\n");
                            buf.append("\t      World-wide node name: " + Utility.wwnString(fc.getNodeName()) + "\n");
                            buf.append("\t      Part type: " + fc.getPart() + "\n");
                        }
                        ++i;
                    }
                    buf.append("\n");
                    ++x;
                }
                break block11;
            }
            catch (Exception e) {
                buf.append("Error getting controller data\n");
                buf.append(e.toString() + "\n");
                ste = e.getStackTrace();
                z = 0;
                ** while (z < ste.length)
            }
lbl-1000:
            // 1 sources

            {
                buf.append(ste[z].toString() + "\n");
                ++z;
                continue;
            }
        }
    }

    private static String getAssociatedVolumes(ObjectBundle bundle, ControllerRef cref, String indent) {
        StringBuffer assocVols = new StringBuffer();
        byte[] target = cref.getRefToken();
        try {
            Volume[] volumes = bundle.getVolume();
            int x = 0;
            while (x < volumes.length) {
                Volume volume = volumes[x];
                byte[] cman = volume.getCurrentManager().getRefToken();
                byte[] pman = volume.getPreferredManager().getRefToken();
                if (Utility.rawCompare(target, cman)) {
                    String label = Utility.userLabelString(volume.getLabel());
                    assocVols.append(indent + label);
                    if (Utility.rawCompare(target, pman)) {
                        assocVols.append("*");
                    }
                    assocVols.append(NEWLINE);
                }
                ++x;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return assocVols.toString();
    }

    private static String getAssociatedVolumes(ObjectBundle bundle, VolumeGroupRef vgref, String indent) {
        StringBuffer assocVols = new StringBuffer();
        byte[] target = vgref.getRefToken();
        try {
            Volume[] volumes = bundle.getVolume();
            int x = 0;
            while (x < volumes.length) {
                Volume volume = volumes[x];
                byte[] parent = volume.getVolumeGroupRef().getRefToken();
                if (Utility.rawCompare(target, parent)) {
                    String label = Utility.userLabelString(volume.getLabel());
                    String capacity = "" + volume.getCapacity() / 0x40000000L;
                    assocVols.append(indent + label + " (" + capacity + " GB)");
                    assocVols.append(NEWLINE);
                }
                ++x;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return assocVols.toString();
    }

    private static String getAssociatedDrives(ObjectBundle bundle, VolumeGroupRef vgref, String indent) {
        StringBuffer assocDrives = new StringBuffer();
        byte[] target = vgref.getRefToken();
        try {
            Drive[] drives = bundle.getDrive();
            int x = 0;
            while (x < drives.length) {
                Drive drive = drives[x];
                try {
                    byte[] parent = drive.getCurrentVolumeGroupRef().getRefToken();
                    if (Utility.rawCompare(target, parent)) {
                        String name = Util.createName(bundle, drive.getDriveRef());
                        assocDrives.append(indent + name);
                        assocDrives.append(NEWLINE);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++x;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return assocDrives.toString();
    }

    private static void getVolumeGroupData(ObjectBundle bundle, StringBuffer buf) {
        buf.append("\nVirtual Disks (Volume Groups) --------------\n");
        try {
            VolumeGroup[] volumeGroups = bundle.getVolumeGroup();
            buf.append("Number of volume groups: " + volumeGroups.length + NEWLINE);
            buf.append(NEWLINE);
            int v = 0;
            while (v < volumeGroups.length) {
                VolumeGroup volumeGroup = volumeGroups[v];
                buf.append("\tVolumeGroup " + volumeGroup.getSequenceNum() + NEWLINE);
                buf.append("\t\tRaid Level: " + Translator.translateRaidLevel(volumeGroup.getRaidLevel().getValue()) + NEWLINE);
                buf.append("\t\tOnline: " + !volumeGroup.getOffline() + NEWLINE);
                buf.append("\t\tTray loss protection: " + volumeGroup.getTrayLossProtection() + NEWLINE);
                buf.append("\t\tAssociated volumes and free capacities:\n");
                buf.append(ArrayProfile.getAssociatedVolumes(bundle, volumeGroup.getVolumeGroupRef(), TAB3));
                buf.append("\t\tAssociated drives\n");
                buf.append(ArrayProfile.getAssociatedDrives(bundle, volumeGroup.getVolumeGroupRef(), TAB3));
                ++v;
            }
        }
        catch (Exception e) {
            buf.append("Error accessing volume group data");
        }
    }

    private static void getVolumeData(ObjectBundle bundle, StringBuffer buf) {
        try {
            buf.append(NEWLINE);
            buf.append("STANDARD VOLUMES------------------------------\n");
            buf.append(NEWLINE);
            Volume[] volumes = bundle.getVolume();
            buf.append("SUMMARY\n");
            buf.append("\tNumber of standard volumes: " + volumes.length + NEWLINE);
            buf.append(NEWLINE);
            buf.append("\tNAME\t\tSTATUS\tCAPACITY\tRAID LEVEL\tVDISK(VOLUME GROUP)\n");
            int v = 0;
            while (v < volumes.length) {
                Volume volume = volumes[v];
                buf.append(TAB);
                buf.append(Utility.userLabelString(volume.getLabel()) + TAB);
                buf.append(Translator.translateVolumeStatus(volume.getStatus().getValue()) + TAB);
                buf.append(volume.getCapacity() / 0x40000000L + " GB" + TAB2);
                buf.append(Translator.translateRaidLevel(volume.getRaidLevel()) + TAB2);
                buf.append(ArrayProfile.getVolumeGroupID(bundle, volume.getVolumeGroupRef()));
                buf.append(NEWLINE);
                ++v;
            }
            buf.append(NEWLINE);
            buf.append("DETAILS\n");
            int v2 = 0;
            while (v2 < volumes.length) {
                Volume volume = volumes[v2];
                VolumeCache cache = volume.getCache();
                buf.append("\tVolume name: " + Utility.userLabelString(volume.getLabel()) + NEWLINE);
                buf.append("\t\tVolume handle: " + volume.getVolumeHandle() + NEWLINE);
                buf.append("\t\tVolume WWN: " + Utility.wwnString(volume.getWorldWideName()) + NEWLINE);
                buf.append("\t\tStatus: " + Translator.translateVolumeStatus(volume.getStatus().getValue()) + NEWLINE);
                buf.append("\t\tPreferred owner: " + TreefrogReport.findControllerName(bundle, volume.getPreferredManager()) + NEWLINE);
                buf.append("\t\tCurrent owner: " + TreefrogReport.findControllerName(bundle, volume.getCurrentManager()) + NEWLINE);
                buf.append("\t\tCapacity: " + volume.getCapacity() / 0x40000000L + " GB" + NEWLINE);
                buf.append("\t\tRaid level: " + Translator.translateRaidLevel(volume.getRaidLevel()) + NEWLINE);
                buf.append("\t\tSegment size: " + volume.getSegmentSize() / 1024 + " KB" + NEWLINE);
                buf.append("\t\tReconstruction priority: " + volume.getReconPriority() + NEWLINE);
                buf.append("\t\tAssociated volume group: " + ArrayProfile.getVolumeGroupID(bundle, volume.getVolumeGroupRef()) + NEWLINE);
                buf.append("\t\tRead cache enabled: " + cache.getReadCacheEnable() + NEWLINE);
                buf.append("\t\tRead cache active: " + cache.getReadCacheActive() + NEWLINE);
                buf.append("\t\tWrite cache enabled: " + cache.getWriteCacheEnable() + NEWLINE);
                buf.append("\t\tWrite cache active: " + cache.getWriteCacheActive() + NEWLINE);
                buf.append("\t\tWrite cache without batteries: " + cache.getCwob() + NEWLINE);
                buf.append("\t\tWrite cache with mirroring enabled: " + cache.getMirrorEnable() + NEWLINE);
                buf.append("\t\tWrite cache with mirroring active: " + cache.getMirrorActive() + NEWLINE);
                buf.append("\t\tFlush write cache after (in seconds): " + Translator.translateCacheFlushModifier(cache.getCacheFlushModifier()) + NEWLINE);
                buf.append("\t\tCache read ahead multiplier: " + cache.getReadAheadMultiplier() + NEWLINE);
                buf.append("\t\tMedia scan enabled: " + volume.getMediaScan().getEnable() + NEWLINE);
                buf.append("\t\tMedia scan with parity check: " + volume.getMediaScan().getParityValidationEnable() + NEWLINE);
                buf.append(NEWLINE);
                ++v2;
            }
        }
        catch (Exception e) {
            buf.append("Error accessing volume data");
        }
    }

    private static String getVolumeGroupID(ObjectBundle bundle, VolumeGroupRef ref) {
        String id = "Unknown";
        try {
            VolumeGroup[] groups = bundle.getVolumeGroup();
            byte[] targetVG = ref.getRefToken();
            int x = 0;
            while (x < groups.length) {
                byte[] currentVG = groups[x].getVolumeGroupRef().getRefToken();
                if (Utility.rawCompare(targetVG, currentVG)) {
                    id = "VolumeGroup." + groups[x].getSequenceNum();
                    break;
                }
                ++x;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return id;
    }

    /*
     * Unable to fully structure code
     */
    private static void getDriveData(ObjectBundle bundle, StringBuffer buf) {
        block10: {
            try {
                buf.append("\nDrives --------------------\n");
                drives = bundle.getDrive();
                d = 0;
                while (d < drives.length) {
                    drive = drives[d];
                    if (drive.getStatus().getValue() == 6) {
                        buf.append("\t" + Util.createName(bundle, drive.getDriveRef()) + "\n");
                        buf.append("\t\tStatus: Removed\n");
                        buf.append("\n");
                    } else {
                        red = "OK";
                        if (drive.getNonRedundantAccess()) {
                            red = "Error";
                        }
                        buf.append("\t" + Util.createName(bundle, drive.getDriveRef()) + "\n");
                        dtd = drive.getInterfaceType();
                        if (dtd.getDriveType().getValue() == 2) {
                            addr = dtd.getFibre();
                            x = 0;
                            while (x < addr.length) {
                                buf.append("\t\tDrive port: " + addr[x].getChannel() + ", Channel: " + addr[x].getChannel() + ", ID: " + addr[x].getLoopID() + "\n");
                                ++x;
                            }
                        }
                        buf.append("\t\tDrive path redundancy: " + red + "\n");
                        buf.append("\t\tStatus: " + Translator.translateDriveStatus(drive.getStatus().getValue()) + "\n");
                        buf.append("\t\tRaw capacity: " + drive.getRawCapacity() / 0x100000L + " MB" + "\n");
                        buf.append("\t\tUsable capacity: " + drive.getUsableCapacity() / 0x100000L + " MB" + "\n");
                        buf.append("\t\tCurrent data rate: " + Translator.translateSpeed(drive.getCurrentSpeed()) + "\n");
                        buf.append("\t\tProduct ID: " + drive.getProductID() + "\n");
                        buf.append("\t\tFirmware version: " + drive.getSoftwareVersion() + "\n");
                        buf.append("\t\tSerial number: " + drive.getSerialNumber() + "\n");
                        buf.append("\t\tVendor: " + drive.getManufacturer() + "\n");
                        buf.append("\t\tDate of manufacture: " + Utility.convertDate(drive.getManufacturerDate()) + "\n");
                        buf.append("\t\tWorld-wide name: " + Utility.wwnString(drive.getWorldWideName()) + "\n");
                        buf.append("\t\tDrive type: " + Translator.translateDriveType(dtd.getDriveType()) + "\n");
                        buf.append("\t\tSpeed: " + drive.getSpindleSpeed() + " RPM\n");
                        mode = "Unassigned";
                        vgroup = "None";
                        if (drive.getVolumeGroupIndex() >= 0) {
                            mode = "Assigned";
                            vgroup = ArrayProfile.getVolumeGroupID(bundle, drive.getCurrentVolumeGroupRef());
                        }
                        buf.append("\t\tMode: " + mode + "\n");
                        buf.append("\t\tAssociated volume group: " + vgroup + "\n");
                        buf.append("\n");
                    }
                    ++d;
                }
                break block10;
            }
            catch (Exception e) {
                buf.append("Error accessing Drive data\n");
                buf.append(e.toString() + "\n");
                ste = e.getStackTrace();
                z = 0;
                ** while (z < ste.length)
            }
lbl-1000:
            // 1 sources

            {
                buf.append(ste[z].toString() + "\n");
                ++z;
                continue;
            }
        }
    }

    private static void getHotSpareData(ObjectBundle bundle, HotSpareCoverageList spares, StringBuffer buf) {
        try {
            int i;
            int totalSpares = 0;
            int sparesInUse = 0;
            int standbySpares = 0;
            HotSpareCoverage[] coverage = null;
            if (spares != null) {
                coverage = spares.getHotSpareCoverage();
                totalSpares = coverage.length;
                i = 0;
                while (i < coverage.length) {
                    if (coverage[i].getInUse()) {
                        ++sparesInUse;
                    }
                    ++i;
                }
                standbySpares = totalSpares - sparesInUse;
            }
            buf.append("HOT SPARE COVERAGE:\n\n");
            buf.append("\tTotal hot spare drives: " + totalSpares + NEWLINE);
            buf.append("\t\tStandby: " + standbySpares + NEWLINE);
            buf.append("\t\tIn use: " + sparesInUse + NEWLINE + NEWLINE);
            if (coverage != null) {
                i = 0;
                while (i < coverage.length) {
                    HotSpareCoverage spare = coverage[i];
                    DriveRef dref = spare.getDriveRef();
                    String driveName = Util.createName(bundle, dref);
                    buf.append("\tStandby drive " + driveName + NEWLINE);
                    buf.append("\t\tProtects the following volume groups: ");
                    VolumeGroupRef[] vgreflinst = spare.getVolumeGroupRefList().getVolumeGroupRef();
                    int y = 0;
                    while (y < vgreflinst.length) {
                        buf.append(ArrayProfile.getVolumeGroupID(bundle, vgreflinst[y]) + ", ");
                        ++y;
                    }
                    buf.append(NEWLINE);
                    ++i;
                }
            }
            buf.append(NEWLINE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void getTrayData(ObjectBundle bundle, StringBuffer buf) {
        try {
            buf.append("TRAYS------------------------------\n");
            Tray[] trays = bundle.getTray();
            int x = 0;
            while (x < trays.length) {
                Tray tray = trays[x];
                buf.append(NEWLINE);
                buf.append("\tOverall Component Information for Drive/Controller tray " + tray.getTrayId() + NEWLINE);
                buf.append("\t\tSpeed Mismatch: " + tray.getDrvMHSpeedMismatch() + NEWLINE);
                buf.append("\t\tIOM Miswire: " + tray.getEsmMiswire() + NEWLINE);
                buf.append("\t\tIOM Mismatch: " + tray.getEsmVersionMismatch() + NEWLINE);
                buf.append("\t\tPart Number: " + tray.getPartNumber() + NEWLINE);
                buf.append("\t\tSerial Number: " + tray.getSerialNumber() + NEWLINE);
                buf.append("\t\tVendor: " + tray.getVendorName() + NEWLINE);
                buf.append("\t\tDate of manufacture: " + Utility.convertDate(tray.getManufacturerDate()) + NEWLINE);
                buf.append("\t\tTray path redundant: " + !tray.getNonRedundantAccess() + NEWLINE);
                TrayRef trayRef = tray.getTrayRef();
                ArrayProfile.getTrayComponentData(bundle, buf, trayRef);
                ++x;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void getTrayComponentData(ObjectBundle bundle, StringBuffer buf, TrayRef trayRef) {
        try {
            ArrayProfile.getFanData(bundle, buf, trayRef);
            ArrayProfile.getBatteryData(bundle, buf, trayRef);
            ArrayProfile.getPowerSupplyData(bundle, buf, trayRef);
            ArrayProfile.getThermalSensorData(bundle, buf, trayRef);
            ArrayProfile.getEsmData(bundle, buf, trayRef);
            ArrayProfile.getSfpData(bundle, buf, trayRef);
        }
        catch (Exception e) {
            buf.append("Error accessing tray component data");
        }
    }

    private static void getFanData(ObjectBundle obundle, StringBuffer buf, TrayRef trayRef) {
        ComponentBundle cbundle = obundle.getComponentBundle();
        try {
            Fan[] fans = cbundle.getFan();
            int x = 0;
            while (x < fans.length) {
                Fan fan = fans[x];
                Location location = fan.getPhysicalLocation();
                if (ArrayProfile.compareTrayRefs(trayRef, location.getTrayRef())) {
                    Tray tray = Utility.findTray(obundle, location.getTrayRef());
                    String id = "Tray." + tray.getTrayId() + ".Fan." + location.getSlot();
                    buf.append("\t\tFan " + id + NEWLINE);
                    buf.append("\t\t\tStatus: " + Translator.translateFanStatus(fan.getStatus().getValue()));
                    buf.append(NEWLINE);
                }
                ++x;
            }
        }
        catch (Exception e) {
            buf.append("Error accessing fan data\n");
        }
    }

    private static void getBatteryData(ObjectBundle obundle, StringBuffer buf, TrayRef trayRef) {
        ComponentBundle cbundle = obundle.getComponentBundle();
        try {
            Battery[] batteries = cbundle.getBattery();
            int x = 0;
            while (x < batteries.length) {
                Battery battery = batteries[x];
                Location location = battery.getPhysicalLocation();
                if (ArrayProfile.compareTrayRefs(trayRef, location.getTrayRef())) {
                    ControllerRef cref = battery.getBatteryTypeData().getParentController();
                    String parentName = TreefrogReport.findControllerName(obundle, battery.getBatteryTypeData().getParentController());
                    String locationName = parentName + ".Battery";
                    buf.append("\t\tBattery: " + locationName + NEWLINE);
                    buf.append("\t\t\tStatus: " + Translator.translateBatteryStatus(battery.getStatus()) + NEWLINE);
                    buf.append("\t\t\tAge in days: " + battery.getBatteryAge() + NEWLINE);
                    buf.append("\t\t\tDays until replacement: " + battery.getBatteryLifeRemaining() + NEWLINE);
                }
                ++x;
            }
        }
        catch (Exception e) {
            buf.append("Error accessing battery data\n");
        }
    }

    private static void getEsmData(ObjectBundle obundle, StringBuffer buf, TrayRef trayRef) {
        ComponentBundle cbundle = obundle.getComponentBundle();
        try {
            Esm[] esms = cbundle.getEsm();
            int x = 0;
            while (x < esms.length) {
                Esm esm = esms[x];
                Location location = esm.getPhysicalLocation();
                if (ArrayProfile.compareTrayRefs(trayRef, location.getTrayRef())) {
                    Tray tray = Utility.findTray(obundle, location.getTrayRef());
                    String locationName = "Tray." + tray.getTrayId() + ".IOM" + location.getSlot();
                    int currSpeed = esm.getCurrentSpeed().getValue();
                    int maxSpeed = esm.getMaxSpeed().getValue();
                    buf.append("\t\tIOM (ESM) card " + locationName + NEWLINE);
                    buf.append("\t\t\tStatus: " + locationName + NEWLINE);
                    buf.append("\t\t\tFirmware version: " + esm.getSoftwareVersion() + NEWLINE);
                    buf.append("\t\t\tMaximum data rate: " + Translator.translateSpeed(maxSpeed) + NEWLINE);
                    buf.append("\t\t\tCurrent data rate: " + Translator.translateSpeed(currSpeed) + NEWLINE);
                    buf.append("\t\t\tProduct ID: " + esm.getProductID() + NEWLINE);
                    buf.append("\t\t\tPart Number: " + esm.getPartNumber() + NEWLINE);
                    buf.append("\t\t\tSerial Number: " + esm.getSerialNumber() + NEWLINE);
                    buf.append("\t\t\tVendor: " + esm.getManufacturer() + NEWLINE);
                    buf.append("\t\t\tDate of manufacture: " + Utility.convertDate(esm.getManufacturerDate()) + NEWLINE);
                }
                ++x;
            }
        }
        catch (Exception e) {
            buf.append("Error accessing IOM data\n");
        }
    }

    private static void getPowerSupplyData(ObjectBundle obundle, StringBuffer buf, TrayRef trayRef) {
        ComponentBundle cbundle = obundle.getComponentBundle();
        try {
            PowerSupply[] powerSupplies = cbundle.getPowerSupply();
            int x = 0;
            while (x < powerSupplies.length) {
                PowerSupply powerSupply = powerSupplies[x];
                Location location = powerSupply.getPhysicalLocation();
                if (ArrayProfile.compareTrayRefs(trayRef, location.getTrayRef())) {
                    Tray tray = Utility.findTray(obundle, location.getTrayRef());
                    buf.append("\t\tPower supply Tray." + tray.getTrayId() + ".PowerSupply" + location.getSlot() + NEWLINE);
                    buf.append("\t\t\tStatus: " + Translator.translatePowerSupplyStatus(powerSupply.getStatus().getValue()) + NEWLINE);
                    buf.append("\t\t\tPart Number: " + powerSupply.getPartNumber() + NEWLINE);
                    buf.append("\t\t\tSerial Number: " + powerSupply.getSerialNumber() + NEWLINE);
                    buf.append("\t\t\tVendor: " + powerSupply.getVendorName() + NEWLINE);
                    buf.append("\t\t\tDate of manufacture: " + Utility.convertDate(powerSupply.getManufacturerDate()) + NEWLINE);
                }
                ++x;
            }
        }
        catch (Exception e) {
            buf.append("Error accessing power supply data\n");
        }
    }

    private static void getThermalSensorData(ObjectBundle obundle, StringBuffer buf, TrayRef trayRef) {
        ComponentBundle cbundle = obundle.getComponentBundle();
        try {
            ThermalSensor[] tempSensors = cbundle.getThermalSensor();
            int x = 0;
            while (x < tempSensors.length) {
                ThermalSensor tempSensor = tempSensors[x];
                Location location = tempSensor.getPhysicalLocation();
                if (ArrayProfile.compareTrayRefs(trayRef, location.getTrayRef())) {
                    buf.append("\t\tTemperature: " + Translator.translateTempStatus(tempSensor.getStatus().getValue()) + NEWLINE);
                }
                ++x;
            }
        }
        catch (Exception e) {
            buf.append("Error accessing temperature data");
        }
    }

    private static void getSfpData(ObjectBundle obundle, StringBuffer buf, TrayRef trayRef) {
        ComponentBundle cbundle = obundle.getComponentBundle();
        try {
            Sfp[] sfps = cbundle.getSfp();
            int x = 0;
            while (x < sfps.length) {
                Sfp sfp = sfps[x];
                Location location = sfp.getPhysicalLocation();
                if (ArrayProfile.compareTrayRefs(trayRef, location.getTrayRef())) {
                    SFPParentTypeData parent = sfp.getParentData();
                    int ptype = parent.getSfpParentType().getValue();
                    String nameExtention = "";
                    String parentName = "";
                    if (ptype == 3) {
                        ControllerSFP controller = parent.getControllerSFP();
                        parentName = TreefrogReport.findControllerName(obundle, controller.getParentController());
                        int type = controller.getControllerSFPType().getValue();
                        if (type == 2) {
                            nameExtention = ".SFP.Expansion";
                        } else if (type == 1) {
                            nameExtention = ".SFP.Host" + controller.getChannel();
                        }
                    } else if (ptype == 1) {
                        parentName = TreefrogReport.findEsmName(obundle, parent.getParentEsm());
                        nameExtention = ".SFP.Port" + sfp.getSfpPort().getValue();
                    } else if (ptype == 2) {
                        parentName = "minihub";
                    }
                    String name = null;
                    name = nameExtention == null ? TreefrogReport.findSfpName(parentName, sfp.getSfpRef()) : parentName + nameExtention;
                    buf.append("\t\tSFP\n");
                    buf.append("\t\t\tLocation: " + name + NEWLINE);
                    buf.append("\t\t\tStatus: " + Translator.translateSfpStatus(sfp.getStatus().getValue()) + NEWLINE);
                    buf.append("\t\t\tLink length: " + Translator.translateSfpLinkType(sfp.getSfpType().getSfpLinkLType()) + NEWLINE);
                    buf.append("\t\t\tConnector: " + Translator.translateSfpConnectType(sfp.getSfpType().getSfpConnectType()) + NEWLINE);
                    buf.append("\t\t\tTransmitter type: " + Translator.translateSfpXmitType(sfp.getSfpType().getSfpTransmitterType()) + NEWLINE);
                    buf.append("\t\t\tTransmission media: " + Translator.translateSfpXmitMedia(sfp.getSfpType().getSfpTransmissionMedia()) + NEWLINE);
                    buf.append("\t\t\tIEEE company ID: " + Utility.bytesArrayString(sfp.getSfpType().getVendorOUI()) + NEWLINE);
                    buf.append("\t\t\tRevision: " + sfp.getSfpType().getVendorRev() + NEWLINE);
                    buf.append("\t\t\tPart number: " + sfp.getSfpType().getVendorPN() + NEWLINE);
                    buf.append("\t\t\tSerial number: " + sfp.getSfpType().getVendorSN() + NEWLINE);
                    buf.append("\t\t\tVendor: " + sfp.getSfpType().getVendorName() + NEWLINE);
                    buf.append("\t\t\tDate of manufacture: " + Utility.convertDate(sfp.getSfpType().getManufacturerDate()) + NEWLINE);
                }
                ++x;
            }
        }
        catch (Exception e) {
            buf.append("Error accessing SFP data\n");
        }
    }

    private static void printLUNMappings(LUNMapping[] mappings, StringBuffer buf) {
        try {
            buf.append("system.lunCount\t" + mappings.length);
            int x = 0;
            while (x < mappings.length) {
                String prefix = "Lun." + x + ".";
                buf.append(prefix + "id\t" + mappings[x].getLun());
                buf.append(prefix + "perms\t" + mappings[x].getPerms());
                buf.append(prefix + "SSID\t" + mappings[x].getSsid());
                buf.append(prefix + "type\t" + mappings[x].getType().getValue());
                ++x;
            }
        }
        catch (Exception e) {
            buf.append("Problems with LUN Mapping data");
        }
    }

    private static boolean compareTrayRefs(TrayRef target, TrayRef current) {
        byte[] rawCurrent;
        boolean match = false;
        byte[] rawTarget = target.getRefToken();
        if (Utility.rawCompare(rawTarget, rawCurrent = current.getRefToken())) {
            match = true;
        }
        return match;
    }

    public static boolean storeData(ReportClass report, String path, String filename) {
        try {
            DataOutputStream stream = ArrayProfile.openFile(path, filename);
            report.toTab(stream);
            ArrayProfile.closeFile(stream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static DataOutputStream openFile(String path, String filename) {
        DataOutputStream dos = null;
        try {
            File outfile = new File(path, filename);
            FileOutputStream fos = new FileOutputStream(outfile);
            dos = new DataOutputStream(fos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean closeFile(DataOutputStream dos) {
        block9: {
            if (dos != null) {
                dos.flush();
                Object var3_1 = null;
                try {
                    dos.close();
                }
                catch (IOException ioe) {}
                break block9;
                {
                    catch (Exception e) {
                        Object var3_2 = null;
                        try {
                            dos.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    try {
                        dos.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return false;
    }

    static {
        NEWLINE = NEWLINE;
        TAB = TAB;
        TAB2 = TAB2;
        TAB3 = TAB3;
        TBD = TBD;
        KILOBYTE = 1024;
        MEGABYTE = 0x100000;
        GIGABYTE = 0x40000000;
    }
}

