/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.device.storage.treefrog.discovery.BroadCaster;
import devmgr.versioned.symbol.AccessibleController;
import devmgr.versioned.symbol.ControllerDescriptor;
import devmgr.versioned.symbol.DiscoveryResponse;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.RLSCommand;
import devmgr.versioned.symbol.RLSCommandDescriptor;
import devmgr.versioned.symbol.RLSResults;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class SYMbolConnection {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ObjectBundle getObjectBundle(Properties props) {
        SYMbolAPIClientV1 client = null;
        ObjectBundle bundle = null;
        try {
            block4: {
                try {
                    client = SYMbolConnection.getClient(props);
                    if (client == null) break block4;
                    bundle = client.getObjectGraph();
                }
                catch (Exception e) {
                    Object var5_4 = null;
                    SYMbolConnection.closeClient(client);
                    return bundle;
                }
            }
            Object var5_3 = null;
            SYMbolConnection.closeClient(client);
            return bundle;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            SYMbolConnection.closeClient(client);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ObjectBundle getObjectBundle(String ip) {
        ObjectBundle bundle = null;
        SYMbolAPIClientV1 symbolClient = null;
        try {
            block4: {
                try {
                    InetAddress inet = InetAddress.getByName(ip);
                    symbolClient = new SYMbolAPIClientV1(inet, 2463, true);
                    if (symbolClient == null) break block4;
                    bundle = symbolClient.getObjectGraph();
                }
                catch (Exception e) {
                    System.out.println("Error opening/using the client connection.");
                    Object var5_6 = null;
                    SYMbolConnection.closeClient(symbolClient);
                    return bundle;
                }
            }
            Object var5_5 = null;
            SYMbolConnection.closeClient(symbolClient);
            return bundle;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            SYMbolConnection.closeClient(symbolClient);
            throw throwable;
        }
    }

    public static ObjectBundle getObjectBundle(SYMbolAPIClientV1 client) {
        ObjectBundle bundle = null;
        try {
            bundle = client.getObjectGraph();
        }
        catch (Exception e) {
            System.out.println("Error using the client connection.");
        }
        return bundle;
    }

    public static RLSResults getRLSData(SYMbolAPIClientV1 client) {
        RLSResults rlsResults = null;
        try {
            RLSCommand command = new RLSCommand(1);
            RLSCommandDescriptor rlsCommand = new RLSCommandDescriptor();
            rlsCommand.setCommand(command);
            rlsResults = client.getReadLinkStatus(rlsCommand);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rlsResults;
    }

    public static SYMbolAPIClientV1 getOpenConnection(Properties props) {
        SYMbolAPIClientV1 client = SYMbolConnection.getClient(props);
        return client;
    }

    public static SYMbolAPIClientV1 getOpenConnection(String ip) {
        SYMbolAPIClientV1 client = null;
        if (SYMbolConnection.serverIsResponding(ip)) {
            try {
                InetAddress inet = InetAddress.getByName(ip);
                client = new SYMbolAPIClientV1(inet, 2463, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return client;
    }

    public static void closeClient(SYMbolAPIClientV1 client) {
        if (client != null) {
            try {
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static SYMbolAPIClientV1 getClient(Properties props) {
        SYMbolAPIClientV1 client = null;
        String said = props.getProperty("said");
        boolean found = false;
        boolean saidMatch = false;
        ArrayList addresses = SYMbolConnection.getIPList(props);
        int x = 0;
        while (x < addresses.size()) {
            block13: {
                try {
                    String ip = (String)addresses.get(x);
                    if (SYMbolConnection.serverIsResponding(ip)) {
                        InetAddress inet = InetAddress.getByName(ip);
                        client = new SYMbolAPIClientV1(inet, 2463, true);
                        DiscoveryResponse response = client.discoverControllers();
                        AccessibleController[] allControllers = response.getControllers();
                        int c = 0;
                        while (c < allControllers.length) {
                            SAIdentifier arrayId = allControllers[c].getSaId();
                            String thisSaid = Utility.wwnString(arrayId.getWorldWideName());
                            if (thisSaid.equals(said)) {
                                saidMatch = true;
                                ControllerDescriptor descriptor = new ControllerDescriptor();
                                descriptor.setSaId(arrayId);
                                descriptor.setControllerRef(allControllers[c].getThisController());
                                ReturnCode rc = client.bindToController(descriptor);
                                if (rc.getValue() == 1) {
                                    found = true;
                                    break;
                                }
                            }
                            ++c;
                        }
                    }
                    if (found) break;
                    if (!saidMatch) {
                        System.out.println("Could not match the SAID for " + props.getProperty("name"));
                    }
                    if (client != null) {
                        try {
                            client.close();
                            client = null;
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Exception ex) {
                    if (client == null) break block13;
                    try {
                        client.close();
                        client = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            ++x;
        }
        return client;
    }

    private static boolean serverIsResponding(String ip) {
        boolean found = false;
        BroadCaster broadcast = new BroadCaster();
        Hashtable servers = broadcast.search(ip);
        if (servers.size() > 0) {
            Enumeration enumeration = servers.elements();
            while (enumeration.hasMoreElements()) {
                String address = (String)enumeration.nextElement();
            }
            found = true;
        }
        return found;
    }

    private static ArrayList getProxies(Properties p) {
        ArrayList<String> proxyList = new ArrayList<String>();
        String proxies = p.getProperty("proxys");
        if (proxies != null) {
            StringTokenizer tokens = new StringTokenizer(proxies, " |");
            while (tokens.hasMoreTokens()) {
                proxyList.add(tokens.nextToken());
            }
        }
        return proxyList;
    }

    private static ArrayList getIPList(Properties props) {
        ArrayList addresses = SYMbolConnection.getProxies(props);
        if (props.getProperty("altip") != null) {
            addresses.add(0, props.getProperty("altip"));
        }
        if (props.getProperty("ip") != null) {
            addresses.add(0, props.getProperty("ip"));
        }
        return addresses;
    }
}

