/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.jmx;

import com.sun.netstorage.fm.storade.agent.jmx.XMLCommunicatorServer;
import com.sun.netstorage.fm.storade.client.jmx.AgentConfig;
import com.sun.netstorage.fm.storade.client.jmx.AlarmQuery;
import com.sun.netstorage.fm.storade.client.jmx.DeviceMaintenance;
import com.sun.netstorage.fm.storade.client.jmx.LockManager;
import com.sun.netstorage.fm.storade.util.Environment;
import com.sun.netstorage.fm.util.Options;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class JMXServer {
    static boolean debug = false;
    private static IdleDieTimer timer;
    public static final String cvs_id = "$Id: JMXServer.java,v 1.9 2004/10/13 18:09:39 jkremer Exp $";

    public static void usage(int retcode) {
        System.out.println("JMX Server usage: [options]\nOptions:");
        System.out.println("\t-D Turn on debugging and html connector.");
        System.out.println("\t-R Enable RMI access.");
        System.out.println("\t-S Register StorADE services.");
        System.out.println("\t-i <seconds> Set idle time for server to die.");
        System.exit(retcode);
    }

    public static void dprint(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    public static void main(String[] args) {
        try {
            Options opts = new Options("?DRSi:p:U:P:");
            args = opts.parseOptions(args);
            if (opts.getFlagOption("?")) {
                JMXServer.usage(0);
            }
            int idleTime = opts.getIntOption("i", 0);
            debug = opts.getFlagOption("D");
            String user = opts.getOption("U");
            String pass = opts.getOption("P");
            int port = opts.getIntOption("p", Environment.getSOAPPort());
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            JMXServer.dprint("Create and start StorADE SOAP protocol.");
            ObjectName xmlName = new ObjectName("StorADE", "name", "XMLConnectorServer");
            XMLCommunicatorServer xmlServer = new XMLCommunicatorServer(port, user, pass);
            server.registerMBean((Object)xmlServer, xmlName);
            server.invoke(xmlName, "start", new Object[0], new String[0]);
            if (debug) {
                JMXServer.dprint("Create and start an HTML protocol adaptor");
                ObjectInstance html = server.createMBean("com.sun.jdmk.comm.HtmlAdaptorServer", null);
                server.invoke(html.getObjectName(), "start", new Object[0], new String[0]);
                System.out.println("\nCreate and start an HTTP connector server");
                ObjectInstance http = server.createMBean("com.sun.jdmk.comm.HttpConnectorServer", null);
                server.invoke(http.getObjectName(), "start", new Object[0], new String[0]);
            }
            if (opts.getFlagOption("R")) {
                JMXServer.dprint("Create and start an RMI connector server");
                ObjectInstance rmi = server.createMBean("com.sun.jdmk.comm.RmiConnectorServer", null);
                server.invoke(rmi.getObjectName(), "start", new Object[0], new String[0]);
            }
            if (opts.getFlagOption("S")) {
                URL agent = new URL("http://localhost:7654");
                server.registerMBean(new AgentConfig(agent, user, pass), new ObjectName("StorADE", "name", "AgentConfig"));
                server.registerMBean(new AlarmQuery(agent, user, pass), new ObjectName("StorADE", "name", "AlarmQuery"));
                server.registerMBean(new DeviceMaintenance(agent, user, pass), new ObjectName("StorADE", "name", "DeviceMaintenance"));
                server.registerMBean(new LockManager(agent, user, pass), new ObjectName("StorADE", "name", "LockManager"));
            }
            if (idleTime > 0) {
                timer = new IdleDieTimer(idleTime, xmlServer);
            }
        }
        catch (Throwable e) {
            System.err.println("JMXServer FAILURE:");
            e.printStackTrace();
            System.exit(-1);
            return;
        }
        JMXServer.dprint("Now, you can point your browser to http://localhost:8082/");
        JMXServer.dprint("or start your management application to connect to this agent.");
    }

    static {
        cvs_id = cvs_id;
    }

    private static class IdleDieTimer
    extends TimerTask {
        private long delay;
        private long startTime;
        private Timer timer;
        private XMLCommunicatorServer xmlServer;

        private IdleDieTimer(int interval, XMLCommunicatorServer xmlServer) {
            this.xmlServer = xmlServer;
            this.delay = (long)interval * 1000L;
            this.startTime = System.currentTimeMillis();
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate((TimerTask)this, this.delay, this.delay);
        }

        private long checkTime(int interval) {
            long now = System.currentTimeMillis();
            long lastProcessTime = this.xmlServer.getLastProcessTime();
            if (lastProcessTime <= 0L) {
                lastProcessTime = this.startTime;
            }
            long timeLeft = now - lastProcessTime;
            return this.delay - timeLeft;
        }

        public void run() {
            long timeSinceLastCommand;
            if (this.xmlServer.getRunningThreads() > 0) {
                return;
            }
            long now = System.currentTimeMillis();
            long lastProcessTime = this.xmlServer.getLastProcessTime();
            if (lastProcessTime <= 0L) {
                lastProcessTime = this.startTime;
            }
            if ((timeSinceLastCommand = now - lastProcessTime) > this.delay) {
                System.exit(0);
            }
        }
    }
}

