/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.jmx;

import com.sun.netstorage.fm.storade.agent.command.xml.SOAPCommandRunner;
import com.sun.netstorage.fm.storade.agent.command.xml.SOAPEncoder;
import com.sun.netstorage.fm.storade.agent.command.xml.SOAPMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class JMXCommandRunner
implements SOAPCommandRunner {
    private MBeanServer server;
    public static final String _SOURCE_REVISION = "$Revision: 1.3 $";
    static /* synthetic */ Class class$com$sun$netstorage$fm$storade$agent$command$xml$SOAPMessage;

    public JMXCommandRunner(MBeanServer server) {
        this.server = server;
    }

    public String getName() {
        return "/jmx";
    }

    public SOAPMessage exec(SOAPMessage request) {
        try {
            String cmd = request.getName();
            Class<?> thisClass = this.getClass();
            Method m = thisClass.getDeclaredMethod(cmd, class$com$sun$netstorage$fm$storade$agent$command$xml$SOAPMessage == null ? (class$com$sun$netstorage$fm$storade$agent$command$xml$SOAPMessage = JMXCommandRunner.class$("com.sun.netstorage.fm.storade.agent.command.xml.SOAPMessage")) : class$com$sun$netstorage$fm$storade$agent$command$xml$SOAPMessage);
            return (SOAPMessage)m.invoke((Object)this, request);
        }
        catch (Exception e) {
            Throwable error = e;
            if (e instanceof InvocationTargetException) {
                error = ((InvocationTargetException)e).getCause();
            }
            SOAPMessage emsg = new SOAPMessage(error);
            emsg.set("request", request.toString());
            return emsg;
        }
    }

    private SOAPMessage createMBean(SOAPMessage request) throws Exception {
        String className = request.getProperty("className");
        String name = request.getProperty("name");
        String loaderName = request.getProperty("loaderName");
        List params = request.getList("params");
        List signature = request.getList("signature");
        String[] sigs = JMXCommandRunner.parseStringArray(signature);
        ObjectInstance inst = this.server.createMBean(className, new ObjectName(name), new ObjectName(loaderName), JMXCommandRunner.decodeArgs(params, sigs), sigs);
        return new SOAPMessage("createMBeanReply", new String[]{"object", inst.getObjectName().toString(), "className", inst.getClassName()});
    }

    private SOAPMessage getAttribute(SOAPMessage request) throws Exception {
        String name = request.getProperty("name");
        String attribute = request.getProperty("attribute");
        ObjectName objName = new ObjectName(name);
        Object retObj = this.server.getAttribute(objName, attribute);
        HashMap<String, ObjEncoder> args = new HashMap<String, ObjEncoder>();
        args.put("object", new ObjEncoder(retObj));
        return new SOAPMessage("getAttributeReply", args);
    }

    private SOAPMessage getAttributes(SOAPMessage request) throws Exception {
        String name = request.getProperty("name");
        List attributes = request.getList("attributes");
        String[] objAttrib = JMXCommandRunner.parseStringArray(attributes);
        ObjectName objName = new ObjectName(name);
        AttributeList alist = this.server.getAttributes(objName, objAttrib);
        HashMap<String, AttributeListEncoder> args = new HashMap<String, AttributeListEncoder>();
        args.put("object", new AttributeListEncoder(alist));
        return new SOAPMessage("getAttributesReply", args);
    }

    private SOAPMessage getDefaultDomain(SOAPMessage request) throws Exception {
        return new SOAPMessage("getDefaultDomainReply", new String[]{"domain", this.server.getDefaultDomain()});
    }

    private SOAPMessage getMBeanCount(SOAPMessage request) throws Exception {
        return new SOAPMessage("getMBeanCountReply", new String[]{"count", this.server.getMBeanCount().toString()});
    }

    private SOAPMessage getMBeanInfo(SOAPMessage request) throws Exception {
        String name = request.getProperty("name");
        MBeanInfo mbinfo = this.server.getMBeanInfo(new ObjectName(name));
        HashMap<String, ObjEncoder> args = new HashMap<String, ObjEncoder>();
        args.put("MBeanInfo", new ObjEncoder(mbinfo));
        return new SOAPMessage("getMBeanInfoReply", args);
    }

    private SOAPMessage getObjectInstance(SOAPMessage request) throws Exception {
        String name = request.getProperty("name");
        ObjectName objName = new ObjectName(name);
        ObjectInstance objInst = this.server.getObjectInstance(objName);
        return new SOAPMessage("getObjectInstanceReply", new String[]{"object", objInst.getObjectName().toString(), "className", objInst.getClassName()});
    }

    private SOAPMessage invoke(SOAPMessage request) throws Exception {
        String name = request.getProperty("name");
        String operationName = request.getProperty("operationName");
        List params = request.getList("params");
        List signature = request.getList("signature");
        String[] sigs = JMXCommandRunner.parseStringArray(signature);
        Object retval = this.server.invoke(new ObjectName(name), operationName, JMXCommandRunner.decodeArgs(params, sigs), sigs);
        HashMap<String, ObjEncoder> args = new HashMap<String, ObjEncoder>();
        args.put("object", new ObjEncoder(retval));
        return new SOAPMessage("invokeReply", args);
    }

    private SOAPMessage isInstanceOf(SOAPMessage request) throws Exception {
        String name = request.getProperty("name");
        String className = request.getProperty("className");
        ObjectName objName = new ObjectName(name);
        boolean isInst = this.server.isInstanceOf(objName, className);
        SOAPMessage rmsg = new SOAPMessage("isInstanceOfReply", new String[]{"isInstance", isInst ? "TRUE" : "FALSE"});
        return rmsg;
    }

    private SOAPMessage isRegistered(SOAPMessage request) throws Exception {
        String name = request.getProperty("name");
        ObjectName objName = new ObjectName(name);
        boolean isReg = this.server.isRegistered(objName);
        SOAPMessage rmsg = new SOAPMessage("isRegisteredReply", new String[]{"isRegistered", isReg ? "TRUE" : "FALSE"});
        return rmsg;
    }

    private SOAPMessage queryMBeans(SOAPMessage request) throws Exception {
        return new SOAPMessage(new UnsupportedOperationException());
    }

    private SOAPMessage queryNames(SOAPMessage request) throws Exception {
        return new SOAPMessage(new UnsupportedOperationException());
    }

    private SOAPMessage setAttribute(SOAPMessage request) throws Exception {
        return new SOAPMessage(new UnsupportedOperationException());
    }

    private SOAPMessage setAttributes(SOAPMessage request) throws Exception {
        return new SOAPMessage(new UnsupportedOperationException());
    }

    private SOAPMessage unregisterMBean(SOAPMessage request) throws Exception {
        return new SOAPMessage(new UnsupportedOperationException());
    }

    private static Object[] decodeArgs(List args, String[] param) {
        if (args == null) {
            return new Object[0];
        }
        Object[] retArgs = new Object[args.size()];
        Iterator iter = args.iterator();
        int i = 0;
        while (i < retArgs.length) {
            retArgs[i] = JMXCommandRunner.decode((String)iter.next(), param[i]);
            ++i;
        }
        return retArgs;
    }

    private static Object decode(String obj, String param) {
        return obj;
    }

    private static String encode(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    private static String[] parseStringArray(List list) {
        if (list == null) {
            return new String[0];
        }
        String[] sarray = new String[list.size()];
        Iterator iter = list.iterator();
        int i = 0;
        while (i < sarray.length) {
            sarray[i] = (String)iter.next();
            ++i;
        }
        return sarray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _SOURCE_REVISION = _SOURCE_REVISION;
    }

    public static class AttributeListEncoder
    implements SOAPEncoder {
        private AttributeList alist;

        public AttributeListEncoder(AttributeList alist) {
            this.alist = alist;
        }

        public void encode(StringBuffer sb) {
            if (this.alist == null) {
                return;
            }
            sb.append("<AttributeList>");
            int i = 0;
            while (i < this.alist.size()) {
                Attribute att = (Attribute)this.alist.get(i);
                if (att != null) {
                    sb.append("<soap:Item><Attribute>");
                    sb.append("<name>" + att.getName() + "</name>");
                    sb.append("<value>" + JMXCommandRunner.encode(att.getValue()) + "</value>");
                    sb.append("</Attribute>/soap:Item>");
                }
                ++i;
            }
            sb.append("</AttributeList>\n");
        }
    }

    public static class ObjEncoder
    implements SOAPEncoder {
        private Object obj;

        public ObjEncoder(Object obj) {
            this.obj = obj;
        }

        public void encode(StringBuffer sb) {
            if (this.obj == null) {
                return;
            }
            sb.append(JMXCommandRunner.encode(this.obj));
        }
    }
}

