/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.helper;

import com.sun.netstorage.fm.storade.agent.AgentFactory;
import com.sun.netstorage.fm.storade.agent.catalog.Loader;
import com.sun.netstorage.fm.storade.agent.command.xml.SOAPEncoder;
import com.sun.netstorage.fm.storade.agent.command.xml.XMLUtil;
import com.sun.netstorage.fm.storade.resource.discovery.Probe;
import com.sun.netstorage.fm.storade.resource.discovery.ProbeResult;
import com.sun.netstorage.fm.storade.resource.message.LogMessage;
import com.sun.netstorage.fm.storade.resource.message.MessageList;
import com.sun.netstorage.fm.storade.resource.message.MessageProvider;
import com.sun.netstorage.fm.storade.resource.report.ReportClass;
import com.sun.netstorage.fm.storade.resource.report.ReportGenerator;
import com.sun.netstorage.fm.storade.util.StoradeDate;
import com.sun.netstorage.fm.util.PropertyList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DeviceHelper {
    public static final String _SOURCE_REVISION = "$Revision: 1.8 $";
    static /* synthetic */ Class class$com$sun$netstorage$fm$storade$resource$report$ReportGenerator;

    public static InstReport instrument(Map props) {
        ReportClass report = null;
        try {
            PropertyList device = new PropertyList(props);
            AgentFactory factory = new AgentFactory();
            ReportGenerator rgen = factory.getReportGenerator(device.getProperty("type"));
            if (rgen != null) {
                report = rgen.generateReport((Properties)device, "FULL");
            } else {
                Loader loader = new Loader(device.getProperty("type"));
                rgen = (ReportGenerator)loader.getJavaImpl((class$com$sun$netstorage$fm$storade$resource$report$ReportGenerator == null ? (class$com$sun$netstorage$fm$storade$resource$report$ReportGenerator = DeviceHelper.class$("com.sun.netstorage.fm.storade.resource.report.ReportGenerator")) : class$com$sun$netstorage$fm$storade$resource$report$ReportGenerator).getName());
                report = rgen.generateReport((Properties)device, "FULL");
            }
        }
        catch (Throwable error) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            error.printStackTrace(out);
            report = new ReportClass("error", "ReportGenerator");
            report.setProperty("_Type", "Defect");
            report.setProperty("_MessageID", "0");
            report.setProperty("_Time", new StoradeDate().toString());
            report.setProperty("_Environment", System.getProperty("java.runtime.version"));
            report.setProperty("_Source", "StorADE");
            report.setProperty("_Severity", "NOTICE");
            report.setProperty("_Description", error.toString());
            report.setProperty("_Cause", sw.toString());
        }
        return new InstReport(report);
    }

    public static String getMarker(Map props) {
        AgentFactory af = new AgentFactory();
        PropertyList device = new PropertyList(props);
        MessageProvider mp = (MessageProvider)af.getManagedResourceInterface(device.getProperty("type"), "MessageProvider");
        if (mp == null) {
            return null;
        }
        return mp.getCurrentMarker((Properties)device);
    }

    public static HelperMessageList getMessages(String marker, Map props) {
        AgentFactory af = new AgentFactory();
        PropertyList device = new PropertyList(props);
        MessageProvider mp = (MessageProvider)af.getManagedResourceInterface(device.getProperty("type"), "MessageProvider");
        if (mp == null) {
            return new HelperMessageList(null);
        }
        return new HelperMessageList(mp.getNewMessages(marker, (Properties)device));
    }

    public static DiscoverResult discover(String type, Map props) {
        AgentFactory af = new AgentFactory();
        Probe probe = af.getProbe(type);
        PropertyList discoProps = new PropertyList(props);
        return new DiscoverResult(probe.probe((Properties)discoProps));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _SOURCE_REVISION = _SOURCE_REVISION;
    }

    public static class DiscoverResult
    implements SOAPEncoder {
        private ProbeResult pr;

        public DiscoverResult(ProbeResult pr) {
            this.pr = pr;
        }

        public void encode(StringBuffer sb) {
            if (this.pr == null) {
                return;
            }
            Properties[] devs = this.pr.getDiscoveredProperties();
            String status = this.pr.getStatus();
            String msg = this.pr.getLocalizedMessage();
            sb.append("<status>" + status + "</status>");
            sb.append("<message>");
            sb.append(msg);
            sb.append("</message>");
            sb.append("<devices>");
            int i = 0;
            while (i < devs.length) {
                sb.append("<soap:Item>");
                Properties map = devs[i];
                if (map != null) {
                    Set s = map.entrySet();
                    Iterator eiter = s.iterator();
                    while (eiter.hasNext()) {
                        Map.Entry entry = eiter.next();
                        sb.append("<");
                        sb.append((String)entry.getKey());
                        sb.append(">");
                        sb.append(XMLUtil.encodeToXML((String)entry.getValue()));
                        sb.append("</");
                        sb.append((String)entry.getKey());
                        sb.append(">");
                    }
                }
                sb.append("</soap:Item>");
                sb.append("</devices>");
                ++i;
            }
        }
    }

    public static class HelperMessageList
    implements SOAPEncoder {
        private MessageList ml;

        public HelperMessageList(MessageList ml) {
            this.ml = ml;
        }

        public void encode(StringBuffer sb) {
            if (this.ml == null) {
                return;
            }
            sb.append("<marker>" + this.ml.getMarker() + "</marker>\n");
            LogMessage[] msgs = this.ml.getMessages();
            if (msgs != null && msgs.length > 0) {
                sb.append("<messages>\n");
                int i = 0;
                while (i < msgs.length) {
                    LogMessage msg = msgs[i];
                    if (msg != null) {
                        sb.append("<soap:Item>");
                        sb.append("<line>");
                        sb.append(XMLUtil.encodeToXML(msg.toString()));
                        sb.append("</line><component>");
                        sb.append(XMLUtil.encodeToXML(msg.getComponent()));
                        sb.append("</component></soap:Item>\n");
                    }
                    ++i;
                }
                sb.append("</messages>\n");
            }
        }
    }

    public static class InstReport
    implements SOAPEncoder {
        private ReportClass rc;

        public InstReport(ReportClass rc) {
            this.rc = rc;
        }

        public void encode(StringBuffer sb) {
            if (this.rc == null) {
                return;
            }
            String[] nvlist = this.rc.toNameValueList();
            int mlen = nvlist.length - 1;
            int i = 0;
            while (i < mlen) {
                String name = nvlist[i];
                sb.append("<" + name + ">");
                sb.append(XMLUtil.encodeToXML(nvlist[i + 1]));
                sb.append("</" + name + ">");
                i += 2;
            }
        }
    }
}

