/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.command.xml;

import com.sun.netstorage.fm.storade.agent.command.xml.SOAPEncoder;
import com.sun.netstorage.fm.storade.agent.command.xml.XMLUtil;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class SOAPMessage {
    private String bodyName;
    private Map args = new Hashtable();
    private String faultCode;
    private String faultString;
    private String faultActor;
    private static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    private static final String SOAP_ENVELOPE = "soap:Envelope";
    private static final String SOAP_ENVELOPE_OPEN = "<soap:Envelope\nxmlns:soap=\"http://www.w3.org/2001/12/soap-envelope\"\nsoap:encodingStyle=\"http://www.w3.org/2001/12/soap-encoding\">\n";
    private static final String SOAP_ENVELOPE_CLOSE = "</soap:Envelope>";
    private static final String SOAP_BODY = "soap:Body";
    private static final String SOAP_BODY_OPEN = "<soap:Body>";
    private static final String SOAP_BODY_CLOSE = "</soap:Body>";
    private static final String SOAP_FAULT = "soap:Fault";
    private static final String SOAP_FAULT_OPEN = "<soap:Fault>";
    private static final String SOAP_FAULT_CLOSE = "</soap:Fault>";
    private static final String SOAP_ITEM = "soap:Item";
    private static final String SA_OPEN = "<";
    private static final String SA_CLOSE = "</";
    private static final String CLOSE = ">";
    private static final String CLOSE_LINE = ">\n";
    public static final String _SOURCE_REVISION = "$Revision: 1.4 $";

    public SOAPMessage(String name, Map args) {
        this.bodyName = name;
        this.args = args;
    }

    public SOAPMessage(String name, String[] nvpairs) {
        this.bodyName = name;
        this.args = new HashMap();
        if (nvpairs != null) {
            int i = 0;
            while (i < nvpairs.length - 1) {
                this.args.put(nvpairs[i], nvpairs[i + 1]);
                i += 2;
            }
        }
    }

    public SOAPMessage(String name) {
        this.bodyName = name;
        this.args = new HashMap();
    }

    public SOAPMessage(Throwable error) {
        this.bodyName = SOAP_FAULT;
        this.setFault(error);
    }

    private SOAPMessage() {
    }

    public static SOAPMessage parseXML(String doc) {
        try {
            SOAPMessage msg = new SOAPMessage();
            Node soap = XMLUtil.getNode(doc);
            msg.parseSoap(soap);
            return msg;
        }
        catch (SAXParseException se) {
            System.out.println("Parse error at line " + se.getLineNumber() + ":" + se.getColumnNumber());
            throw new IllegalArgumentException(se.getMessage());
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static SOAPMessage parseXML(Reader doc) {
        try {
            SOAPMessage msg = new SOAPMessage();
            Node soap = XMLUtil.getNode(doc);
            msg.parseSoap(soap);
            return msg;
        }
        catch (SAXParseException se) {
            System.out.println("Parse error at line " + se.getLineNumber() + ":" + se.getColumnNumber());
            throw new IllegalArgumentException(se.getMessage());
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(XML_HEADER);
        sb.append("\n");
        sb.append(SOAP_ENVELOPE_OPEN);
        sb.append(SOAP_BODY_OPEN);
        sb.append("\n");
        if (this.faultCode == null) {
            sb.append(SA_OPEN + this.bodyName + CLOSE_LINE);
            this.printMap(this.args, sb);
            sb.append(SA_CLOSE + this.bodyName + CLOSE_LINE);
        } else {
            this.printFault(this.args, sb);
        }
        sb.append(SOAP_BODY_CLOSE);
        sb.append(SOAP_ENVELOPE_CLOSE);
        return sb.toString();
    }

    public String getName() {
        return this.bodyName;
    }

    public String getProperty(String name) {
        Object value = this.args.get(name);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Object[] getArray(String name) {
        Object value = this.args.get(name);
        if (value == null) {
            return new Object[0];
        }
        if (value instanceof List) {
            Object[] array = new Object[((List)value).size()];
            Iterator iter = ((List)value).iterator();
            int i = 0;
            while (i < array.length) {
                array[i] = iter.next();
                ++i;
            }
            return array;
        }
        return new Object[]{value};
    }

    public List getList(String name) {
        Object value = this.args.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        LinkedList list = new LinkedList();
        list.add(value);
        return list;
    }

    public int getNumItems(String name) {
        Object value = this.args.get(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof List) {
            return ((List)value).size();
        }
        return 1;
    }

    public Object get(String name) {
        return this.args.get(name);
    }

    public Object get(String name, int index) {
        Object value = this.args.get(name);
        if (value == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (value instanceof List) {
            return ((List)value).get(index);
        }
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return value;
    }

    public void setProperty(String name, String value) {
        this.args.put(name, value);
    }

    public void set(String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Map || value instanceof List || value instanceof SOAPEncoder) {
            this.args.put(name, value);
        } else {
            this.args.put(name, value.toString());
        }
    }

    public void setArray(String name, Object value) {
        LinkedList<Object> list = (LinkedList<Object>)this.args.get(name);
        if (list == null) {
            list = new LinkedList<Object>();
            this.args.put(name, list);
        }
        list.add(value);
    }

    private void printValue(String key, Object value, StringBuffer sb) {
        if (key == null || value == null) {
            return;
        }
        if (value instanceof SOAPEncoder) {
            sb.append(SA_OPEN + key + CLOSE);
            ((SOAPEncoder)value).encode(sb);
            sb.append(SA_CLOSE + key + CLOSE_LINE);
        } else if (value instanceof List) {
            this.printList(key, (List)value, sb);
        } else if (value instanceof Map) {
            sb.append(SA_OPEN + key + CLOSE);
            this.printMap((Map)value, sb);
            sb.append(SA_CLOSE + key + CLOSE_LINE);
        } else {
            sb.append(SA_OPEN + key + CLOSE);
            XMLUtil.encodeXML(value.toString(), sb);
            sb.append(SA_CLOSE + key + CLOSE_LINE);
        }
    }

    private void printMap(Map map, StringBuffer sb) {
        if (map == null) {
            return;
        }
        Set s = map.entrySet();
        Iterator eiter = s.iterator();
        while (eiter.hasNext()) {
            Map.Entry entry = eiter.next();
            this.printValue((String)entry.getKey(), entry.getValue(), sb);
        }
    }

    private void printList(String key, List list, StringBuffer sb) {
        if (list == null) {
            return;
        }
        Iterator iter = list.iterator();
        sb.append(SA_OPEN + key + CLOSE);
        while (iter.hasNext()) {
            this.printValue(SOAP_ITEM, iter.next(), sb);
        }
        sb.append(SA_CLOSE + key + CLOSE_LINE);
    }

    private void printFault(Map map, StringBuffer out) {
        out.append(SOAP_FAULT_OPEN);
        out.append("\n<faultcode>");
        XMLUtil.encodeXML(this.faultCode, out);
        out.append("</faultcode>");
        out.append("\n<faultactor>");
        XMLUtil.encodeXML(this.faultActor, out);
        out.append("</faultactor>");
        out.append("\n<faultdetail>");
        this.printMap(map, out);
        out.append("\n</faultdetail>\n");
        out.append(SOAP_FAULT_CLOSE);
    }

    public void setFault(String faultCode, String faultString, String faultActor) {
        this.faultCode = faultCode;
        this.faultString = faultString;
        this.faultActor = faultActor;
    }

    public synchronized void setFault(Throwable error) {
        this.faultCode = "Server.exception";
        this.faultString = error.getMessage();
        this.faultActor = "StorADE";
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter(sout);
        error.printStackTrace(out);
        this.args = new HashMap();
        this.args.put("error", error.toString());
        this.args.put("trace", sout.toString());
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    private void parseSoap(Node soap) {
        NodeList children;
        if (soap != null && soap.getNodeType() == 1 && SOAP_ENVELOPE.equals(soap.getNodeName()) && (children = soap.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node cnode = children.item(i);
                if (cnode.getNodeType() == 1 && SOAP_BODY.equals(cnode.getNodeName())) {
                    this.parseBody(cnode);
                }
                ++i;
            }
        }
    }

    private void parseBody(Node node) {
        NodeList cmds = node.getChildNodes();
        if (cmds != null) {
            int i = 0;
            while (i < cmds.getLength()) {
                Node cmd = cmds.item(i);
                if (cmd.getNodeType() == 1) {
                    this.bodyName = SOAPMessage.baseName(cmd.getNodeName());
                    NodeList children = cmd.getChildNodes();
                    this.args = new Hashtable();
                    int j = 0;
                    while (j < children.getLength()) {
                        Node n = children.item(j);
                        Object o = this.parseObject(n);
                        if (o != null) {
                            this.args.put(SOAPMessage.getKey(n), o);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private Object parseObject(Node node) {
        if (node.getNodeType() != 1) {
            return null;
        }
        boolean substruct = false;
        boolean array = false;
        NodeList clist = node.getChildNodes();
        if (clist.getLength() > 0) {
            int i = 0;
            while (i < clist.getLength()) {
                if (clist.item(i).getNodeType() == 1) {
                    if (SOAP_ITEM.equals(clist.item(i).getNodeName())) {
                        array = true;
                        break;
                    }
                    substruct = true;
                    break;
                }
                ++i;
            }
        }
        if (substruct) {
            Hashtable<String, Object> submap = new Hashtable<String, Object>();
            int j = 0;
            while (j < clist.getLength()) {
                Node n = clist.item(j);
                Object o = this.parseObject(n);
                if (o != null) {
                    submap.put(SOAPMessage.getKey(n), this.parseObject(n));
                }
                ++j;
            }
            return submap;
        }
        if (array) {
            LinkedList<Object> list = new LinkedList<Object>();
            int j = 0;
            while (j < clist.getLength()) {
                Object o = this.parseObject(clist.item(j));
                if (o != null) {
                    list.add(o);
                }
                ++j;
            }
            return list;
        }
        return XMLUtil.getCdata(node);
    }

    private static String getKey(Node node) {
        return node.getNodeName();
    }

    private static String baseName(String nname) {
        int index;
        if (nname != null && (index = nname.indexOf(":")) > 0 && nname.length() > index + 1) {
            return nname.substring(index + 1);
        }
        return nname;
    }

    static {
        XML_HEADER = XML_HEADER;
        SOAP_ENVELOPE = SOAP_ENVELOPE;
        SOAP_ENVELOPE_OPEN = SOAP_ENVELOPE_OPEN;
        SOAP_ENVELOPE_CLOSE = SOAP_ENVELOPE_CLOSE;
        SOAP_BODY = SOAP_BODY;
        SOAP_BODY_OPEN = SOAP_BODY_OPEN;
        SOAP_BODY_CLOSE = SOAP_BODY_CLOSE;
        SOAP_FAULT = SOAP_FAULT;
        SOAP_FAULT_OPEN = SOAP_FAULT_OPEN;
        SOAP_FAULT_CLOSE = SOAP_FAULT_CLOSE;
        SOAP_ITEM = SOAP_ITEM;
        SA_OPEN = SA_OPEN;
        SA_CLOSE = SA_CLOSE;
        CLOSE = CLOSE;
        CLOSE_LINE = CLOSE_LINE;
        _SOURCE_REVISION = _SOURCE_REVISION;
    }
}

