/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.command;

import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadPool {
    private static ThreadPool mainPool;
    private HandlerList handlers = new HandlerList();
    private Object run_lock = new Object();
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long IDLE_TIME_INTERVAL = 1200000L;
    private static final int MAX_THREADS = 150;
    private static Logger logger;
    public static final String _SOURCE_REVISION = "$Revision: 1.2 $";

    public static ThreadPool getThreadPool() {
        if (mainPool == null) {
            mainPool = new ThreadPool();
        }
        return mainPool;
    }

    private ThreadPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread runJob(Runnable job) {
        Handler handler = this.handlers.getHandler();
        Object object = this.run_lock;
        synchronized (object) {
            handler.runJob(job);
            Handler handler2 = handler;
            return handler2;
        }
    }

    static {
        MILLIS_PER_MINUTE = 60000L;
        IDLE_TIME_INTERVAL = 1200000L;
        MAX_THREADS = 150;
        logger = Logger.getLogger("com.sun.netstorage.fm.storade.agent.jmx");
        _SOURCE_REVISION = _SOURCE_REVISION;
    }

    private class HandlerList {
        private LinkedList list = new LinkedList();
        private LinkedList active = new LinkedList();
        private long idleTime = System.currentTimeMillis();
        private int numIdle;

        private HandlerList() {
        }

        synchronized Handler getHandler() {
            if (this.list.size() == 0) {
                if (this.active.size() < 150) {
                    Handler handler = new Handler();
                    handler.start();
                    this.active.add(handler);
                    return handler;
                }
                logger.log(Level.WARNING, "Too many threads.  Job must wait.");
            }
            while (this.list.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            Handler h = (Handler)this.list.removeFirst();
            this.active.add(h);
            return h;
        }

        synchronized void returnHandler(Handler h) {
            if (this.active.remove(h)) {
                this.list.add(h);
                this.notifyAll();
            }
            this.checkIdle();
        }

        synchronized void removeHandler(Handler h) {
            this.active.remove(h);
            h.shutdown();
        }

        void checkIdle() {
            long curTime = System.currentTimeMillis();
            int curIdle = this.list.size();
            if (curIdle == 0) {
                this.idleTime = curTime;
                return;
            }
            if (curIdle < this.numIdle) {
                this.idleTime = curTime;
                this.numIdle = curIdle;
                return;
            }
            long difTime = curTime - this.idleTime;
            if (difTime > 1200000L) {
                logger.log(Level.FINE, "ThreadPool cleaning unused threads #" + curIdle);
                int i = 0;
                while (i < curIdle) {
                    this.removeHandler(this.getHandler());
                    ++i;
                }
                curIdle = 0;
                this.idleTime = curTime;
            }
        }
    }

    private class Handler
    extends Thread {
        Runnable job;
        boolean abort;

        private Handler() {
        }

        synchronized boolean runJob(Runnable inJob) {
            if (this.job != null) {
                return false;
            }
            if (this.abort) {
                this.notify();
                return false;
            }
            this.job = inJob;
            this.notify();
            return true;
        }

        synchronized Runnable getJob() {
            this.setName("ThreadPool-Wait");
            while (this.job == null) {
                if (this.abort) {
                    return null;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.setName("ThreadPool-Job:" + this.job);
            return this.job;
        }

        synchronized void shutdown() {
            this.abort = true;
            this.notify();
        }

        public void run() {
            while (!this.abort) {
                try {
                    this.getJob();
                    if (this.job == null) continue;
                    this.job.run();
                    this.cleanup();
                }
                catch (OutOfMemoryError oome) {
                    if (this.job != null) {
                        this.cleanup();
                    }
                    logger.log(Level.WARNING, "Error running " + this.job, oome);
                }
                catch (Throwable t) {
                    if (this.job != null) {
                        this.cleanup();
                    }
                    logger.log(Level.WARNING, "Error running " + this.job, t);
                }
            }
        }

        private synchronized void cleanup() {
            this.job = null;
            ThreadPool.this.handlers.returnHandler(this);
        }
    }
}

