/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.command;

import com.sun.netstorage.fm.storade.agent.command.CommandServerMBean;
import com.sun.netstorage.fm.storade.agent.command.xml.XMLCommandHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class CommandServer
implements CommandServerMBean {
    private int port;
    private String user;
    private String credential;
    IPServer server;
    public static final String _SOURCE_REVISION = "$Revision: 1.1 $";

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public synchronized void start() {
        if (this.server == null) {
            this.server = new IPServer();
            this.server.start();
        }
    }

    public synchronized void restart() {
        this.shutdown();
        this.start();
    }

    public synchronized void shutdown() {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
        }
    }

    static {
        _SOURCE_REVISION = _SOURCE_REVISION;
    }

    private class IPServer
    extends Thread {
        private boolean running;
        private Throwable error;
        private ServerSocket ipserver;

        private IPServer() {
        }

        public void run() {
            try {
                this.ipserver = new ServerSocket(CommandServer.this.port);
                this.running = true;
                XMLCommandHandler ch = new XMLCommandHandler(null, CommandServer.this.user, CommandServer.this.credential);
                while (this.running) {
                    Socket connection = this.ipserver.accept();
                    ch.handleRequest(connection);
                }
            }
            catch (Throwable t) {
                this.running = false;
                this.error = t;
            }
        }

        public synchronized void shutdown() {
            if (this.running) {
                this.running = false;
                try {
                    this.ipserver.close();
                }
                catch (IOException ioe) {
                    this.error = ioe;
                }
            }
        }
    }
}

