/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0910api01.symbol;

import devmgr.v0910api01.jrpc.RPCError;
import devmgr.v0910api01.jrpc.XDRInputStream;
import devmgr.v0910api01.jrpc.XDROutputStream;
import devmgr.v0910api01.jrpc.XDRType;
import devmgr.v0910api01.symbol.SYMbolAPIConstants;
import devmgr.v0910api01.symbol.VolumeUsage;

public class VolumeUsageHint
implements XDRType,
SYMbolAPIConstants {
    private VolumeUsage usageHint = new VolumeUsage();
    private int segmentSize;
    private int readAhead;

    public VolumeUsageHint() {
    }

    public VolumeUsageHint(VolumeUsageHint volumeUsageHint) {
        this.usageHint = volumeUsageHint.usageHint;
        this.segmentSize = volumeUsageHint.segmentSize;
        this.readAhead = volumeUsageHint.readAhead;
    }

    public int getReadAhead() {
        return this.readAhead;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public VolumeUsage getUsageHint() {
        return this.usageHint;
    }

    public void setReadAhead(int n) {
        this.readAhead = n;
    }

    public void setSegmentSize(int n) {
        this.segmentSize = n;
    }

    public void setUsageHint(VolumeUsage volumeUsage) {
        this.usageHint = volumeUsage;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.usageHint.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.segmentSize = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.readAhead = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.usageHint.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.segmentSize);
        xDROutputStream.putInt(this.readAhead);
        xDROutputStream.setLength(n);
    }
}

