/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0910api01.symbol;

import devmgr.v0910api01.jrpc.RPCError;
import devmgr.v0910api01.jrpc.XDRInputStream;
import devmgr.v0910api01.jrpc.XDROutputStream;
import devmgr.v0910api01.jrpc.XDRType;
import devmgr.v0910api01.symbol.RAIDLevel;
import devmgr.v0910api01.symbol.SYMbolAPIConstants;
import devmgr.v0910api01.symbol.VolumeGroupRef;

public class VolumeGroup
implements XDRType,
SYMbolAPIConstants {
    private int sequenceNum;
    private boolean offline;
    private RAIDLevel raidLevel = new RAIDLevel();
    private byte[] worldWideName;
    private VolumeGroupRef volumeGroupRef = new VolumeGroupRef();
    private byte[] reserved1;
    private byte[] reserved2;
    private boolean trayLossProtection;

    public VolumeGroup() {
    }

    public VolumeGroup(VolumeGroup volumeGroup) {
        this.sequenceNum = volumeGroup.sequenceNum;
        this.offline = volumeGroup.offline;
        this.raidLevel = volumeGroup.raidLevel;
        this.worldWideName = volumeGroup.worldWideName;
        this.volumeGroupRef = volumeGroup.volumeGroupRef;
        this.reserved1 = volumeGroup.reserved1;
        this.reserved2 = volumeGroup.reserved2;
        this.trayLossProtection = volumeGroup.trayLossProtection;
    }

    public boolean getOffline() {
        return this.offline;
    }

    public RAIDLevel getRaidLevel() {
        return this.raidLevel;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public int getSequenceNum() {
        return this.sequenceNum;
    }

    public boolean getTrayLossProtection() {
        return this.trayLossProtection;
    }

    public VolumeGroupRef getVolumeGroupRef() {
        return this.volumeGroupRef;
    }

    public byte[] getWorldWideName() {
        return this.worldWideName;
    }

    public void setOffline(boolean bl) {
        this.offline = bl;
    }

    public void setRaidLevel(RAIDLevel rAIDLevel) {
        this.raidLevel = rAIDLevel;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void setSequenceNum(int n) {
        this.sequenceNum = n;
    }

    public void setTrayLossProtection(boolean bl) {
        this.trayLossProtection = bl;
    }

    public void setVolumeGroupRef(VolumeGroupRef volumeGroupRef) {
        this.volumeGroupRef = volumeGroupRef;
    }

    public void setWorldWideName(byte[] byArray) {
        this.worldWideName = byArray;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.sequenceNum = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.offline = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.raidLevel.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.worldWideName = xDRInputStream.getVariableOpaque();
        }
        if (xDRInputStream.getPosition() < n) {
            this.volumeGroupRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(12);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        if (xDRInputStream.getPosition() < n) {
            this.trayLossProtection = xDRInputStream.getBoolean();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.sequenceNum);
        xDROutputStream.putBoolean(this.offline);
        this.raidLevel.xdrEncode(xDROutputStream);
        xDROutputStream.putVariableOpaque(this.worldWideName);
        this.volumeGroupRef.xdrEncode(xDROutputStream);
        xDROutputStream.putFixedOpaque(this.reserved1, 12);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.putBoolean(this.trayLossProtection);
        xDROutputStream.setLength(n);
    }
}

