/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0910api01.symbol;

import devmgr.v0910api01.jrpc.RPCError;
import devmgr.v0910api01.jrpc.XDRInputStream;
import devmgr.v0910api01.jrpc.XDROutputStream;
import devmgr.v0910api01.jrpc.XDRType;
import devmgr.v0910api01.symbol.SYMbolAPIConstants;

public class StagedFirmware
implements XDRType,
SYMbolAPIConstants {
    private boolean stagedFwValid;
    private byte[] fwVersion;
    private byte[] appVersion;
    private byte[] bootVersion;
    private byte[] nvsramVersion;
    private long timeStamp;

    public StagedFirmware() {
    }

    public StagedFirmware(StagedFirmware stagedFirmware) {
        this.stagedFwValid = stagedFirmware.stagedFwValid;
        this.fwVersion = stagedFirmware.fwVersion;
        this.appVersion = stagedFirmware.appVersion;
        this.bootVersion = stagedFirmware.bootVersion;
        this.nvsramVersion = stagedFirmware.nvsramVersion;
        this.timeStamp = stagedFirmware.timeStamp;
    }

    public byte[] getAppVersion() {
        return this.appVersion;
    }

    public byte[] getBootVersion() {
        return this.bootVersion;
    }

    public byte[] getFwVersion() {
        return this.fwVersion;
    }

    public byte[] getNvsramVersion() {
        return this.nvsramVersion;
    }

    public boolean getStagedFwValid() {
        return this.stagedFwValid;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setAppVersion(byte[] byArray) {
        this.appVersion = byArray;
    }

    public void setBootVersion(byte[] byArray) {
        this.bootVersion = byArray;
    }

    public void setFwVersion(byte[] byArray) {
        this.fwVersion = byArray;
    }

    public void setNvsramVersion(byte[] byArray) {
        this.nvsramVersion = byArray;
    }

    public void setStagedFwValid(boolean bl) {
        this.stagedFwValid = bl;
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.stagedFwValid = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.fwVersion = xDRInputStream.getFixedOpaque(4);
        }
        if (xDRInputStream.getPosition() < n) {
            this.appVersion = xDRInputStream.getFixedOpaque(4);
        }
        if (xDRInputStream.getPosition() < n) {
            this.bootVersion = xDRInputStream.getFixedOpaque(4);
        }
        if (xDRInputStream.getPosition() < n) {
            this.nvsramVersion = xDRInputStream.getFixedOpaque(17);
        }
        if (xDRInputStream.getPosition() < n) {
            this.timeStamp = xDRInputStream.getLong();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putBoolean(this.stagedFwValid);
        xDROutputStream.putFixedOpaque(this.fwVersion, 4);
        xDROutputStream.putFixedOpaque(this.appVersion, 4);
        xDROutputStream.putFixedOpaque(this.bootVersion, 4);
        xDROutputStream.putFixedOpaque(this.nvsramVersion, 17);
        xDROutputStream.putLong(this.timeStamp);
        xDROutputStream.setLength(n);
    }
}

