/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0910api01.symbol;

import devmgr.v0910api01.jrpc.RPCError;
import devmgr.v0910api01.jrpc.XDRInputStream;
import devmgr.v0910api01.jrpc.XDROutputStream;
import devmgr.v0910api01.jrpc.XDRType;
import devmgr.v0910api01.symbol.RepositoryFullPolicy;
import devmgr.v0910api01.symbol.SYMbolAPIConstants;
import devmgr.v0910api01.symbol.SnapshotRef;

public class SnapshotParamsUpdateDescriptor
implements XDRType,
SYMbolAPIConstants {
    private SnapshotRef snapRef = new SnapshotRef();
    private int warnThreshold;
    private long extentStart;
    private long extentSize;
    private RepositoryFullPolicy repFullPolicy = new RepositoryFullPolicy();
    private int rollbackPriority;

    public SnapshotParamsUpdateDescriptor() {
    }

    public SnapshotParamsUpdateDescriptor(SnapshotParamsUpdateDescriptor snapshotParamsUpdateDescriptor) {
        this.snapRef = snapshotParamsUpdateDescriptor.snapRef;
        this.warnThreshold = snapshotParamsUpdateDescriptor.warnThreshold;
        this.extentStart = snapshotParamsUpdateDescriptor.extentStart;
        this.extentSize = snapshotParamsUpdateDescriptor.extentSize;
        this.repFullPolicy = snapshotParamsUpdateDescriptor.repFullPolicy;
        this.rollbackPriority = snapshotParamsUpdateDescriptor.rollbackPriority;
    }

    public long getExtentSize() {
        return this.extentSize;
    }

    public long getExtentStart() {
        return this.extentStart;
    }

    public RepositoryFullPolicy getRepFullPolicy() {
        return this.repFullPolicy;
    }

    public int getRollbackPriority() {
        return this.rollbackPriority;
    }

    public SnapshotRef getSnapRef() {
        return this.snapRef;
    }

    public int getWarnThreshold() {
        return this.warnThreshold;
    }

    public void setExtentSize(long l) {
        this.extentSize = l;
    }

    public void setExtentStart(long l) {
        this.extentStart = l;
    }

    public void setRepFullPolicy(RepositoryFullPolicy repositoryFullPolicy) {
        this.repFullPolicy = repositoryFullPolicy;
    }

    public void setRollbackPriority(int n) {
        this.rollbackPriority = n;
    }

    public void setSnapRef(SnapshotRef snapshotRef) {
        this.snapRef = snapshotRef;
    }

    public void setWarnThreshold(int n) {
        this.warnThreshold = n;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.snapRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.warnThreshold = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.extentStart = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.extentSize = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.repFullPolicy.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.rollbackPriority = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.snapRef.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.warnThreshold);
        xDROutputStream.putLong(this.extentStart);
        xDROutputStream.putLong(this.extentSize);
        this.repFullPolicy.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.rollbackPriority);
        xDROutputStream.setLength(n);
    }
}

