/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0910api01.symbol;

import devmgr.v0910api01.jrpc.RPCError;
import devmgr.v0910api01.jrpc.XDRInputStream;
import devmgr.v0910api01.jrpc.XDROutputStream;
import devmgr.v0910api01.jrpc.XDRType;
import devmgr.v0910api01.symbol.SYMbolAPIConstants;

public class PKCS5EncryptionData
implements XDRType,
SYMbolAPIConstants {
    private int iterations;
    private byte[] salt;
    private byte[] cipherText;

    public PKCS5EncryptionData() {
    }

    public PKCS5EncryptionData(PKCS5EncryptionData pKCS5EncryptionData) {
        this.iterations = pKCS5EncryptionData.iterations;
        this.salt = pKCS5EncryptionData.salt;
        this.cipherText = pKCS5EncryptionData.cipherText;
    }

    public byte[] getCipherText() {
        return this.cipherText;
    }

    public int getIterations() {
        return this.iterations;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setCipherText(byte[] byArray) {
        this.cipherText = byArray;
    }

    public void setIterations(int n) {
        this.iterations = n;
    }

    public void setSalt(byte[] byArray) {
        this.salt = byArray;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.iterations = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.salt = xDRInputStream.getFixedOpaque(8);
        }
        if (xDRInputStream.getPosition() < n) {
            this.cipherText = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.iterations);
        xDROutputStream.putFixedOpaque(this.salt, 8);
        xDROutputStream.putVariableOpaque(this.cipherText);
        xDROutputStream.setLength(n);
    }
}

