/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0910api01.symbol;

import devmgr.v0910api01.jrpc.RPCError;
import devmgr.v0910api01.jrpc.XDRInputStream;
import devmgr.v0910api01.jrpc.XDROutputStream;
import devmgr.v0910api01.jrpc.XDRType;
import devmgr.v0910api01.symbol.FreeExtentRef;
import devmgr.v0910api01.symbol.RAIDLevel;
import devmgr.v0910api01.symbol.SYMbolAPIConstants;
import devmgr.v0910api01.symbol.VolumeGroupRef;

public class FreeExtent
implements XDRType,
SYMbolAPIConstants {
    private long sectorOffset;
    private long rawCapacity;
    private RAIDLevel raidLevel = new RAIDLevel();
    private VolumeGroupRef volumeGroupRef = new VolumeGroupRef();
    private FreeExtentRef freeExtentRef = new FreeExtentRef();
    private byte[] reserved1;
    private byte[] reserved2;

    public FreeExtent() {
    }

    public FreeExtent(FreeExtent freeExtent) {
        this.sectorOffset = freeExtent.sectorOffset;
        this.rawCapacity = freeExtent.rawCapacity;
        this.raidLevel = freeExtent.raidLevel;
        this.volumeGroupRef = freeExtent.volumeGroupRef;
        this.freeExtentRef = freeExtent.freeExtentRef;
        this.reserved1 = freeExtent.reserved1;
        this.reserved2 = freeExtent.reserved2;
    }

    public FreeExtentRef getFreeExtentRef() {
        return this.freeExtentRef;
    }

    public RAIDLevel getRaidLevel() {
        return this.raidLevel;
    }

    public long getRawCapacity() {
        return this.rawCapacity;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public long getSectorOffset() {
        return this.sectorOffset;
    }

    public VolumeGroupRef getVolumeGroupRef() {
        return this.volumeGroupRef;
    }

    public void setFreeExtentRef(FreeExtentRef freeExtentRef) {
        this.freeExtentRef = freeExtentRef;
    }

    public void setRaidLevel(RAIDLevel rAIDLevel) {
        this.raidLevel = rAIDLevel;
    }

    public void setRawCapacity(long l) {
        this.rawCapacity = l;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void setSectorOffset(long l) {
        this.sectorOffset = l;
    }

    public void setVolumeGroupRef(VolumeGroupRef volumeGroupRef) {
        this.volumeGroupRef = volumeGroupRef;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.sectorOffset = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.rawCapacity = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.raidLevel.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.volumeGroupRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.freeExtentRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(12);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putLong(this.sectorOffset);
        xDROutputStream.putLong(this.rawCapacity);
        this.raidLevel.xdrEncode(xDROutputStream);
        this.volumeGroupRef.xdrEncode(xDROutputStream);
        this.freeExtentRef.xdrEncode(xDROutputStream);
        xDROutputStream.putFixedOpaque(this.reserved1, 12);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.setLength(n);
    }
}

