/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0910api01.symbol;

import devmgr.v0910api01.jrpc.RPCError;
import devmgr.v0910api01.jrpc.XDRInputStream;
import devmgr.v0910api01.jrpc.XDROutputStream;
import devmgr.v0910api01.jrpc.XDRType;
import devmgr.v0910api01.symbol.ControllerRef;
import devmgr.v0910api01.symbol.SYMbolAPIConstants;

public class EthernetParamsUpdateDescriptor
implements XDRType,
SYMbolAPIConstants {
    private ControllerRef controllerRef = new ControllerRef();
    private String interfaceName;
    private int channel;
    private int ip;
    private int gatewayIp;
    private int subnetMask;

    public EthernetParamsUpdateDescriptor() {
    }

    public EthernetParamsUpdateDescriptor(EthernetParamsUpdateDescriptor ethernetParamsUpdateDescriptor) {
        this.controllerRef = ethernetParamsUpdateDescriptor.controllerRef;
        this.interfaceName = ethernetParamsUpdateDescriptor.interfaceName;
        this.channel = ethernetParamsUpdateDescriptor.channel;
        this.ip = ethernetParamsUpdateDescriptor.ip;
        this.gatewayIp = ethernetParamsUpdateDescriptor.gatewayIp;
        this.subnetMask = ethernetParamsUpdateDescriptor.subnetMask;
    }

    public int getChannel() {
        return this.channel;
    }

    public ControllerRef getControllerRef() {
        return this.controllerRef;
    }

    public int getGatewayIp() {
        return this.gatewayIp;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public int getIp() {
        return this.ip;
    }

    public int getSubnetMask() {
        return this.subnetMask;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public void setControllerRef(ControllerRef controllerRef) {
        this.controllerRef = controllerRef;
    }

    public void setGatewayIp(int n) {
        this.gatewayIp = n;
    }

    public void setInterfaceName(String string) {
        this.interfaceName = string;
    }

    public void setIp(int n) {
        this.ip = n;
    }

    public void setSubnetMask(int n) {
        this.subnetMask = n;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.controllerRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.interfaceName = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.channel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.ip = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.gatewayIp = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.subnetMask = xDRInputStream.getInt();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.controllerRef.xdrEncode(xDROutputStream);
        xDROutputStream.putString(this.interfaceName);
        xDROutputStream.putInt(this.channel);
        xDROutputStream.putInt(this.ip);
        xDROutputStream.putInt(this.gatewayIp);
        xDROutputStream.putInt(this.subnetMask);
        xDROutputStream.setLength(n);
    }
}

