/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0910api01.symbol;

import devmgr.v0910api01.jrpc.RPCError;
import devmgr.v0910api01.jrpc.XDRInputStream;
import devmgr.v0910api01.jrpc.XDROutputStream;
import devmgr.v0910api01.jrpc.XDRType;
import devmgr.v0910api01.symbol.ComponentRef;
import devmgr.v0910api01.symbol.ESMInterfaceTypeData;
import devmgr.v0910api01.symbol.ESMStatus;
import devmgr.v0910api01.symbol.InterfaceSpeed;
import devmgr.v0910api01.symbol.Location;
import devmgr.v0910api01.symbol.SYMbolAPIConstants;

public class Esm
implements XDRType,
SYMbolAPIConstants {
    private ComponentRef esmRef = new ComponentRef();
    private ESMStatus status = new ESMStatus();
    private Location physicalLocation = new Location();
    private boolean nonRedundantAccess;
    private String partNumber;
    private String serialNumber;
    private long manufacturerDate;
    private String manufacturer;
    private String fruType;
    private String softwareVersion;
    private ESMInterfaceTypeData esmInterfaceData = new ESMInterfaceTypeData();
    private String productID;
    private int workingChannel;
    private InterfaceSpeed currentSpeed = new InterfaceSpeed();
    private InterfaceSpeed maxSpeed = new InterfaceSpeed();
    private byte[] reserved1;
    private byte[] reserved2;

    public Esm() {
    }

    public Esm(Esm esm) {
        this.esmRef = esm.esmRef;
        this.status = esm.status;
        this.physicalLocation = esm.physicalLocation;
        this.nonRedundantAccess = esm.nonRedundantAccess;
        this.partNumber = esm.partNumber;
        this.serialNumber = esm.serialNumber;
        this.manufacturerDate = esm.manufacturerDate;
        this.manufacturer = esm.manufacturer;
        this.fruType = esm.fruType;
        this.softwareVersion = esm.softwareVersion;
        this.esmInterfaceData = esm.esmInterfaceData;
        this.productID = esm.productID;
        this.workingChannel = esm.workingChannel;
        this.currentSpeed = esm.currentSpeed;
        this.maxSpeed = esm.maxSpeed;
        this.reserved1 = esm.reserved1;
        this.reserved2 = esm.reserved2;
    }

    public InterfaceSpeed getCurrentSpeed() {
        return this.currentSpeed;
    }

    public ESMInterfaceTypeData getEsmInterfaceData() {
        return this.esmInterfaceData;
    }

    public ComponentRef getEsmRef() {
        return this.esmRef;
    }

    public String getFruType() {
        return this.fruType;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public long getManufacturerDate() {
        return this.manufacturerDate;
    }

    public InterfaceSpeed getMaxSpeed() {
        return this.maxSpeed;
    }

    public boolean getNonRedundantAccess() {
        return this.nonRedundantAccess;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public Location getPhysicalLocation() {
        return this.physicalLocation;
    }

    public String getProductID() {
        return this.productID;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public ESMStatus getStatus() {
        return this.status;
    }

    public int getWorkingChannel() {
        return this.workingChannel;
    }

    public void setCurrentSpeed(InterfaceSpeed interfaceSpeed) {
        this.currentSpeed = interfaceSpeed;
    }

    public void setEsmInterfaceData(ESMInterfaceTypeData eSMInterfaceTypeData) {
        this.esmInterfaceData = eSMInterfaceTypeData;
    }

    public void setEsmRef(ComponentRef componentRef) {
        this.esmRef = componentRef;
    }

    public void setFruType(String string) {
        this.fruType = string;
    }

    public void setManufacturer(String string) {
        this.manufacturer = string;
    }

    public void setManufacturerDate(long l) {
        this.manufacturerDate = l;
    }

    public void setMaxSpeed(InterfaceSpeed interfaceSpeed) {
        this.maxSpeed = interfaceSpeed;
    }

    public void setNonRedundantAccess(boolean bl) {
        this.nonRedundantAccess = bl;
    }

    public void setPartNumber(String string) {
        this.partNumber = string;
    }

    public void setPhysicalLocation(Location location) {
        this.physicalLocation = location;
    }

    public void setProductID(String string) {
        this.productID = string;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public void setSoftwareVersion(String string) {
        this.softwareVersion = string;
    }

    public void setStatus(ESMStatus eSMStatus) {
        this.status = eSMStatus;
    }

    public void setWorkingChannel(int n) {
        this.workingChannel = n;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.esmRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.status.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.physicalLocation.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.nonRedundantAccess = xDRInputStream.getBoolean();
        }
        if (xDRInputStream.getPosition() < n) {
            this.partNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.serialNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.manufacturerDate = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.manufacturer = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.fruType = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.softwareVersion = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.esmInterfaceData.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.productID = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.workingChannel = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.currentSpeed.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.maxSpeed.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(8);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.esmRef.xdrEncode(xDROutputStream);
        this.status.xdrEncode(xDROutputStream);
        this.physicalLocation.xdrEncode(xDROutputStream);
        xDROutputStream.putBoolean(this.nonRedundantAccess);
        xDROutputStream.putString(this.partNumber);
        xDROutputStream.putString(this.serialNumber);
        xDROutputStream.putLong(this.manufacturerDate);
        xDROutputStream.putString(this.manufacturer);
        xDROutputStream.putString(this.fruType);
        xDROutputStream.putString(this.softwareVersion);
        this.esmInterfaceData.xdrEncode(xDROutputStream);
        xDROutputStream.putString(this.productID);
        xDROutputStream.putInt(this.workingChannel);
        this.currentSpeed.xdrEncode(xDROutputStream);
        this.maxSpeed.xdrEncode(xDROutputStream);
        xDROutputStream.putFixedOpaque(this.reserved1, 8);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.setLength(n);
    }
}

