/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0910api01.symbol;

import devmgr.v0910api01.jrpc.RPCError;
import devmgr.v0910api01.jrpc.XDRInputStream;
import devmgr.v0910api01.jrpc.XDROutputStream;
import devmgr.v0910api01.jrpc.XDRType;
import devmgr.v0910api01.symbol.DriveChannelErrorCounts;
import devmgr.v0910api01.symbol.LinkStatus;
import devmgr.v0910api01.symbol.SYMbolAPIConstants;

public class DriveChannelStatistics
implements XDRType,
SYMbolAPIConstants {
    private long startTimeStamp;
    private long endTimeStamp;
    private int totalIoCount;
    private int totalIoErrorCount;
    private LinkStatus linkStatus = new LinkStatus();
    private DriveChannelErrorCounts errorCounts = new DriveChannelErrorCounts();

    public DriveChannelStatistics() {
    }

    public DriveChannelStatistics(DriveChannelStatistics driveChannelStatistics) {
        this.startTimeStamp = driveChannelStatistics.startTimeStamp;
        this.endTimeStamp = driveChannelStatistics.endTimeStamp;
        this.totalIoCount = driveChannelStatistics.totalIoCount;
        this.totalIoErrorCount = driveChannelStatistics.totalIoErrorCount;
        this.linkStatus = driveChannelStatistics.linkStatus;
        this.errorCounts = driveChannelStatistics.errorCounts;
    }

    public long getEndTimeStamp() {
        return this.endTimeStamp;
    }

    public DriveChannelErrorCounts getErrorCounts() {
        return this.errorCounts;
    }

    public LinkStatus getLinkStatus() {
        return this.linkStatus;
    }

    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    public int getTotalIoCount() {
        return this.totalIoCount;
    }

    public int getTotalIoErrorCount() {
        return this.totalIoErrorCount;
    }

    public void setEndTimeStamp(long l) {
        this.endTimeStamp = l;
    }

    public void setErrorCounts(DriveChannelErrorCounts driveChannelErrorCounts) {
        this.errorCounts = driveChannelErrorCounts;
    }

    public void setLinkStatus(LinkStatus linkStatus) {
        this.linkStatus = linkStatus;
    }

    public void setStartTimeStamp(long l) {
        this.startTimeStamp = l;
    }

    public void setTotalIoCount(int n) {
        this.totalIoCount = n;
    }

    public void setTotalIoErrorCount(int n) {
        this.totalIoErrorCount = n;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.startTimeStamp = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.endTimeStamp = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.totalIoCount = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.totalIoErrorCount = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.linkStatus.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.errorCounts.xdrDecode(xDRInputStream);
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putLong(this.startTimeStamp);
        xDROutputStream.putLong(this.endTimeStamp);
        xDROutputStream.putInt(this.totalIoCount);
        xDROutputStream.putInt(this.totalIoErrorCount);
        this.linkStatus.xdrEncode(xDROutputStream);
        this.errorCounts.xdrEncode(xDROutputStream);
        xDROutputStream.setLength(n);
    }
}

